NX.define("Nexus.logging.view.Panel",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.logging.view.Loggers","Nexus.logging.view.Log","Nexus.logging.Icons"],xtype:"nx-logging-view-panel",title:"Logging",border:false,layout:{type:"vbox",align:"stretch"},initComponent:function(){var me=this,icons=Nexus.logging.Icons,sp=Sonatype.lib.Permissions,items=[],tabs=[],text="";if(sp.checkPermission("nexus:logconfig",sp.READ)){tabs.push({xtype:"nx-logging-view-loggers"});text="changing logging configuration"}if(sp.checkPermission("nexus:logs",sp.READ)){tabs.push({xtype:"nx-logging-view-log"});if(!Ext.isEmpty(text)){text+=" and "}text+="viewing the current log"}items.push({xtype:"panel",border:false,cls:"nx-logging-view-panel-description",html:icons.get("logging").variant("x32").img+"<div>"+(!Ext.isEmpty(text)?"Allows "+text+". ":""),height:60,flex:0});if(tabs.length>0){items.push({xtype:"tabpanel",border:false,plain:true,layoutOnTabChange:true,flex:1,items:tabs,activeItem:0})}Ext.apply(me,{items:items});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.logging.view.Add",{extend:"Ext.Window",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.logging.Icons"],xtype:"nx-logging-view-add",cls:"nx-logging-view-add",title:"Add logger",autoShow:true,constrain:true,resizable:false,width:500,border:false,modal:true,initComponent:function(){var me=this,icons=Nexus.logging.Icons,loggerNamePattern=/^[a-zA-Z0-9_.]+$/;Ext.apply(me,{items:[{xtype:"panel",border:false,cls:"nx-logging-view-add-description",html:icons.get("loggers_add").variant("x32").img+"<div>Add a logger with a specific level.</div>"},{xtype:"form",itemId:"form",border:false,monitorValid:true,layoutConfig:{labelSeparator:""},items:[{xtype:"textfield",fieldLabel:"Logger",itemCls:"required-field",helpText:"Enter a logger name",name:"name",allowBlank:false,validateOnBlur:false,anchor:"96%",validator:function(value){return loggerNamePattern.test(value)},invalidText:"This field should only contain letters, numbers, _ and ."},{xtype:"nx-logging-combo-logger-level",fieldLabel:"Level",itemCls:"required-field",name:"level",value:"INFO",width:80}],buttonAlign:"right",buttons:[{text:"Cancel",xtype:"link-button",handler:me.close,scope:me},{text:"Save",formBind:true,id:"nx-logging-button-add-save"}]}],keys:[{key:Ext.EventObject.ENTER,scope:me,fn:function(){if(me.getComponent("form").getForm().isValid()){var btn=Ext.getCmp("nx-logging-button-add-save");btn.fireEvent("click",btn)}}},{key:Ext.EventObject.ESC,scope:me,fn:me.close}],listeners:{show:function(component){component.find("name","name")[0].focus(false,100)}}});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.logging.view.Loggers",{extend:"Ext.grid.EditorGridPanel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.logging.Icons","Nexus.logging.store.Logger","Nexus.logging.view.LoggerLevel"],xtype:"nx-logging-view-loggers",title:"Loggers",stripeRows:true,border:false,autoScroll:true,clicksToEdit:1,viewConfig:{emptyText:"No loggers defined.",emptyTextWhileFiltering:"No loggers matched criteria: {criteria}",deferEmptyText:false},loadMask:{msg:"Loading...",msgCls:"loading-indicator"},autoExpandColumn:"name",initComponent:function(){var me=this,icons=Nexus.logging.Icons,sp=Sonatype.lib.Permissions;Ext.apply(me,{store:NX.create("Nexus.logging.store.Logger"),columns:[{width:30,resizable:false,sortable:false,fixed:true,hideable:false,menuDisabled:true,renderer:function(value,metaData,record){return icons.get("logger").img}},{id:"name",header:"Name",dataIndex:"name",sortable:true},{id:"level",header:"Level",dataIndex:"level",sortable:true,width:80,tooltip:"Double click to edit",editor:{xtype:"nx-logging-combo-logger-level",listeners:{select:function(){me.stopEditing(false)}}}}],tbar:[{id:"nx-logging-button-refresh-loggers",text:"Refresh",tooltip:"Refresh loggers",iconCls:icons.get("loggers_refresh").cls},{id:"nx-logging-button-add-logger",text:"Add",tooltip:"Add new logger",iconCls:icons.get("loggers_add").cls,disabled:!sp.checkPermission("nexus:logconfig",sp.EDIT)},{id:"nx-logging-button-remove-loggers",text:"Remove",tooltip:"Remove selected logger",iconCls:icons.get("loggers_remove").cls,disabled:true},"-",{id:"nx-logging-button-reset-loggers",text:"Reset",tooltip:"Reset loggers to their default levels",iconCls:icons.get("loggers_reset").cls,disabled:!sp.checkPermission("nexus:logconfig",sp.EDIT)},"->",{xtype:"nx-grid-filter-box",filteredGrid:me}]});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.logging.view.Mark",{extend:"Ext.Window",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.logging.Icons"],xtype:"nx-logging-view-mark",cls:"nx-logging-view-mark",title:"Mark log",autoShow:true,constrain:true,resizable:false,width:500,border:false,modal:true,initComponent:function(){var me=this,icons=Nexus.logging.Icons;Ext.apply(me,{items:[{xtype:"panel",border:false,cls:"nx-logging-view-mark-description",html:icons.get("log_mark").variant("x32").img+"<div>Mark the log with a unique message for reference.</div>"},{xtype:"form",itemId:"form",border:false,monitorValid:true,layoutConfig:{labelSeparator:""},items:[{xtype:"textfield",fieldLabel:"Message",itemCls:"required-field",helpText:"Message to be included in the log",name:"message",allowBlank:false,validateOnBlur:false,anchor:"96%"}],buttonAlign:"right",buttons:[{text:"Cancel",xtype:"link-button",formBind:false,handler:me.close,scope:me},{text:"Save",formBind:true,id:"nx-logging-button-mark-save"}]}],keys:[{key:Ext.EventObject.ENTER,scope:me,fn:function(){if(me.getComponent("form").getForm().isValid()){var btn=Ext.getCmp("nx-logging-button-mark-save");btn.fireEvent("click",btn)}}},{key:Ext.EventObject.ESC,scope:me,fn:me.close}],listeners:{show:function(component){component.find("name","message")[0].focus(false,100)}}});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.logging.view.LoggerLevel",{extend:"Ext.form.ComboBox",xtype:"nx-logging-combo-logger-level",initComponent:function(){var me=this;Ext.apply(me,{triggerAction:"all",lazyRender:true,mode:"local",emptyText:"Select...",editable:false,store:NX.create("Ext.data.ArrayStore",{id:0,fields:["level","text"],data:[["TRACE","TRACE"],["DEBUG","DEBUG"],["INFO","INFO"],["WARN","WARN"],["ERROR","ERROR"],["OFF","OFF"],["DEFAULT","DEFAULT"]]}),valueField:"level",displayField:"text"});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.logging.view.Log",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],xtype:"nx-logging-view-log",title:"Log",id:"nx-logging-view-log",cls:"nx-logging-view-log",layout:"fit",initComponent:function(){var me=this,icons=Nexus.logging.Icons,sp=Sonatype.lib.Permissions;Ext.apply(me,{id:"nx-logging-view-log",items:{xtype:"textarea",readOnly:true,hideLabel:true,emptyText:"Refresh to display log",anchor:"100% 100%"},tbar:[{id:"nx-logging-button-refresh-log",text:"Refresh",tooltip:"Refresh log",iconCls:icons.get("log_refresh").cls},{id:"nx-logging-button-download-log",text:"Download",tooltip:"Download log file",iconCls:icons.get("log_download").cls},"-",{id:"nx-logging-button-mark",text:"Mark",tooltip:"Add a mark in Nexus log file",iconCls:icons.get("log_mark").cls,disabled:!sp.checkPermission("nexus:logconfig",sp.EDIT)},"->",{xtype:"combo",id:"nx-logging-combo-refresh-period",triggerAction:"all",lazyRender:true,mode:"local",emptyText:"Select...",editable:false,value:0,store:NX.create("Ext.data.ArrayStore",{id:0,fields:["seconds","text"],data:[[0,"Refresh manually"],[20,"Refresh every 20 seconds"],[60,"Refresh every minute"],[120,"Refresh every 2 minutes"],[300,"Refresh every 5 minutes"]]}),valueField:"seconds",displayField:"text"},{xtype:"combo",id:"nx-logging-combo-refresh-size",triggerAction:"all",lazyRender:true,mode:"local",emptyText:"Select...",editable:false,width:90,value:25,store:NX.create("Ext.data.ArrayStore",{id:0,fields:["kb","text"],data:[[25,"Last 25KB"],[50,"Last 50KB"],[100,"Last 100KB"]]}),valueField:"kb",displayField:"text"}]});me.constructor.superclass.initComponent.apply(me,arguments);me.retrieveLogTask={interval:0,started:false,changeInterval:function(millis){me.retrieveLogTask.interval=millis;me.retrieveLogTask.stop();me.retrieveLogTask.start()},start:function(){if(me.retrieveLogTask.run){if(me.retrieveLogTask.interval>0){Ext.TaskMgr.start(me.retrieveLogTask);me.retrieveLogTask.started=true;me.logDebug("Started refreshing log every "+me.retrieveLogTask.interval/1000+" seconds")}else{me.retrieveLogTask.run()}}},stop:function(){if(me.retrieveLogTask.started){Ext.TaskMgr.stop(me.retrieveLogTask);me.retrieveLogTask.started=false;me.logDebug("Stopped refreshing log")}}}},showLog:function(text){var textarea=this.down("textarea");textarea.setValue(text);textarea.getEl().dom.scrollTop=1000000}});
NX.define("Nexus.logging.Icons",{extend:"Nexus.util.IconContainer",singleton:true,constructor:function(){var me=this;function iconConfig(fileName,variants){var config={};if(variants===undefined){variants=["x32","x16"]}Ext.each(variants,function(variant){config[variant]=variant+"/"+fileName});return config}me.constructor.superclass.constructor.call(me,{stylePrefix:"nx-logging-icon-",icons:{arrow_refresh:"arrow_refresh.png",download:iconConfig("download.png"),book:iconConfig("book.png"),book_add:iconConfig("book_add.png"),book_delete:iconConfig("book_delete.png"),bookmark_red:iconConfig("bookmark_red.png"),arrow_undo_orange:iconConfig("arrow_undo_orange.png"),logging:"@book",logger:"@book",loggers_refresh:"@arrow_refresh",loggers_add:"@book_add",loggers_remove:"@book_delete",loggers_reset:"@arrow_undo_orange",log_refresh:"@arrow_refresh",log_download:"@download",log_mark:"@bookmark_red"}})}});
NX.define("Nexus.logging.store.Logger",{extend:"Ext.data.Store",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.siesta"],constructor:function(){var me=this;Ext.apply(me,{storeId:"nx-logging-store-logger",autoDestroy:true,restful:true,sortInfo:{field:"name",direction:"ASC"},proxy:NX.create("Ext.data.HttpProxy",{url:Nexus.siesta.basePath+"/logging/loggers"}),reader:NX.create("Ext.data.JsonReader",{root:"",idProperty:"name",fields:["name","level"]}),writer:NX.create("Ext.data.JsonWriter",{encode:false,render:function(params,baseParams,data){params.jsonData=data}})});me.constructor.superclass.constructor.call(me);Ext.apply(me.reader,{getSuccess:function(obj){return Ext.isDefined(obj)}})}});
NX.define("Nexus.logging.controller.Logging",{extend:"Nexus.controller.Controller",requires:["Nexus.siesta","Nexus.logging.Icons","Nexus.logging.view.Panel","Nexus.logging.view.Add","Nexus.logging.view.Mark","Nexus.util.DownloadHelper"],init:function(){var me=this;me.control({"#logging":{afterrender:me.bindToLoggersGrid,activate:me.onLoggingActivate,deactivate:me.onLoggingDeactivate,beforedestroy:me.onLoggingDeactivate},"#nx-logging-button-refresh-loggers":{click:me.loadLoggers},"#nx-logging-button-add-logger":{click:me.showAddLogger},"#nx-logging-button-remove-loggers":{click:me.removeLogger},"#nx-logging-button-reset-loggers":{click:me.resetLoggers},"#nx-logging-button-mark":{click:me.showMarkLog},"#nx-logging-button-add-save":{click:me.addLogger},"#nx-logging-button-mark-save":{click:me.markLog},"#nx-logging-view-log":{activate:me.onLogTabActivate,deactivate:me.onLogTabDeactivate},"#nx-logging-button-refresh-log":{click:me.refreshLog},"#nx-logging-combo-refresh-period":{select:me.changeRefreshPeriod},"#nx-logging-combo-refresh-size":{select:me.changeRefreshSize},"#nx-logging-button-download-log":{click:me.downloadLog}});me.addNavigationMenu()},addNavigationMenu:function(){Sonatype.Events.on("nexusNavigationInit",function(panel){var sp=Sonatype.lib.Permissions;if(sp.checkPermission("nexus:logconfig",sp.READ)||sp.checkPermission("nexus:logs",sp.READ)){panel.add({enabled:true,sectionId:"st-nexus-config",title:"Logging",tabId:"logging",tabCode:function(){return Ext.create({xtype:"nx-logging-view-panel",id:"logging"})}})}})},bindToLoggersGrid:function(loggingPanel){var me=this,grid=loggingPanel.down("nx-logging-view-loggers"),store=grid.getStore();me.controlSelection(grid);store.on("write",me.onSuccessfulWrite,me);store.load()},loadLoggers:function(button){var loggersGrid=button.up("nx-logging-view-loggers"),store=loggersGrid.getStore();store.load()},controlSelection:function(loggersGrid){var sp=Sonatype.lib.Permissions,removeBtn;if(sp.checkPermission("nexus:logconfig",sp.EDIT)){removeBtn=loggersGrid.getTopToolbar().down("#nx-logging-button-remove-loggers");loggersGrid.getSelectionModel().on("selectionchange",function(sm,selection){if(sm.hasSelection()&&selection.record.get("name")!=="ROOT"){removeBtn.enable()}else{removeBtn.disable()}})}},onSuccessfulWrite:function(store,action,result,res,rs){if(Ext.isDefined(rs)){Ext.each(rs,function(record){var name=record.get("name");if(action===Ext.data.Api.actions.create){Nexus.messages.show("Logging","Logger added: "+name)}else{if(action===Ext.data.Api.actions.update){Nexus.messages.show("Logging","Logger updated: "+name)}else{if(action===Ext.data.Api.actions.destroy){Nexus.messages.show("Logging","Logger removed: "+name)}}}});store.load()}},showAddLogger:function(button){var win=Ext.create({xtype:"nx-logging-view-add"});win.grid=button.up("nx-logging-view-loggers");win.show()},addLogger:function(button){var me=this,win=button.up("nx-logging-view-add"),store=win.grid.getStore(),form=win.down("form").getForm(),values=form.getFieldValues(),record=store.getById(values.name);if(Ext.isDefined(record)){Ext.Msg.show({title:"Confirm",msg:'Logger "'+values.name+'" is already configured. Would you like to update its level to "'+values.level+'"?',buttons:Ext.Msg.YESNO,icon:Ext.MessageBox.QUESTION,closeable:false,scope:me,fn:function(buttonName){if(buttonName==="yes"){record.set("level",values.level);store.save();win.grid.getSelectionModel().select(store.indexOf(record),1);win.close()}}})}else{record=new store.recordType(values);store.addSorted(record);win.grid.getSelectionModel().select(store.indexOf(record),1);win.close()}},removeLogger:function(button){var loggersGrid=button.up("nx-logging-view-loggers"),sm=loggersGrid.getSelectionModel(),store=loggersGrid.getStore(),icons=Nexus.logging.Icons,name;if(sm.hasSelection()){name=sm.selection.record.get("name");Ext.Msg.show({title:"Remove logger",msg:'Remove "'+name+'" logger ?',buttons:Ext.Msg.OKCANCEL,icon:icons.get("loggers_remove").variant("x32").cls,fn:function(btn){if(btn==="ok"){store.remove(sm.selection.record)}}})}},resetLoggers:function(button){var loggersGrid=button.up("nx-logging-view-loggers"),store=loggersGrid.getStore(),icons=Nexus.logging.Icons;Ext.Msg.show({title:"Reset loggers",msg:"Reset loggers to their default levels?",buttons:Ext.Msg.OKCANCEL,icon:icons.get("loggers_reset").variant("x32").cls,fn:function(btn){if(btn==="ok"){Ext.Ajax.request({url:Nexus.siesta.basePath+"/logging/loggers",method:"DELETE",suppressStatus:true,callback:function(){store.load()},success:function(){Nexus.messages.show("Logging","Loggers had been reset")},failure:function(response){Nexus.messages.show("Logging","Failed to reset loggers: "+me.parseExceptionMessage(response))}})}}})},showMarkLog:function(){Ext.create({xtype:"nx-logging-view-mark"}).show()},markLog:function(button){var me=this,win=button.up("nx-logging-view-mark"),form=win.down("form").getForm(),values=form.getFieldValues();win.close();Ext.Ajax.request({url:Nexus.siesta.basePath+"/logging/log/mark",method:"PUT",suppressStatus:true,jsonData:values,success:function(){Nexus.messages.show("Logging","Log has been marked with: "+values.message);me.retrieveLog(Ext.getCmp("nx-logging-view-log"))},failure:function(response){Nexus.messages.show("Logging","Failed to mark log file: "+me.parseExceptionMessage(response))}})},refreshLog:function(button){this.retrieveLog(button.up("nx-logging-view-log"))},downloadLog:function(){Nexus.util.DownloadHelper.downloadUrl(Nexus.siesta.basePath+"/logging/log")},onLogTabActivate:function(logPanel){var me=this,task=logPanel.retrieveLogTask;task.run=function(){me.retrieveLog(logPanel)};task.start()},onLogTabDeactivate:function(logPanel){var task=logPanel.retrieveLogTask;task.stop();delete task.run},onLoggingActivate:function(panel){var logPanel=panel.down("nx-logging-view-log");if(Ext.isDefined(logPanel)){logPanel.retrieveLogTask.start()}},onLoggingDeactivate:function(panel){var logPanel=panel.down("nx-logging-view-log");if(Ext.isDefined(logPanel)){logPanel.retrieveLogTask.stop()}},changeRefreshPeriod:function(combo,record){var millis=record.get("seconds")*1000,logPanel=combo.up("nx-logging-view-log"),task=logPanel.retrieveLogTask;task.changeInterval(millis)},changeRefreshSize:function(combo){this.retrieveLog(combo.up("nx-logging-view-log"))},retrieveLog:function(logPanel){var me=this,size=logPanel.getTopToolbar().down("#nx-logging-combo-refresh-size").getValue(),mask;mask=NX.create("Ext.LoadMask",logPanel.body,{msg:"Loading..."});mask.show();me.logDebug("Retrieving last "+size+"kb from log");Ext.Ajax.request({url:Nexus.siesta.basePath+"/logging/log",method:"GET",headers:{accept:"text/plain"},params:{bytesCount:-1024*size},scope:me,suppressStatus:true,success:function(response){mask.hide();logPanel.showLog(response.responseText)},failure:function(response){mask.hide();logPanel.showLog('Failed to retrieve log due to "'+me.parseExceptionMessage(response)+'".')}})}});
define("nexus-logging-plugin-boot",["Nexus/logging/controller/Logging"],function(){NX.log.debug("Main nexus-logging-plugin modules loaded");NX.create("Nexus.logging.controller.Logging").init()});
