NX.define("Nexus.wonderland.view.FileCreated",{extend:"Ext.Window",xtype:"nx-wonderland-view-file-created",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.wonderland.Icons","Nexus.wonderland.AuthenticateButton"],fileIcon:undefined,fileType:undefined,downloadButtonId:undefined,cls:"nx-wonderland-view-file-created",autoShow:true,constrain:true,resizable:false,width:500,border:false,modal:true,initComponent:function(){var me=this;Ext.apply(me,{title:me.title||me.fileType+" Created",items:[{xtype:"component",border:false,cls:"nx-wonderland-view-file-created-description",html:me.fileIcon.img+"<div>"+me.fileType+" has been created.<br/><br/>You can reference this file on the filesystem or download the file from your browser.</div>"},{xtype:"form",itemId:"form",border:false,monitorValid:true,layoutConfig:{labelSeparator:"",labelWidth:40},labelAlign:"right",items:[{xtype:"textfield",fieldLabel:"Name",helpText:me.fileType+" file name",name:"name",readOnly:true,grow:true,style:{border:0,background:"none"}},{xtype:"textfield",fieldLabel:"Size",helpText:"Size of "+me.fileType+" file in bytes",name:"size",readOnly:true,grow:true,style:{border:0,background:"none"}},{xtype:"textfield",fieldLabel:"Path",helpText:me.fileType+" file location",name:"file",readOnly:true,selectOnFocus:true,anchor:"96%"},{xtype:"hidden",name:"truncated"}],buttonAlign:"right",buttons:[{text:"Close",xtype:"link-button",handler:me.close,scope:me},{text:"Download",xtype:"nx-wonderland-button-authenticate",formBind:true,id:me.downloadButtonId}]}],keys:[{key:Ext.EventObject.ENTER,scope:me,fn:function(){var btn=Ext.getCmp(me.downloadButtonId);btn.fireEvent("click",btn)}},{key:Ext.EventObject.ESC,scope:me,fn:me.close}]});Nexus.wonderland.view.FileCreated.superclass.initComponent.apply(me,arguments)},setValues:function(values){this.down("form").getForm().setValues(values)},getValues:function(){return this.down("form").getForm().getValues()}});
NX.define("Nexus.wonderland.view.AuthenticateWindow",{extend:"Ext.Window",requires:["Nexus.wonderland.Icons"],mixins:["Nexus.LogAwareMixin"],xtype:"nx-wonderland-view-authenticate",title:"Authenticate",id:"nx-wonderland-view-authenticate",cls:"nx-wonderland-view-authenticate",border:false,closable:false,modal:true,height:190,width:350,resizable:false,message:"Authentication required",initComponent:function(){var me=this,icons=Nexus.wonderland.Icons;me.passwordField=NX.create("Ext.form.TextField",{fieldLabel:"Password",inputType:"password",name:"password",width:170,allowBlank:false,validateOnBlur:false});Ext.apply(me,{items:[{xtype:"form",height:160,monitorValid:true,layoutConfig:{labelSeparator:""},labelAlign:"right",items:[{xtype:"component",cls:"nx-wonderland-view-authenticate-description",html:icons.get("lock").variant("x32").img+"<div>"+me.message+'</div><br style="clear:both;"/>'},{xtype:"textfield",fieldLabel:"Username",name:"username",width:170,readOnly:true,preventMark:true},me.passwordField],buttons:[{text:"Confirm",formBind:true,scope:me,handler:me.fireValidate},{xtype:"link-button",text:"Cancel",formBind:false,scope:me,handler:me.close}],keys:[{key:Ext.EventObject.ENTER,scope:me,fn:me.fireValidate},{key:Ext.EventObject.ESC,scope:me,fn:me.close}]}],listeners:{show:function(component){component.find("name","username")[0].setValue(Nexus.currentUser().username);component.find("name","password")[0].focus(false,100);me.passwordField.markInvalid("This field is required")}}});me.constructor.superclass.initComponent.apply(me,arguments);me.addEvents("validate-credentials","authenticated")},fireValidate:function(){this.fireEvent("validate-credentials",this,Nexus.currentUser().username,this.passwordField.getValue())},markInvalid:function(){this.passwordField.markInvalid("Invalid password")}});
NX.define("Nexus.wonderland.Icons",{extend:"Nexus.util.IconContainer",singleton:true,constructor:function(){var me=this;function iconConfig(fileName,variants){var config={};if(variants===undefined){variants=["x32","x16"]}Ext.each(variants,function(variant){config[variant]=variant+"/"+fileName});return config}me.constructor.superclass.constructor.call(me,{stylePrefix:"nx-wonderland-icon-",icons:{lock:iconConfig("lock.png")}})}});
NX.define("Nexus.wonderland.AuthenticateButton",{extend:"Ext.Button",requires:["Nexus.siesta","Nexus.wonderland.Icons","Nexus.wonderland.view.AuthenticateWindow"],mixins:["Nexus.LogAwareMixin"],xtype:"nx-wonderland-button-authenticate",cls:"nx-wonderland-button-authenticate",message:"You have requested an operation which requires validation of your credentials.",initComponent:function(){var me=this,icons=Nexus.wonderland.Icons;Ext.apply(me,{cls:"x-btn-text-icon",iconCls:icons.get("lock").cls,scope:me,handler:me.showWindow});me.constructor.superclass.initComponent.apply(me,arguments);me.addEvents("authenticated")},showWindow:function(){var me=this;var win=NX.create("Nexus.wonderland.view.AuthenticateWindow",{message:me.message,animateTarget:me.getEl(),listeners:{authenticated:function(window,authticket){me.fireEvent("authenticated",me,authticket)}}});win.show()}});
NX.define("Nexus.wonderland.controller.Wonderland",{extend:"Nexus.controller.Controller",requires:["Nexus.siesta"],init:function(){var me=this;me.control({"#nx-wonderland-view-authenticate":{"validate-credentials":me.validateCredentials}})},validateCredentials:function(authwin,username,password){var me=this,mask;mask=new Ext.LoadMask(authwin.getEl(),{msg:"Authenticating"});mask.show();Ext.Ajax.request({url:Nexus.siesta.basePath+"/wonderland/authenticate",method:"POST",suppressStatus:[403],jsonData:{u:Sonatype.utils.base64.encode(username),p:Sonatype.utils.base64.encode(password)},scope:me,callback:function(){mask.hide()},success:function(response){me.logDebug("Authenticated");var authTicket=Ext.decode(response.responseText);me.logDebug("Ticket: "+authTicket.t);authwin.fireEvent("authenticated",me,authTicket.t);authwin.close()},failure:function(response){if(response.status===403){authwin.markInvalid()}}})}});
define("nexus-wonderland-plugin-boot",["Nexus/wonderland/controller/Wonderland"],function(){NX.log.debug("Module loaded: nexus-wonderland-plugin-boot");NX.create("Nexus.wonderland.controller.Wonderland").init()});
