NX.define("Nexus.healthcheck.view.HealthCheckPanel",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],title:"Health Check",border:false,healtchCheckStatusStore:new Ext.data.SimpleStore({fields:["value","display"],data:[["enabled","true"],["disabled","false"]]}),initComponent:function(){var me=this,onHealthCheckStatusUpdated=function(repositoryId,enabled){if(me.repositoryId===repositoryId){me.loadConfiguration()}};Ext.apply(me,{listeners:{activate:me.loadConfiguration,destroy:function(){Sonatype.Events.removeListener("healthCheckStatusUpdated",onHealthCheckStatusUpdated)}},items:[{xtype:"form",border:false,style:{padding:"10px"},defaults:{hideLabel:true,inputValue:"true"},items:[{xtype:"fieldset",checkboxToggle:false,title:"Configure Repository Health Check",anchor:Sonatype.view.FIELDSET_OFFSET,collapsible:false,autoHeight:true,layoutConfig:{labelSeparator:""},items:[{xtype:"combo",lazyInit:false,fieldLabel:"Enabled",itemCls:"required-field",helpText:"Enable or disable Health Check for this repository",name:"status",store:this.healtchCheckStatusStore,valueField:"value",displayField:"display",editable:false,forceSelection:true,mode:"local",triggerAction:"all",selectOnFocus:true,allowBlank:false,minListWidth:100}]}],buttonAlign:"left",buttons:[{xtype:"button",text:"Save",formBind:true,scope:me,handler:me.maybeSaveConfiguration},{xtype:"button",text:"Reset",formBind:true,scope:me,handler:me.loadConfiguration}]}]});me.constructor.superclass.initComponent.apply(me,arguments);Sonatype.Events.addListener("healthCheckStatusUpdated",onHealthCheckStatusUpdated)},loadConfiguration:function(){var me=this;me.logDebug("loading configuration");me.loadEulaStatus();Ext.Ajax.request({url:Sonatype.HealthCheckUtil.getStatusUrl(null,me.repositoryId),method:"GET",scope:me,success:function(response,opts){me.logDebug("Configuration: "+response.responseText);me.setValues(Ext.decode(response.responseText))}})},saveConfiguration:function(data){var me=this;Ext.Ajax.request({url:Sonatype.HealthCheckUtil.getStatusUrl(me.rhcEulaAccepted),method:"PUT",jsonData:Ext.apply(data,{id:me.repositoryId}),scope:me,success:function(){me.showMessage(data.status+" for "+me.repositoryId);Sonatype.Events.fireEvent("healthCheckStatusUpdated",me.repositoryId,"enabled"===data.status)}})},maybeSaveConfiguration:function(button){var me=this,values=me.getValues();values.status=values.status==="true"?"enabled":"disabled";me.logDebug("Saving settings: "+Ext.util.JSON.encode(values));if(!me.rhcEulaAccepted){me.showEula(values);return}me.saveConfiguration(values)},loadEulaStatus:function(){var me=this;Ext.Ajax.request({url:Sonatype.HealthCheckUtil.getBase()+"/healthCheckEula",method:"GET",scope:me,success:function(response,opts){me.logDebug("Eula acceptance: "+response.responseText);me.rhcEulaAccepted=Ext.decode(response.responseText).accepted}})},showEula:function(data){var me=this,accepted=false;var msg='<span style="font-size: 12px">The analysis of the repository '+me.repositoryId+' for security vulnerabilities and license issues is regulated by the following terms of use. Please read carefully and press "I Agree" to continue.</span>';me.rhcEulaWindow=NX.create("Ext.Window",{title:"CLM Terms of Use",closable:true,closeAction:"hide",autoWidth:false,width:725,autoHeight:true,autoScroll:false,modal:true,constrain:true,resizable:false,draggable:false,items:[{xtype:"panel",frame:true,html:msg},{xtype:"panel",autoScroll:true,height:450,items:[{xtype:"panel",autoLoad:{url:Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("healthcheck-tos.html"),headers:{accept:"text/html"}}},{xtype:"panel",html:'<a href="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("healthcheck-tos.html")+'" target="_new">Download copy of TOS</a>'}]}],buttonAlign:"center",buttons:[{text:"I Agree",handler:function(){me.rhcEulaAccepted=true;me.saveConfiguration(data);me.rhcEulaWindow.hide()}},{text:"I Don't Agree",handler:function(){me.rhcEulaWindow.hide();me.showMessage("EULA refused, changes are not saved")}}]});me.rhcEulaWindow.show()},showMessage:function(message){Nexus.messages.show("Health Check",message)},getValues:function(){return this.down("form").getForm().getValues()},setValues:function(values){this.down("form").getForm().setValues(values)},field:function(fieldName){return this.down("form").getForm().findField(fieldName)}});
define("Nexus/healthcheck/HealthCheckAboutContrib",function(){HealthCheckAboutContrib=function(){Sonatype.Events.addListener("aboutPanelContributions",function(helpItems){if(helpItems){helpItems.push({text:'<div class="little-padding">The HealthCheck plugin needs to access Sonatype\'s CLM data service to be fully functional.<br>Access to and use of the CLM Service is subject to Sonatype\'s separate <a href="http://links.sonatype.com/products/clm/tos" target="_new">terms of service</a> for the CLM Service.</div>'})}})};Ext.onReady(function(){Sonatype.HealthCheckAboutContrib=new HealthCheckAboutContrib()})});
define("Nexus/healthcheck/HealthCheckPluginConsoleContrib",["Nexus/healthcheck/HealthCheckUtil"],function(){HealthCheckPluginConsoleContrib=function(){var me=this;me.addDetailItem=function(labelText,valueName,valueText){var pluginDetailPanel=me.pluginInfoTab.items.get(0);pluginDetailPanel.add({xtype:"label",html:labelText,style:me.pluginInfoTab.labelClass,width:120});pluginDetailPanel.add({xtype:"label",name:valueName,html:valueText,style:me.pluginInfoTab.textClass})};me.getInstanceData=function(pluginInfoTab){me.pluginInfoTab=pluginInfoTab;me.tabId=pluginInfoTab.getId();Ext.Ajax.request({callback:function(options,success,response){if(success&&Ext.get(me.tabId)){var json=Ext.decode(response.responseText);if(!Ext.isEmpty(json.nexusId)){me.addDetailItem("Nexus ID","nexusId",json.nexusId);me.pluginInfoTab.items.get(0).doLayout()}}},url:Sonatype.HealthCheckUtil.getBase()+"/healthCheckInfo",suppressStatus:[0,500]})};Sonatype.Events.addListener("pluginInfoTabInit",function(pluginInfoTab){if(pluginInfoTab.payload.data.name=="Nexus CLM Plugin"){me.getInstanceData(pluginInfoTab)}})};Ext.onReady(function(){Sonatype.HealthCheckPluginConsoleContrib=new HealthCheckPluginConsoleContrib()})});
define("Nexus/healthcheck/HealthCheckRepositoryContrib",["Nexus/healthcheck/HealthCheckUtil"],function(){HealthCheckRepositoryContrib=function(config){var me=this;me.reset=function(config){var config=config||{};var defaultConfig={isHealthCheckUpdate:false,healthCheckWindow:null,healthCheckStatusTask:null,healthCheckDataMap:[],healthCheckCellMouseRecordId:false,rhcAnalyzingState:true,rhcEulaAccepted:false,rhcConfiguredForNew:false,rhcToolbarHeight:26,healthCheckStatusError:false,healthCheckTooltip:null,grid:null};Ext.apply(me,config,defaultConfig);if(me.grid){me.grid.store.addListener("load",function(store,records,options){me.rhcAnalyzingState=true;me.startRHCPollTask();me.generateHealthCheckTooltip()});me.grid.store.addListener("add",function(store,records,index){if(records.length==1){if(!me.healthCheckDataMap[records[0].get("id")]&&me.isProxyRepository(records[0])){var healthCheckData={};healthCheckData.status=me.rhcConfiguredForNew?"analyzing":"disabled";me.healthCheckDataMap[records[0].get("id")]=healthCheckData}}});me.grid.mon(me.grid,"mouseover",function(e,t){var row=me.grid.getView().findRowIndex(t);var col=me.grid.getView().findCellIndex(t);me.healthCheckCellMouseRecordId=null;if(row!==false&&col==me.grid.getColumnModel().getIndexById("healthCheckColumn")){var record=me.grid.store.getAt(row);var id=record.get("id");var healthCheckData=me.healthCheckDataMap[id];if(!me.healthCheckStatusError&&healthCheckData&&healthCheckData.status=="enabled"&&me.isRepositoryInService(record)){me.healthCheckCellMouseRecordId=id;me.openSummary(Ext.get(me.grid.getView().getCell(row,col)),record)}}});me.grid.mon(me.grid,"mouseout",function(e,t){me.healthCheckCellMouseRecordId=null})}};me.reset(config);me.isRepositoryInService=function(record){var status=record.get("status");if(status){status=status.localStatus}return status=="IN_SERVICE"};me.isProxyRepository=function(record){return record.get("repoType")=="proxy"};me.isUnsupportedRepository=function(record){return !me.isProxyRepository(record)||record.get("repoPolicy")=="Snapshot"||!me.isRepositoryInService(record)};me.showEula=function(acceptHandler){var msg='<span style="font-size: 12px">The analysis of repositories for security vulnerabilities and license issues is regulated by the following terms of use. Please read carefully and press "I Agree" to continue.</span>',rhcEulaWindow=new Ext.Window({title:"CLM Terms of Use",closable:true,closeAction:"hide",autoWidth:false,width:725,autoHeight:true,autoScroll:false,modal:true,constrain:true,resizable:false,draggable:false,items:[{xtype:"panel",frame:true,html:msg},{xtype:"panel",autoScroll:true,height:450,items:[{xtype:"panel",autoLoad:{url:Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("healthcheck-tos.html"),headers:{accept:"text/html"}}},{xtype:"panel",html:'<a href="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("healthcheck-tos.html")+'" target="_new">Download copy of TOS</a>'}]}],buttonAlign:"center",buttons:[{text:"I Agree",handler:function(){rhcEulaWindow.hide();acceptHandler()}},{text:"I Don't Agree",handler:function(){rhcEulaWindow.hide()}}]});rhcEulaWindow.show()};me.updateColumns=function(columns){columns.splice(8,0,{name:"resourceURI",header:"Health Check",id:"healthCheckColumn",width:100,renderer:function(value,metadata,record,rowIndex,colIndex,store){var healthCheckData=me.healthCheckDataMap[record.get("id")];if(me.healthCheckStatusError){return'<div><img class="opaqueWarning" src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/exclamation.png")+'"></div>'}else{if(me.isUnsupportedRepository(record)){return'<div><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/analyze_disabled.png")+'"></div>'}else{if(!healthCheckData){return"Loading..."}else{if(healthCheckData.status=="enabled"){metadata.css="cursorPointerCell badgeCell";return'<div><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/security-alert.png")+'">&nbsp;'+healthCheckData.securityIssueCount+'&nbsp;&nbsp;<img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/license-alert.png")+'" style="margin-left:10px">&nbsp;'+healthCheckData.licenseIssueCount+"</div>"}else{if(Sonatype.HealthCheckUtil.hasEditPerm()&&healthCheckData.status=="disabled"){metadata.css="cursorPointerCell";return'<div><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/analyze.png")+'"></div>'}else{if(healthCheckData.status=="disabled"){return'<div><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/analyze_disabled.png")+'"></div>'}else{if(healthCheckData.status=="analyzing"){return'<div><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/analyzing.png")+'"></div>'}}}}}}}},clickHandler:function(grid,rowIndex,eventObject){var record=me.grid.getStore().getAt(rowIndex);var healthCheckData=me.healthCheckDataMap[record.get("id")];if(healthCheckData){if(me.isUnsupportedRepository(record)){}else{if(!me.healthCheckStatusError&&healthCheckData.status=="enabled"){var el=Ext.get(me.grid.getView().getCell(rowIndex,me.grid.getColumnModel().getIndexById("healthCheckColumn")));me.healthCheckSummaryClick(record,el.getLeft(),el.getTop())}else{if(healthCheckData.status=="disabled"&&Sonatype.HealthCheckUtil.hasEditPerm()){Sonatype.MessageBox.show({title:"Analyze Repository",msg:"Do you want to analyze the repository "+Ext.util.Format.htmlEncode(record.get("name"))+" and others for security vulnerabilities and license issues?",buttons:{ok:"Yes, all repositories",yes:"Yes, only this repository",no:true},icon:Sonatype.MessageBox.QUESTION,fn:function(btnId){var recordToEnable=btnId==="yes"?record:(btnId==="ok"?"all":null);if(recordToEnable){if(!me.rhcEulaAccepted){me.showEula(function(){me.updateHealthCheck(recordToEnable,true,true)})}else{me.updateHealthCheck(recordToEnable,true)}}}});if(me.healthCheckTooltip){me.healthCheckTooltip.hide()}}}}}}})};me.openSummary=function(cellEl,record,deferred){if(deferred){if(me.healthCheckCellMouseRecordId===record.get("id")){me.healthCheckSummaryClick(record,cellEl.getLeft(),cellEl.getTop())}}else{me.openSummary.defer(500,me,[cellEl,record,true])}};me.startRHCPollTask=function(){me.healthCheckStatusTask={run:function(){if(!Ext.get(this.gridComponentId)||me.healthCheckStatusTask!=this){return false}if(!me.rhcAnalyzingState){return}Ext.Ajax.request({callback:function(options,success,response){if(success){me.healthCheckStatusError=false;var json=Ext.decode(response.responseText);var store=me.grid.getStore();me.rhcAnalyzingState=false;me.rhcEulaAccepted=json.eulaAccepted;me.rhcConfiguredForNew=json.configuredForNewRepositories;for(var i=0;i<json.repositories.length;i++){if(json.repositories[i].status=="analyzing"){me.rhcAnalyzingState=true}var record=me.findRecord(store,json.repositories[i].id);if(record){var data=me.healthCheckDataMap[record.get("id")];me.healthCheckDataMap[record.get("id")]=json.repositories[i];if(!data||data.healthCheckSummaryUrl!=json.repositories[i].healthCheckSummaryUrl||data.iframeWidth!=json.repositories[i].iframeWidth||data.iframeHeight!=json.repositories[i].iframeHeight||data.status!=json.repositories[i].status||data.securityIssueCount!=json.repositories[i].securityIssueCount||data.licenseIssueCount!=json.repositories[i].licenseIssueCount){me.grid.getView().refreshRow(record)}}}}else{if(!me.healthCheckStatusError){me.healthCheckStatusError=true;me.grid.getView().refresh()}me.rhcAnalyzingState=false}},url:Sonatype.HealthCheckUtil.getStatusUrl(),suppressStatus:[0,500]})},interval:10000,gridComponentId:me.grid.getId()};Ext.TaskMgr.start(me.healthCheckStatusTask)};me.findRecord=function(store,repositoryId){return store.getAt(store.findExact("id",repositoryId))};me.getHealthCheckSummarySizeParams=function(healthcheckdata){var sizeDeltas=Ext.state.Manager.get("healthcheck-summary-size-delta",{width:0,height:0});return{width:healthcheckdata.iframeWidth+sizeDeltas.width,height:healthcheckdata.iframeHeight+sizeDeltas.height}};me.healthCheckSummaryClick=function(record,x,y){if(Sonatype.HealthCheckUtil.hasSummaryReadPerm()){var bbarItems=[];var healthcheckdata=me.healthCheckDataMap[record.get("id")];var url=healthcheckdata.healthCheckSummaryUrl;if(!me.healthCheckWindow){Sonatype.Events.fireEvent("healthCheckWindowInit",me,bbarItems,record,healthcheckdata);var sizeParams=me.getHealthCheckSummarySizeParams(healthcheckdata);me.healthCheckWindow=new Ext.Window({id:"healthCheckWindow",closable:false,frame:false,border:true,layout:"fit",width:sizeParams.width,height:sizeParams.height+(bbarItems.length>0?me.rhcToolbarHeight:0),modal:false,constrain:true,resizable:true,draggable:true,x:x?x:undefined,y:y?y:undefined,bbar:bbarItems.length>0?bbarItems:undefined,items:[{xtype:"iframepanel",width:sizeParams.width,height:sizeParams.height,closable:true,loadMask:{msg:"Loading Health Check Summary..."},autoShow:true,id:"healthCheckIframe",defaultSrc:url,disableMessaging:false}],listeners:{resize:{fn:function(window,width,height){Ext.state.Manager.set("healthcheck-summary-size-delta",{width:width-window.healthcheckdata.iframeWidth,height:height-(window.getBottomToolbar()?me.rhcToolbarHeight:0)-window.healthcheckdata.iframeHeight})}}},healthcheckdata:healthcheckdata});me.healthCheckWindow.show();me.healthCheckWindow.el.on("mouseover",function(){me.healthCheckWindow.windowMouse=true});me.healthCheckWindow.el.on("mouseout",function(){var resizeElement=Ext.getDom("healthCheckWindow-rzproxy");if(Ext.isEmpty(resizeElement)||resizeElement.style.display!="block"){me.healthCheckWindow.windowMouse=false}});var closeFunction=function(){if(me.healthCheckWindow){if((!me.healthCheckWindow.windowMouse&&!me.healthCheckCellMouseRecordId)){me.closeHealthCheckWindow()}else{this.defer(1000,this)}}};closeFunction.defer(1000,closeFunction)}else{var iframeContainer=me.healthCheckWindow.getComponent("healthCheckIframe");if(iframeContainer.defaultSrc!=url){Sonatype.Events.fireEvent("healthCheckWindowInit",me,bbarItems,record,healthcheckdata);me.healthCheckWindow.healthcheckdata=healthcheckdata;iframeContainer.defaultSrc=url;iframeContainer.setSrc();var sizeParams=me.getHealthCheckSummarySizeParams(healthcheckdata);me.healthCheckWindow.setSize(sizeParams.width,sizeParams.height+(bbarItems.length>0?me.rhcToolbarHeight:0));if(x&&y){me.healthCheckWindow.setPosition(x,y)}var bbar=me.healthCheckWindow.getBottomToolbar();if(bbar){bbar.removeAll();if(bbarItems.length>0){for(var i=0;i<bbarItems.length;i++){bbar.add(bbarItems[i])}}}}}}};me.closeHealthCheckWindow=function(){if(me.healthCheckWindow!=null){me.healthCheckWindow.close();me.healthCheckWindow=null}};me.updateHealthCheck=function(record,enabled,appendEula){var opts={};opts.url=Sonatype.HealthCheckUtil.getStatusUrl(appendEula);opts.callback=function(options,success,response){if(enabled&&success){me.rhcEulaAccepted=true}};if("all"===record){opts.method="POST";opts.success=function(response,options){var store=me.grid.store;for(var i=0;i<store.getCount();i++){record=store.getAt(i);if(me.healthCheckDataMap[record.get("id")]){Sonatype.Events.fireEvent("healthCheckStatusUpdated",record.get("id"),enabled,record)}}me.rhcConfiguredForNew=true}}else{opts.method="PUT";opts.jsonData={id:record.get("id"),status:enabled?"enabled":"disabled"};opts.success=function(response,options){Sonatype.Events.fireEvent("healthCheckStatusUpdated",record.get("id"),enabled,record)}}Ext.Ajax.request(opts)};me.updateGridColumn=function(record,enabled){var healthCheckData=me.healthCheckDataMap[record.get("id")];if(healthCheckData){if(!enabled){healthCheckData.status="disabled";if(me.healthCheckWindow!=null&&me.healthCheckWindow.healthcheckdata.id==healthCheckData.id){me.closeHealthCheckWindow()}}else{if(healthCheckData.status==="disabled"){healthCheckData.status="analyzing";me.rhcAnalyzingState=true}}me.grid.getView().refreshRow(record)}};me.generateHealthCheckTooltip=function(){if(me.healthCheckTooltip){me.healthCheckTooltip.destroy()}me.healthCheckTooltip=new Ext.ToolTip({target:me.grid.getView().mainBody,delegate:".x-grid3-cell",maxWidth:500,mouseOffset:[0,0],renderTo:document.body,hideDelay:5000,baseCls:"x-tipcustom",cls:"healthCheckTooltip",items:[{xtype:"panel",frame:true,html:""}],listeners:{beforeshow:function(tip){var rowIndex=me.grid.getView().findRowIndex(tip.triggerElement);var cellIndex=me.grid.getView().findCellIndex(tip.triggerElement);var record=me.grid.getStore().getAt(rowIndex);if(!record||Sonatype.MessageBox.isVisible()){return false}if(cellIndex==me.grid.getColumnModel().getIndexById("healthCheckColumn")){var healthCheckData=me.healthCheckDataMap[record.get("id")];if(me.healthCheckStatusError){tip.items.get(0).body.update("<span><h2>Repository Health Check Status Error</h2>Nexus was unable to successfully retrieve the Repository Health Check status of the repositories.");return}else{if(me.isUnsupportedRepository(record)){tip.items.get(0).body.update('<span><h2>Repository Health Check Unavailable</h2>A Repository Health Check (RHC) cannot be performed by the Sonatype CLM service on this repository, because it is an unsupported type or out of service.<br><br><a href="http://links.sonatype.com/products/clm/rhc/home" target="_blank">How the Sonatype CLM Repository Health Check can help you make better software faster</a></span>');return}else{if(healthCheckData){if(healthCheckData.status=="disabled"){if(Sonatype.HealthCheckUtil.hasEditPerm()){tip.items.get(0).body.update('<span><h2>Repository Health Check Analysis</h2>Click this button to request a Repository Health Check (RHC) by the Sonatype CLM service.  The process is non-invasive and non-disruptive.  Sonatype CLM will return actionable quality, security, and licensing information about the open source components in the repository.<br><br><a href="http://links.sonatype.com/products/clm/rhc/home" target="_blank">How the Sonatype CLM Repository Health Check can help you make better software faster</a></span>')}else{tip.items.get(0).body.update("<span><h2>Insufficient Permissions to Analyze a Repository</h2>To analyze a repository your user account must have permissions to start analysis.</span>")}return}else{if(healthCheckData.status=="analyzing"){tip.items.get(0).body.update("<span><h2>The Analysis is Under Way</h2>The contents of your repository are being analyzed.  This process should only take a few minutes.<br><br>When complete, the ANALYZING button will be replaced by a set of icons that indicate how many security and licensing issues were discovered.<br><br>Hover your mouse over these icons to see additional information about the issues that were found.</span>");return}}}}}}return false}}})};Sonatype.Events.addListener("repositoryPanelInit",function(repoPanel){if(Sonatype.HealthCheckUtil.hasReadPerm()){me.reset({grid:repoPanel.gridPanel})}return true});Sonatype.Events.addListener("repositoryGridInit",function(repoPanel,columns,toolbar){if(Sonatype.HealthCheckUtil.hasReadPerm()){me.updateColumns(columns)}return true});Sonatype.Events.addListener("healthCheckStatusUpdated",function(repositoryId,enabled,record){if(!record){record=me.findRecord(me.grid.getStore(),repositoryId)}me.updateGridColumn(record,enabled);return true})};Ext.onReady(function(){Sonatype.HealthCheckRepositoryContrib=new HealthCheckRepositoryContrib()})});
define("Nexus/healthcheck/HealthCheckUtil",["Nexus/healthcheck/managedIframe","Nexus/siesta"],function(){HealthCheckUtil=function(){var me=this;this.getBase=function(){return Nexus.siesta.basePath+"/healthcheck"};this.getHealthCheckResourceUrl=function(resource){return Sonatype.config.resourcePath+"/static/"+resource};this.getStatusUrl=function(eulaAccepted,repositoryId){return me.getBase()+"/healthCheckStatus"+(repositoryId?"/"+repositoryId:"")+(eulaAccepted?"?eulaAccepted=true":"")};this.hasReadPerm=function(){return Sonatype.lib.Permissions.checkPermission("nexus:healthcheck",Sonatype.lib.Permissions.READ)};this.hasEditPerm=function(){return Sonatype.lib.Permissions.checkPermission("nexus:healthcheck",Sonatype.lib.Permissions.EDIT)};this.hasSummaryReadPerm=function(){return Sonatype.lib.Permissions.checkPermission("nexus:healthchecksummary",Sonatype.lib.Permissions.READ)};Ext.ux.ManagedIFrame.override({_XFrameMessaging:function(){var tagStack={"$":[]};var isEmpty=function(v,allowBlank){return v===null||v===undefined||(!allowBlank?v==="":false)};window.sendMessage=function(message,tag,origin){var MIF;if(MIF=arguments.callee.manager){if(message._fromHost){var fn,result;var compTag=message.tag||tag||null;var mstack=!isEmpty(compTag)?tagStack[compTag.toLowerCase()]||[]:tagStack["$"];for(var i=0,l=mstack.length;i<l;i++){if(fn=mstack[i]){result=fn.apply(fn.__scope,arguments)===false?false:result;if(fn.__single){mstack[i]=null}if(result===false){break}}}return result}else{message={type:isEmpty(tag)?"message":"message:"+tag.toLowerCase().replace(/^\s+|\s+$/g,""),data:message,domain:origin||document.domain,uri:document.documentURI,source:window,tag:isEmpty(tag)?null:tag.toLowerCase()};try{return MIF.disableMessaging!==true?MIF.fireEvent.call(MIF,message.type,MIF,message):null}catch(ex){}return null}}};window.onhostmessage=function(fn,scope,single,tag){if(typeof fn=="function"){if(!isEmpty(fn.__index)){throw"onhostmessage: duplicate handler definition"+(tag?" for tag:"+tag:"")}var k=isEmpty(tag)?"$":tag.toLowerCase();tagStack[k]||(tagStack[k]=[]);fn.__tag=k;fn.__single=single||false;fn.__scope=scope||window;fn.__index=tagStack[k].length;tagStack[k].push(fn)}else{throw"onhostmessage: function required"}};window.unhostmessage=function(fn){if(typeof fn=="function"&&typeof fn.__index!="undefined"){var k=fn.__tag||"$";tagStack[k][fn.__index]=null}}}})};Ext.onReady(function(){Sonatype.HealthCheckUtil=new HealthCheckUtil()})});
define("Nexus/healthcheck/HealthCheckSearchContrib",["Nexus/healthcheck/HealthCheckUtil"],function(){HealthCheckSearchContrib=function(config){var me=this;me.reset=function(config){var config=config||{};var defaultConfig={extraDataQueryComplete:false,rhcSearchResultMap:[],rhcResultDataCapped:false,rhcResultDataError:false,rhcResultDataDisabled:false,rhcAlertColumns:Sonatype.HealthCheckProUtil&&Sonatype.HealthCheckProUtil.hasNonFreeProLicense(),rhcAlertData:false,grid:null};Ext.apply(me,config,defaultConfig);if(me.grid!=null){me.updateStore();me.updateColumnModel()}};me.reset(config);me.updateStore=function(){var grid=me.grid;var store=grid.store;me.addFieldToStore("age");me.addFieldToStore("popularity");me.addFieldToStore("mostPopularVersion");if(me.rhcAlertColumns){me.addFieldToStore("securityAlerts");me.addFieldToStore("licenseThreat")}delete store.reader.ef;store.reader.buildExtractors();store.addListener("beforeload",me.storeBeforeLoadListener);store.addListener("load",me.storeLoadListener)};me.updateColumnModel=function(){me.grid.columns.splice(3,0,{header:"Age",id:"artifactAgeCountColumn",dataIndex:"age",sortable:true,hidden:true,renderer:function(value,metadata,record,rowIndex,colIndex,store){return me.buildAgeText(record)}},{header:"Popularity",id:"artifactPopularityCountColumn",dataIndex:"popularity",sortable:true,hidden:true,renderer:function(value,metadata,record,rowIndex,colIndex,store){metadata.css="rhcMiddleAlignCell";return me.buildPopularityBar(record)}},{header:"Most Popular Version",id:"artifactMostPopularVersionColumn",dataIndex:"mostPopularVersion",sortable:true,hidden:true,renderer:function(value,metadata,record,rowIndex,colIndex,store){return me.buildMostPopularVersion(record)}});if(me.rhcAlertColumns){me.grid.columns.splice(6,0,{header:"Security Issues",id:"artifactSecurityAlertsColumn",dataIndex:"securityAlerts",sortable:true,hidden:true,renderer:function(value,metadata,record,rowIndex,colIndex,store){metadata.css="rhcMiddleAlignCell rhcSecurityAlertsCell";return me.buildSecurityAlerts(record)}},{header:"License Threat",id:"artifactLicenseThreatColumn",dataIndex:"licenseThreat",sortable:true,hidden:true,renderer:function(value,metadata,record,rowIndex,colIndex,store){metadata.css="rhcMiddleAlignCell rhcLicenseThreatCell";return me.buildLicenseThreat(record)}})}};me.addFieldToStore=function(name){me.grid.store.fields.add(new Ext.data.Field({name:name}))};me.storeBeforeLoadListener=function(){me.extraDataQueryComplete=false;me.rhcAlertData=me.rhcAlertColumns&&Sonatype.HealthCheckProUtil.hasPaidProLicense()&&Sonatype.HealthCheckProUtil.hasAlertUpdatePerm()};me.storeLoadListener=function(store,records,options){me.rhcResultDataCapped=false;me.rhcResultDataError=false;me.rhcResultDataDisabled=false;me.rhcSearchResultMap=[];if(store.reader.jsonData.collapsed){me.handleGASearchResults(records)}else{me.handleGAVSearchResults(records)}};me.getGavData=function(record){var data=me.rhcSearchResultMap[record.get("groupId")+"|||"+record.get("artifactId")+"|||"+record.get("version")];return data};me.getGaData=function(record){var data=me.rhcSearchResultMap[record.get("groupId")+"|||"+record.get("artifactId")];return data};me.notAvailable=function(){return'<img class="opaqueWarning" src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/na.png")+'">'};me.buildAgeText=function(record){var data=me.getGavData(record);var result=me.buildCommonText(data,false);if(result!=null){return result}else{if(data&&(data.age===0||data.age>0)){var dayAge=data.age/(1000*60*60*24);if(dayAge>364){return(dayAge/365).toFixed(1)+" yrs"}else{return dayAge.toFixed(0)+" d"}}else{return me.notAvailable()}}};me.buildPopularityBar=function(record){var data=me.getGavData(record);var result=me.buildCommonText(data,false);if(result!=null){return result}else{if(data&&(data.popularity===0||data.popularity>0)){if(data.popularity>100){data.popularity=100}return'<p style="white-space: nowrap; padding-right: 2px;"><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/bar_start.gif")+'" style="vertical-align: middle;"/><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/blue_body.gif")+'" width="'+data.popularity+'%" height="8px" style="vertical-align: middle;"/><img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/blue_border.gif")+'" style="vertical-align: middle;"/></p>'}else{return me.notAvailable()}}};me.buildMostPopularVersion=function(record){var data=me.getGaData(record);var result=me.buildCommonText(data,false);if(result!=null){return result}else{if(data&&!Ext.isEmpty(data.mostPopularVersion)){return data.mostPopularVersion}else{return me.notAvailable()}}};function buildChiclet(clazz,value){return'<span class="nx-clm-chiclet-small '+clazz+'"><strong>'+value+"</strong></span>"}me.buildSecurityAlerts=function(record){var data=me.getGavData(record);var result=me.buildCommonText(data,true);if(result!=null){return result}else{if(data&&!(Ext.isEmpty(data.criticalSecurityAlerts)&&Ext.isEmpty(data.severeSecurityAlerts)&&Ext.isEmpty(data.moderateSecurityAlerts)&&Ext.isEmpty(data.noneSecurityAlerts))){var clazz=data.criticalSecurityAlerts>0?"critical":"";var value=data.criticalSecurityAlerts>0?data.criticalSecurityAlerts:"";var html=buildChiclet(clazz,value);clazz=data.severeSecurityAlerts>0?"severe":"";value=data.severeSecurityAlerts>0?data.severeSecurityAlerts:"";html+=buildChiclet(clazz,value);clazz=data.moderateSecurityAlerts>0?"moderate":"";value=data.moderateSecurityAlerts>0?data.moderateSecurityAlerts:"";html+=buildChiclet(clazz,value);return html}else{return me.notAvailable()}}};me.buildLicenseThreat=function(record){var data=me.getGavData(record);var result=me.buildCommonText(data,true);if(result!=null){return result}else{if(data&&!(Ext.isEmpty(data.licenseThreat)&&Ext.isEmpty(data.licenseThreatName))){var barClass="";if(data.licenseThreat==4){barClass="critical"}else{if(data.licenseThreat==2){barClass="moderate"}else{if(data.licenseThreat==1){barClass="none"}else{barClass="severe"}}}return'<span class="nx-clm-bar '+barClass+'"><strong>'+data.licenseThreatName+"</strong></span>"}else{return me.notAvailable()}}};me.buildCommonText=function(data,alerts){if(alerts&&!me.rhcAlertData){return'<img src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/locked.png")+'">'}else{if(!me.extraDataQueryComplete){return"Loading..."}else{if(me.rhcResultDataDisabled){return'<img class="opaqueWarning" src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/information.png")+'">'}else{if(me.rhcResultDataError){return'<img class="opaqueWarning" src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/exclamation.gif")+'">'}else{if(me.rhcResultDataCapped||(data&&data[alerts?"cappedAlerts":"capped"])){return'<img class="opaqueWarning" src="'+Sonatype.HealthCheckUtil.getHealthCheckResourceUrl("images/warning.gif")+'">'}else{return null}}}}}};me.handleGASearchResults=function(records){me.grid.getColumnModel().setHidden(3,true);me.grid.getColumnModel().setHidden(4,true);me.grid.getColumnModel().setHidden(5,false);if(me.rhcAlertColumns){me.grid.getColumnModel().setHidden(6,true);me.grid.getColumnModel().setHidden(7,true)}var data={gas:[]};if(records){for(var i=0;i<records.length;i++){data.gas.push({groupId:records[i].get("groupId"),artifactId:records[i].get("artifactId")})}}Ext.Ajax.request({callback:me.gaDetailsCallback,suppressStatus:[500,412,409],jsonData:data,method:"PUT",url:Sonatype.HealthCheckUtil.getBase()+"/gaDetails"})};me.handleGAVSearchResults=function(records){me.grid.getColumnModel().setHidden(3,false);me.grid.getColumnModel().setHidden(4,false);me.grid.getColumnModel().setHidden(5,true);if(me.rhcAlertColumns){me.grid.getColumnModel().setHidden(6,false);me.grid.getColumnModel().setHidden(7,false)}var data={gavs:[]};if(records){for(var i=0;i<records.length;i++){data.gavs.push({groupId:records[i].get("groupId"),artifactId:records[i].get("artifactId"),version:records[i].get("version")})}}Ext.Ajax.request({callback:me.gavDetailsCallback,suppressStatus:[500,412,409],jsonData:data,method:"PUT",url:Sonatype.HealthCheckUtil.getBase()+(me.rhcAlertData?"/gavDetailsPro":"/gavDetails")})};me.gaDetailsCallback=function(options,success,response){me.extraDataQueryComplete=true;me.updateTooltip();if(success){var json=Ext.decode(response.responseText);if(json&&json.gas){for(var i=0;i<json.gas.length;i++){me.rhcSearchResultMap[json.gas[i].groupId+"|||"+json.gas[i].artifactId]=json.gas[i]}}}else{if(response.status==409){me.rhcResultDataCapped=true}else{if(response.status==412){me.rhcResultDataDisabled=true}else{if(response.status==500){me.rhcResultDataError=true}}}}me.grid.store.each(function(rec,index){var data=me.getGaData(rec);if(data&&data.mostPopularVersion){me.grid.store.suspendEvents();rec.set("mostPopularVersion",data.mostPopularVersion);rec.commit();me.grid.store.resumeEvents()}var val=me.buildMostPopularVersion(rec);Ext.fly(me.grid.getView().getCell(index,5).firstChild).update(val)})};me.gavDetailsCallback=function(options,success,response){me.extraDataQueryComplete=true;me.updateTooltip();if(success){var json=Ext.decode(response.responseText);if(json&&json.gavs){for(var i=0;i<json.gavs.length;i++){me.rhcSearchResultMap[json.gavs[i].groupId+"|||"+json.gavs[i].artifactId+"|||"+json.gavs[i].version]=json.gavs[i]}}}else{if(response.status==409){me.rhcResultDataCapped=true}else{if(response.status==412){me.rhcResultDataDisabled=true}else{if(response.status==500){me.rhcResultDataError=true}}}}me.grid.store.each(function(rec,index){var data=me.getGavData(rec);if(data&&(data.age||data.popularity||data.securityAlerts||data.licenseThreat)){me.grid.store.suspendEvents();rec.set("age",data.age);rec.set("popularity",data.popularity);if(me.rhcAlertColumns){rec.set("securityAlerts",data.securityAlerts);rec.set("licenseThreat",data.licenseThreat)}rec.commit();me.grid.store.resumeEvents()}var val=me.buildAgeText(rec);Ext.fly(me.grid.getView().getCell(index,3).firstChild).update(val);val=me.buildPopularityBar(rec);Ext.fly(me.grid.getView().getCell(index,4).firstChild).update(val);if(me.rhcAlertColumns){val=me.buildSecurityAlerts(rec);Ext.fly(me.grid.getView().getCell(index,6).firstChild).update(val);val=me.buildLicenseThreat(rec);Ext.fly(me.grid.getView().getCell(index,7).firstChild).update(val)}})};me.updateTooltip=function(){var store=me.grid.getStore();var view=me.grid.getView();if(me.grid.tip){me.grid.tip.destroy()}me.grid.tip=new Ext.ToolTip({target:view.mainBody,delegate:".x-grid3-cell",maxWidth:500,mouseOffset:[0,0],renderTo:document.body,listeners:{beforeshow:{fn:me.tooltipBeforeShowListener}}})};me.tooltipBeforeShowListener=function(tip){tip.hideDelay=200;var view=me.grid.getView();var rowIndex=view.findRowIndex(tip.triggerElement);var cellIndex=view.findCellIndex(tip.triggerElement);var record=me.grid.store.getAt(rowIndex);if(!record){return false}var tooltipText=null;var colModel=me.grid.getColumnModel();var rhcCol=cellIndex==colModel.getIndexById("artifactAgeCountColumn")||cellIndex==colModel.getIndexById("artifactPopularityCountColumn")||cellIndex==colModel.getIndexById("artifactMostPopularVersionColumn");var rhcColAlert=!rhcCol&&me.rhcAlertColumns&&(cellIndex==colModel.getIndexById("artifactSecurityAlertsColumn")||cellIndex==colModel.getIndexById("artifactLicenseThreatColumn"));if(rhcCol){var data=me.getGavData(record);if(!data){data=me.getGaData(record)}if(me.rhcResultDataDisabled){tooltipText="The age and popularity data is only available once Repository Health Check (RHC) has been enabled."}else{if(me.rhcResultDataError){tooltipText="Error retrieving data from Sonatype CLM"}else{if(me.rhcResultDataCapped||(data&&data.capped)){tooltipText='The query limit for age and popularity data has been reached.  Contact <a href="http://sonatype.com/support" target="_blank">Sonatype support</a> to extend current quota limits.';tip.hideDelay=3000}else{if(!data||Ext.isEmpty(data[colModel.getDataIndex(cellIndex)])){tooltipText="CLM data is not available for this artifact. Note that internal artifacts are not covered in Sonatype CLM."}}}}}else{if(rhcColAlert){var data=me.getGavData(record);if(!me.rhcAlertData){if(!Sonatype.HealthCheckProUtil.hasPaidProLicense()){tooltipText="License and security data is available to Nexus Professional customers."}else{if(Sonatype.user.curr.isLoggedIn){tooltipText="You do not have permission to view the license and security data."}else{tooltipText="The license and security data is only available once you have logged in."}}}else{if(me.rhcResultDataDisabled){tooltipText="The license and security data is only available once Repository Health Check (RHC) has been enabled."}else{if(me.rhcResultDataError){tooltipText="Error retrieving data from Sonatype CLM"}else{if(me.rhcResultDataCapped||(data&&data.cappedAlerts)){tooltipText='The query limit for license and security data has been reached.  Contact <a href="http://sonatype.com/support" target="_blank">Sonatype support</a> to extend current quota limits.';tip.hideDelay=3000}else{if(!data||Ext.isEmpty(data[colModel.getDataIndex(cellIndex)])){tooltipText="CLM data is not available for this artifact. Note that internal artifacts are not covered in Sonatype CLM."}}}}}}}if(Ext.isEmpty(tooltipText)){tooltipText=record.get("highlightedFragment")}if(Ext.isEmpty(tooltipText)){return false}tip.body.dom.innerHTML=tooltipText};Sonatype.Events.addListener("searchResultGridInit",function(grid){me.reset({grid:grid})})};Ext.onReady(function(){Sonatype.HealthCheckSearchContrib=new HealthCheckSearchContrib()})});
NX.define("Nexus.healthcheck.controller.HealthCheckConfiguration",{extend:"Nexus.controller.Controller",init:function(){var me=this;me.logDebug("init");Sonatype.Events.addListener("repositoryViewInit",function(cardPanel,rec){me.logDebug("repositoryViewInit fired");var sp=Sonatype.lib.Permissions;var repositoryId=rec.data.id;if(sp.checkPermission("nexus:healthcheck",sp.EDIT)&&repositoryId){if(isCandidateRepository(rec.data)){me.logDebug("Adding repository configuration panel for: "+repositoryId);cardPanel.add(NX.create("Nexus.healthcheck.view.HealthCheckPanel",{tabTitle:"Health Check",name:"healthCheckConfig",repositoryId:repositoryId}))}}function isCandidateRepository(repository){me.logDebug(repository);return repository.repoType==="proxy"&&(repository.format!=="maven2"||(repository.format==="maven2"&&repository.repoPolicy==="Release"))}})}});
define("Nexus/healthcheck/managedIframe",function(){Ext.ux.ManagedIFrame=function(){var args=Array.prototype.slice.call(arguments,0),el=Ext.get(args[0]),config=args[0];if(el&&el.dom&&el.dom.tagName=="IFRAME"){config=args[1]||{}}else{config=args[0]||args[1]||{};el=config.autoCreate?Ext.get(Ext.DomHelper.append(config.autoCreate.parent||document.body,Ext.apply({tag:"iframe",src:(Ext.isIE&&Ext.isSecure)?Ext.SSL_SECURE_URL:""},config.autoCreate))):null}if(!el||el.dom.tagName!="IFRAME"){return el}!!el.dom.name.length||(el.dom.name=el.dom.id);this.addEvents({domready:true,documentloaded:true,exception:true,message:true});if(config.listeners){this.listeners=config.listeners;Ext.ux.ManagedIFrame.superclass.constructor.call(this)}Ext.apply(el,this);el.addClass("x-managed-iframe");if(config.style){el.applyStyles(config.style)}el._maskEl=el.parent(".x-managed-iframe-mask")||el.parent().addClass("x-managed-iframe-mask");Ext.apply(el,{disableMessaging:config.disableMessaging===true,loadMask:Ext.apply({msg:"Loading..",msgCls:"x-mask-loading",maskEl:el._maskEl,hideOnReady:true,disabled:!config.loadMask},config.loadMask),_eventName:Ext.isIE?"onreadystatechange":"onload",_windowContext:null,eventsFollowFrameLinks:typeof config.eventsFollowFrameLinks=="undefined"?true:config.eventsFollowFrameLinks});el.dom[el._eventName]=el.loadHandler.createDelegate(el);if(document.addEventListener){Ext.EventManager.on(window,"DOMFrameContentLoaded",el.dom[el._eventName])}var um=el.updateManager=new Ext.UpdateManager(el,true);um.showLoadIndicator=config.showLoadIndicator||false;if(config.src){el.setSrc(config.src)}else{var content=config.html||config.content||false;if(content){el.update.defer(10,el,[content])}}return Ext.ux.ManagedIFrame.Manager.register(el)};Ext.extend(Ext.ux.ManagedIFrame,Ext.util.Observable,{src:null,setSrc:function(url,discardUrl,callback){var reset=Ext.isIE&&Ext.isSecure?Ext.SSL_SECURE_URL:"";var src=url||this.src||reset;if(Ext.isOpera){this.dom.src=reset}this._windowContext=null;this._hooked=this._domReady=this._domFired=false;this._callBack=callback||false;this.showMask();(function(){var s=typeof src=="function"?src()||"":src;try{this._frameAction=true;this.dom.src=s;this.frameInit=true;this.checkDOM()}catch(ex){this.fireEvent("exception",this,ex)}}).defer(10,this);if(discardUrl!==true){this.src=src}return this},reset:function(src,callback){this.setSrc(src||(Ext.isIE&&Ext.isSecure?Ext.SSL_SECURE_URL:""),true,callback)},scriptRE:/(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)/gi,update:function(content,loadScripts,callback){loadScripts=loadScripts||this.getUpdateManager().loadScripts||false;content=Ext.DomHelper.markup(content||"");content=loadScripts===true?content:content.replace(this.scriptRE,"");var doc;if(doc=this.getDocument()){this._frameAction=!!content.length;this._windowContext=this.src=null;this._callBack=callback||false;this._hooked=this._domReady=this._domFired=false;this.showMask();doc.open();doc.write(content);doc.close();this.frameInit=true;if(this._frameAction){this.checkDOM()}else{this.hideMask(true);if(this._callBack){this._callBack()}}}else{this.hideMask(true);if(this._callBack){this._callBack()}}return this},disableMessaging:true,_XFrameMessaging:function(){var tagStack={"$":[]};var isEmpty=function(v,allowBlank){return v===null||v===undefined||(!allowBlank?v==="":false)};window.sendMessage=function(message,tag,origin){var MIF;if(MIF=arguments.callee.manager){if(message._fromHost){var fn,result;var compTag=message.tag||tag||null;var mstack=!isEmpty(compTag)?tagStack[compTag.toLowerCase()]||[]:tagStack["$"];for(var i=0,l=mstack.length;i<l;i++){if(fn=mstack[i]){result=fn.apply(fn.__scope,arguments)===false?false:result;if(fn.__single){mstack[i]=null}if(result===false){break}}}return result}else{message={type:isEmpty(tag)?"message":"message:"+tag.toLowerCase().replace(/^\s+|\s+$/g,""),data:message,domain:origin||document.domain,uri:document.documentURI,source:window,tag:isEmpty(tag)?null:tag.toLowerCase()};try{return MIF.disableMessaging!==true?MIF.fireEvent.call(MIF,message.type,MIF,message):null}catch(ex){}return null}}};window.onhostmessage=function(fn,scope,single,tag){if(typeof fn=="function"){if(!isEmpty(fn.__index)){throw"onhostmessage: duplicate handler definition"+(tag?" for tag:"+tag:"")}var k=isEmpty(tag)?"$":tag.toLowerCase();tagStack[k]||(tagStack[k]=[]);Ext.apply(fn,{__tag:k,__single:single||false,__scope:scope||window,__index:tagStack[k].length});tagStack[k].push(fn)}else{throw"onhostmessage: function required"}};window.unhostmessage=function(fn){if(typeof fn=="function"&&typeof fn.__index!="undefined"){var k=fn.__tag||"$";tagStack[k][fn.__index]=null}}},_renderHook:function(){this._windowContext=null;this._hooked=false;try{if(this.writeScript('(function(){(window.hostMIF = parent.Ext.get("'+this.dom.id+'"))._windowContext='+(Ext.isIE?"window":"{eval:function(s){return eval(s);}}")+";})();")){if(this.disableMessaging!==true){this.loadFunction({name:"XMessage",fn:this._XFrameMessaging},false,true);var sm;if(sm=this.getWindow().sendMessage){sm.manager=this}}}return this.domWritable()}catch(ex){}return false},sendMessage:function(message,tag,origin){var win;if(this.disableMessaging!==true&&(win=this.getWindow())){tag||(tag=message.tag||"");tag=tag.toLowerCase();message=Ext.applyIf(message.data?message:{data:message},{type:Ext.isEmpty(tag)?"message":"message:"+tag,domain:origin||document.domain,uri:document.documentURI,source:window,tag:tag||null,_fromHost:this});return win.sendMessage?win.sendMessage.call(null,message,tag,origin):null}return null},_windowContext:null,getDocument:function(){return this.getWindow()?this.getWindow().document:null},getDocumentURI:function(){var URI;try{URI=this.src?this.getDocument().location.href:null}catch(ex){}return URI||this.src},getWindow:function(){var dom=this.dom;return dom?dom.contentWindow||window.frames[dom.name]:null},print:function(){try{var win=this.getWindow();if(Ext.isIE){win.focus()}win.print()}catch(ex){throw"print exception: "+(ex.description||ex.message||ex)}},destroy:function(){this.removeAllListeners();if(this.dom){if(document.addEventListener){Ext.EventManager.un(window,"DOMFrameContentLoaded",this.dom[this._eventName])}this.dom[this._eventName]=null;this._windowContext=null;if(Ext.isIE&&this.dom.src){this.dom.src="javascript:false"}this._maskEl=null;Ext.removeNode(this.dom)}Ext.apply(this.loadMask,{masker:null,maskEl:null});Ext.ux.ManagedIFrame.Manager.deRegister(this)},domWritable:function(){return !!this._windowContext},execScript:function(block,useDOM){try{if(this.domWritable()){if(useDOM){this.writeScript(block)}else{return this._windowContext.eval(block)}}else{throw"execScript:non-secure context"}}catch(ex){this.fireEvent("exception",this,ex);return false}return true},writeScript:function(block,attributes){attributes=Ext.apply({},attributes||{},{type:"text/javascript",text:block});try{var head,script,doc=this.getDocument();if(doc&&doc.getElementsByTagName){if(!(head=doc.getElementsByTagName("head")[0])){head=doc.createElement("head");doc.getElementsByTagName("html")[0].appendChild(head)}if(head&&(script=doc.createElement("script"))){for(var attrib in attributes){if(attributes.hasOwnProperty(attrib)&&attrib in script){script[attrib]=attributes[attrib]}}return !!head.appendChild(script)}}}catch(ex){this.fireEvent("exception",this,ex)}return false},loadFunction:function(fn,useDOM,invokeIt){var name=fn.name||fn;var fn=fn.fn||window[fn];this.execScript(name+"="+fn,useDOM);if(invokeIt){this.execScript(name+"()")}},showMask:function(msg,msgCls,forced){var lmask;if((lmask=this.loadMask)&&(!lmask.disabled||forced)){if(lmask._vis){return}lmask.masker||(lmask.masker=Ext.get(lmask.maskEl||this.dom.parentNode||this.wrap({tag:"div",style:{position:"relative"}})));lmask._vis=true;lmask.masker.mask.defer(lmask.delay||5,lmask.masker,[msg||lmask.msg,msgCls||lmask.msgCls])}},hideMask:function(forced){var tlm;if((tlm=this.loadMask)&&!tlm.disabled&&tlm.masker){if(!forced&&(tlm.hideOnReady!==true&&this._domReady)){return}tlm._vis=false;tlm.masker.unmask.defer(tlm.delay||5,tlm.masker)}},loadHandler:function(e){if(!this.frameInit||(!this._frameAction&&!this.eventsFollowFrameLinks)){return}var rstatus=(e&&typeof e.type!=="undefined"?e.type:this.dom.readyState);switch(rstatus){case"loading":case"interactive":break;case"DOMFrameContentLoaded":if(this._domFired||(e&&e.target!==this.dom)){return}case"domready":if(this._domFired){return}if(this._domFired=this._hooked=this._renderHook()){this._frameAction=(this.fireEvent("domready",this)===false?false:this._frameAction)}case"domfail":this._domReady=true;this.hideMask();break;case"load":case"complete":if(!this._domFired){this.loadHandler({type:"domready"})}this.hideMask(true);if(this._frameAction||this.eventsFollowFrameLinks){this.fireEvent.defer(50,this,["documentloaded",this])}this._frameAction=false;if(this.eventsFollowFrameLinks){this._domFired=this._domReady=false}if(this._callBack){this._callBack(this)}break;default:}},checkDOM:function(win){if(Ext.isOpera){return}var n=0,win=win||this.getWindow(),manager=this,domReady=false,max=100;var poll=function(){try{domReady=false;var doc=win.document,body;if(!manager._domReady){domReady=(doc&&doc.getElementsByTagName);domReady=domReady&&(body=doc.getElementsByTagName("body")[0])&&!!body.innerHTML.length}}catch(ex){n=max}if(!manager._frameAction||manager._domReady){return}if(n++<max&&!domReady){setTimeout(arguments.callee,10);return}manager.loadHandler({type:domReady?"domready":"domfail"})};setTimeout(poll,50)}});Ext.ux.ManagedIFrame.Manager=function(){var frames={},namedFrames={};return{shimCls:"x-frame-shim",register:function(frame){frame.manager=this;return frames[frame.id]=namedFrames[frame.dom.name||frame.id]=frame},deRegister:function(frame){delete frames[frame.id];delete namedFrames[frame.dom.name||frame.id]},hideDragMask:function(){if(!this.shimApplied){return}Ext.select("."+this.shimCls,true).removeClass(this.shimCls+"-on");this.shimApplied=false},showDragMask:function(){if(!this.shimApplied){this.shimApplied=true;Ext.select("."+this.shimCls,true).addClass(this.shimCls+"-on")}},getFrameById:function(id){return frames[id]||null},getFrameByName:function(name){return namedFrames[name]||null}}}();Ext.ux.ManagedIframePanel=Ext.extend(Ext.Panel,{defaultSrc:null,bodyStyle:{height:"100%",width:"100%",position:"relative"},frameStyle:{overflow:"auto"},frameConfig:null,hideMode:!Ext.isIE?"nosize":"display",shimCls:Ext.ux.ManagedIFrame.Manager.shimCls,shimUrl:null,loadMask:false,animCollapse:Ext.isIE,autoScroll:false,closable:true,ctype:"Ext.ux.ManagedIframePanel",showLoadIndicator:false,unsupportedText:"Inline frames are NOT enabled/supported by your browser.",initComponent:function(){var unsup=this.unsupportedText?{html:this.unsupportedText}:false;this.bodyCfg||(this.bodyCfg={tag:"div",cls:"x-panel-body",children:[{cls:"x-managed-iframe-mask",children:[Ext.apply(Ext.apply({tag:"iframe",frameborder:0,cls:"x-managed-iframe",style:this.frameStyle||null},this.frameConfig),unsup,Ext.isIE&&Ext.isSecure?{src:Ext.SSL_SECURE_URL}:false),{tag:"img",src:this.shimUrl||Ext.BLANK_IMAGE_URL,cls:this.shimCls}]}]});this.autoScroll=false;this.items=null;if(this.stateful!==false){this.stateEvents||(this.stateEvents=["documentloaded"])}Ext.ux.ManagedIframePanel.superclass.initComponent.call(this);this.monitorResize||(this.monitorResize=this.fitToParent);this.addEvents({documentloaded:true,domready:true,message:true,exception:true});this.addListener=this.on},doLayout:function(){if(this.fitToParent&&!this.ownerCt){var pos=this.getPosition(),size=(Ext.get(this.fitToParent)||this.getEl().parent()).getViewSize();this.setSize(size.width-pos[0],size.height-pos[1])}Ext.ux.ManagedIframePanel.superclass.doLayout.apply(this,arguments)},beforeDestroy:function(){if(this.rendered){if(this.tools){for(var k in this.tools){Ext.destroy(this.tools[k])}}if(this.header&&this.headerAsText){var s;if(s=this.header.child("span")){s.remove()}this.header.update("")}Ext.each(["iframe","header","topToolbar","bottomToolbar","footer","loadMask","body","bwrap"],function(elName){if(this[elName]){if(typeof this[elName].destroy=="function"){this[elName].destroy()}else{Ext.destroy(this[elName])}this[elName]=null;delete this[elName]}},this)}Ext.ux.ManagedIframePanel.superclass.beforeDestroy.call(this)},onDestroy:function(){Ext.Panel.superclass.onDestroy.call(this)},onRender:function(ct,position){Ext.ux.ManagedIframePanel.superclass.onRender.call(this,ct,position);if(this.iframe=this.body.child("iframe.x-managed-iframe")){var El=Ext.Element;var mode=El[this.hideMode.toUpperCase()]||"x-hide-nosize";Ext.each([this[this.collapseEl],this.floating?null:this.getActionEl(),this.iframe],function(el){if(el){el.setVisibilityMode(mode)}},this);if(this.loadMask){this.loadMask=Ext.apply({disabled:false,maskEl:this.body,hideOnReady:true},this.loadMask)}if(this.iframe=new Ext.ux.ManagedIFrame(this.iframe,{loadMask:this.loadMask,showLoadIndicator:this.showLoadIndicator,disableMessaging:this.disableMessaging,style:this.frameStyle})){this.loadMask=this.iframe.loadMask;this.iframe.ownerCt=this;this.relayEvents(this.iframe,["documentloaded","domready","exception","message"].concat(this._msgTagHandlers||[]));delete this._msgTagHandlers}this.getUpdater().showLoadIndicator=this.showLoadIndicator||false;var ownerCt=this.ownerCt;while(ownerCt){ownerCt.on("afterlayout",function(container,layout){var MIM=Ext.ux.ManagedIFrame.Manager,st=false;Ext.each(["north","south","east","west"],function(region){var reg;if((reg=layout[region])&&reg.splitEl){st=true;if(!reg.split._splitTrapped){reg.split.on("beforeresize",MIM.showDragMask,MIM);reg.split._splitTrapped=true}}},this);if(st&&!this._splitTrapped){this.on("resize",MIM.hideDragMask,MIM);this._splitTrapped=true}},this,{single:true});ownerCt=ownerCt.ownerCt}}this.shim=Ext.get(this.body.child(".x-frame-shim"))},toggleShim:function(){if(this.shim&&this.shimCls){this.shim.toggleClass(this.shimCls)}},afterRender:function(container){var html=this.html;delete this.html;Ext.ux.ManagedIframePanel.superclass.afterRender.call(this);if(this.iframe){if(this.defaultSrc){this.setSrc()}else{if(html){this.iframe.update(typeof html=="object"?Ext.DomHelper.markup(html):html)}}}},sendMessage:function(){if(this.iframe){this.iframe.sendMessage.apply(this.iframe,arguments)}},on:function(name){var tagRE=/^message\:/i,n=null;if(typeof name=="object"){for(var na in name){if(!this.filterOptRe.test(na)&&tagRE.test(na)){n||(n=[]);n.push(na.toLowerCase())}}}else{if(tagRE.test(name)){n=[name.toLowerCase()]}}if(this.getFrame()&&n){this.relayEvents(this.iframe,n)}else{this._msgTagHandlers||(this._msgTagHandlers=[]);if(n){this._msgTagHandlers=this._msgTagHandlers.concat(n)}}Ext.ux.ManagedIframePanel.superclass.on.apply(this,arguments)},setSrc:function(url,discardUrl,callback){url=url||this.defaultSrc||false;if(!url){return this}if(url.url){callback=url.callback||false;discardUrl=url.discardUrl||false;url=url.url||false}var src=url||(Ext.isIE&&Ext.isSecure?Ext.SSL_SECURE_URL:"");if(this.rendered&&this.iframe){this.iframe.setSrc(src,discardUrl,callback)}return this},getState:function(){var URI=this.iframe?this.iframe.getDocumentURI()||null:null;return Ext.apply(Ext.ux.ManagedIframePanel.superclass.getState.call(this)||{},URI?{defaultSrc:typeof URI=="function"?URI():URI}:null)},getUpdater:function(){return this.rendered?(this.iframe||this.body).getUpdater():null},getFrame:function(){return this.rendered?this.iframe:null},getFrameWindow:function(){return this.rendered&&this.iframe?this.iframe.getWindow():null},getFrameDocument:function(){return this.rendered&&this.iframe?this.iframe.getDocument():null},load:function(loadCfg){var um;if(um=this.getUpdater()){if(loadCfg&&loadCfg.renderer){um.setRenderer(loadCfg.renderer);delete loadCfg.renderer}um.update.apply(um,arguments)}return this},doAutoLoad:function(){this.load(typeof this.autoLoad=="object"?this.autoLoad:{url:this.autoLoad})}});Ext.reg("iframepanel",Ext.ux.ManagedIframePanel);Ext.ux.ManagedIframePortlet=Ext.extend(Ext.ux.ManagedIframePanel,{anchor:"100%",frame:true,collapseEl:"bwrap",collapsible:true,draggable:true,cls:"x-portlet"});Ext.reg("iframeportlet",Ext.ux.ManagedIframePortlet);Ext.onReady(function(){var CSS=Ext.util.CSS,rules=[];CSS.getRule(".x-managed-iframe")||(rules.push(".x-managed-iframe {height:100%;width:100%;overflow:auto;}"));CSS.getRule(".x-managed-iframe-mask")||(rules.push(".x-managed-iframe-mask{width:100%;height:100%;position:relative;}"));if(!CSS.getRule(".x-frame-shim")){rules.push(".x-frame-shim {z-index:9000;position:absolute;top:0px;left:0px;background:transparent!important;overflow:hidden;display:none;}");rules.push(".x-frame-shim-on{width:100%;height:100%;display:block;zoom:1;}");rules.push(".ext-ie6 .x-frame-shim{margin-left:5px;margin-top:3px;}")}CSS.getRule(".x-hide-nosize")||(rules.push(".x-hide-nosize,.x-hide-nosize object,.x-hide-nosize iframe{height:0px!important;width:0px!important;border:none;}"));if(!!rules.length){CSS.createStyleSheet(rules.join(" "))}})});
define("nexus-healthcheck-base-boot",["Nexus/healthcheck/managedIframe","Nexus/healthcheck/HealthCheckAboutContrib","Nexus/healthcheck/HealthCheckPluginConsoleContrib","Nexus/healthcheck/HealthCheckRepositoryContrib","Nexus/healthcheck/HealthCheckSearchContrib","Nexus/healthcheck/controller/HealthCheckConfiguration","Nexus/healthcheck/view/HealthCheckPanel"],function(){Nexus.Log.debug("Healthcheck base loaded");NX.create("Nexus.healthcheck.controller.HealthCheckConfiguration").init()});
