/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global NX, Ext, Sonatype, Nexus*/

/**
 * HealthCheckConfiguration controller.
 *
 * @since 2.8
 */
NX.define('Nexus.healthcheck.controller.HealthCheckConfiguration', {
  extend: 'Nexus.controller.Controller',

  init: function() {
    var me = this;
    me.logDebug('init');

    Sonatype.Events.addListener('repositoryViewInit', function (cardPanel, rec) {
      me.logDebug('repositoryViewInit fired');
      var sp = Sonatype.lib.Permissions;
      var repositoryId = rec.data.id;

      if (sp.checkPermission('nexus:healthcheck', sp.EDIT) && repositoryId /* not a new repo*/ ) {
        if(isCandidateRepository(rec.data)){
          me.logDebug('Adding repository configuration panel for: ' + repositoryId);
          cardPanel.add(NX.create('Nexus.healthcheck.view.HealthCheckPanel', {
            tabTitle: 'Health Check',
            name: 'healthCheckConfig',
            repositoryId: repositoryId
          }));
        }
      }

      /**
       * A candidate repository is either maven2 with a RELEASE policy, or any other proxy repository.
       * @param repository
       * @returns {boolean|*}
       */
      function isCandidateRepository(repository) {
        me.logDebug(repository);
        return repository.repoType === 'proxy' &&
          (repository.format !== 'maven2' || (repository.format === 'maven2' && repository.repoPolicy === 'Release'));
      }
    });
  }
});