/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
define('Nexus/healthcheck/HealthCheckUtil', ['Nexus/healthcheck/managedIframe', 'Nexus/siesta'], function() {

  HealthCheckUtil = function() {
      var me = this;

      this.getBase = function() {
        return Nexus.siesta.basePath + '/healthcheck';
      };
      
      this.getHealthCheckResourceUrl = function(resource) {
          return Sonatype.config.resourcePath + '/static/' + resource;
      };

      this.getStatusUrl = function(eulaAccepted, repositoryId) {
          return me.getBase() + '/healthCheckStatus' + (repositoryId ? '/' + repositoryId : '') + (eulaAccepted ? '?eulaAccepted=true' : '');
      };

      this.hasReadPerm = function() {
          return Sonatype.lib.Permissions.checkPermission('nexus:healthcheck', Sonatype.lib.Permissions.READ);
      };

      this.hasEditPerm = function() {
          return Sonatype.lib.Permissions.checkPermission('nexus:healthcheck', Sonatype.lib.Permissions.EDIT);
      };

      this.hasSummaryReadPerm = function() {
          return Sonatype.lib.Permissions.checkPermission('nexus:healthchecksummary', Sonatype.lib.Permissions.READ);
      };

      //overriding the messaging to remove Ext.apply usage (so not to require Ext namespace in the iframe)
      Ext.ux.ManagedIFrame.override({
          _XFrameMessaging : function() {
              //each tag gets a hash queue ($ = no tag ).
              var tagStack = {
                  '$' : []
              };
              var isEmpty = function(v, allowBlank) {
                  return v === null || v === undefined || (!allowBlank ? v === '' : false);
              };
              window.sendMessage = function(message, tag, origin) {
                  var MIF;
                  if (MIF = arguments.callee.manager) {
                      if (message._fromHost) {
                          var fn, result;
                          //only raise matching-tag handlers
                          var compTag = message.tag || tag || null;
                          var mstack = !isEmpty(compTag) ? tagStack[compTag.toLowerCase()] || [] : tagStack["$"];

                          for ( var i = 0, l = mstack.length; i < l; i++) {
                              if (fn = mstack[i]) {
                                  result = fn.apply(fn.__scope, arguments) === false ? false : result;
                                  if (fn.__single) {
                                      mstack[i] = null;
                                  }
                                  if (result === false) {
                                      break;
                                  }
                              }
                          }

                          return result;
                      } else {

                          message = {
                              type : isEmpty(tag) ? 'message' : 'message:' + tag.toLowerCase().replace(/^\s+|\s+$/g, ''),
                              data : message,
                              domain : origin || document.domain,
                              uri : document.documentURI,
                              source : window,
                              tag : isEmpty(tag) ? null : tag.toLowerCase()
                          };

                          try {
                              return MIF.disableMessaging !== true ? MIF.fireEvent.call(MIF, message.type, MIF, message) : null;
                          } catch (ex) {
                          } //trap for message:tag handlers not yet defined

                          return null;
                      }

                  }
              };
              window.onhostmessage = function(fn, scope, single, tag) {

                  if (typeof fn == 'function') {
                      if (!isEmpty(fn.__index)) {
                          throw "onhostmessage: duplicate handler definition" + (tag ? " for tag:" + tag : '');
                      }

                      var k = isEmpty(tag) ? "$" : tag.toLowerCase();
                      tagStack[k] || (tagStack[k] = []);
                      fn.__tag = k;
                      fn.__single = single || false;
                      fn.__scope = scope || window;
                      fn.__index = tagStack[k].length;
                      tagStack[k].push(fn);

                  } else {
                      throw "onhostmessage: function required";
                  }

              };
              window.unhostmessage = function(fn) {
                  if (typeof fn == 'function' && typeof fn.__index != 'undefined') {
                      var k = fn.__tag || "$";
                      tagStack[k][fn.__index] = null;
                  }
              };

          }
      });
  }

  Ext.onReady(function() {
      Sonatype.HealthCheckUtil = new HealthCheckUtil();
  });
});
