/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
define('Nexus/healthcheck/HealthCheckPluginConsoleContrib', ['Nexus/healthcheck/HealthCheckUtil'], function() {

  HealthCheckPluginConsoleContrib = function() {
      var me = this;
      me.addDetailItem = function(labelText, valueName, valueText) {
          var pluginDetailPanel = me.pluginInfoTab.items.get(0);

          //the actual 'label' field
          pluginDetailPanel.add({
              xtype : 'label',
              html : labelText,
              style : me.pluginInfoTab.labelClass,
              width : 120
          });
          //the 'value' field
          pluginDetailPanel.add({
              xtype : 'label',
              name : valueName,
              html : valueText,
              style : me.pluginInfoTab.textClass
          });
      };

      me.getInstanceData = function(pluginInfoTab) {
          me.pluginInfoTab = pluginInfoTab;

          me.tabId = pluginInfoTab.getId();
          Ext.Ajax.request({
              callback : function(options, success, response) {
                  if (success && Ext.get(me.tabId)) {
                      var json = Ext.decode(response.responseText);

                      if (!Ext.isEmpty(json.nexusId)) {
                          me.addDetailItem('Nexus ID', 'nexusId', json.nexusId);
                          me.pluginInfoTab.items.get(0).doLayout();
                      }
                  }
              },
              url : Sonatype.HealthCheckUtil.getBase() + '/healthCheckInfo',
              // hide the status when connection to host is lost
              suppressStatus : [ 0, 500 ]
          });
      };

      Sonatype.Events.addListener('pluginInfoTabInit', function(pluginInfoTab) {
          if (pluginInfoTab.payload.data.name == 'Nexus CLM Plugin') {
              me.getInstanceData(pluginInfoTab);
          }
      });
  };

  Ext.onReady(function() {
      Sonatype.HealthCheckPluginConsoleContrib = new HealthCheckPluginConsoleContrib();
  });
});
