NX.define("Nexus.atlas.view.Panel",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.atlas.Icons","Nexus.atlas.view.SysInfo","Nexus.atlas.view.SupportZip","Nexus.atlas.view.SupportRequest"],requirejs:["Sonatype/utils"],xtype:"nx-atlas-view-panel",title:"Support Tools",cls:"nx-atlas-view-panel",border:false,layout:{type:"vbox",align:"stretch"},initComponent:function(){var me=this,icons=Nexus.atlas.Icons,tabs;tabs=[{xtype:"nx-atlas-view-sysinfo"},{xtype:"nx-atlas-view-supportzip"}];if(Sonatype.utils.editionShort!=="OSS"){tabs.push({xtype:"nx-atlas-view-supportrequest"})}Ext.apply(me,{items:[{xtype:"panel",cls:"nx-atlas-view-panel-description",border:false,html:icons.get("atlas").variant("x32").img+"<div>Support tools provides a collection of modules to help keep your server healthy.</div>",height:60,flex:0},{xtype:"tabpanel",flex:1,border:false,plain:true,layoutOnTabChange:true,items:tabs,activeTab:0}]});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.atlas.view.SupportZip",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.atlas.Icons"],xtype:"nx-atlas-view-supportzip",title:"Support ZIP",id:"nx-atlas-view-supportzip",cls:"nx-atlas-view-supportzip",border:false,layout:"fit",initComponent:function(){var me=this,icons=Nexus.atlas.Icons;Ext.apply(me,{items:[{xtype:"container",items:[{cls:"nx-atlas-view-supportzip-description",border:false,html:icons.get("zip").variant("x32").img+"<div>Creates a ZIP file containing useful support information about your server. No information will be sent to Sonatype when creating the support ZIP file.<br/><br/>Select the contents and options for support ZIP creation:</div>"},{xtype:"form",itemId:"form",cls:"nx-atlas-view-supportzip-form",layoutConfig:{labelSeparator:"",labelWidth:70},border:false,monitorValid:true,items:[{xtype:"checkboxgroup",fieldLabel:"Contents",columns:1,allowBlank:false,anchor:"96%",items:[{xtype:"checkbox",name:"systemInformation",boxLabel:"System Information",helpText:"Includes system information report",checked:true},{xtype:"checkbox",name:"threadDump",boxLabel:"Thread Dump",helpText:"Include a JVM thread-dump",checked:true},{xtype:"checkbox",name:"configuration",boxLabel:"Configuration",helpText:"Include configuration files",checked:true},{xtype:"checkbox",name:"security",boxLabel:"Security Configuration",helpText:"Include security configuration files",checked:true},{xtype:"checkbox",name:"log",boxLabel:"Log",helpText:"Include log files",checked:true},{xtype:"checkbox",name:"metrics",boxLabel:"Metrics",helpText:"Includes system and component metrics",checked:true}]},{xtype:"checkboxgroup",fieldLabel:"Options",columns:1,anchor:"96%",items:[{xtype:"checkbox",name:"limitFileSizes",boxLabel:"Limit Included File Sizes",helpText:"Limit the size of files included in the support ZIP to no more than 30 MB each.",checked:true},{xtype:"checkbox",name:"limitZipSize",boxLabel:"Limit Maximum ZIP File Size",helpText:"Limit the maximum size of the support ZIP file to no more than 20 MB.",checked:true}]}],buttons:[{text:"Create",id:"nx-atlas-button-supportzip-create",formBind:true}],buttonAlign:"left"}]}]});me.constructor.superclass.initComponent.apply(me,arguments)},getValues:function(){return this.down("form").getForm().getValues()}});
NX.define("Nexus.atlas.view.SupportZipCreated",{extend:"Nexus.wonderland.view.FileCreated",xtype:"nx-atlas-view-supportzip-created",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.atlas.Icons"],fileType:"Support ZIP",downloadButtonId:"nx-atlas-button-supportzip-download",initComponent:function(){var me=this,icons=Nexus.atlas.Icons;me.fileIcon=icons.get("zip").variant("x32");Nexus.atlas.view.SupportZipCreated.superclass.initComponent.apply(me,arguments);me.truncatedWarning=NX.create("Ext.Component",{cls:"nx-atlas-view-supportzip-created-truncated-warning",html:"<span>"+icons.get("warning").img+"Contents have been truncated due to exceeded size limits.</span>",hidden:true});me.items.insert(1,me.truncatedWarning)},setValues:function(values){Nexus.atlas.view.SupportZipCreated.superclass.setValues.apply(this,arguments);if(values.truncated){this.truncatedWarning.show()}}});
NX.define("Nexus.atlas.view.SysInfo",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.atlas.Icons"],xtype:"nx-atlas-view-sysinfo",title:"System Information",id:"nx-atlas-view-sysinfo",cls:"nx-atlas-view-sysinfo",layout:"fit",autoScroll:true,initComponent:function(){var me=this,icons=Nexus.atlas.Icons;me.sectionTpl=NX.create("Ext.XTemplate",'<div class="nx-atlas-view-sysinfo-section">',"<h2>{name}</h2>","<table>",'<tpl for="props">',"<tr>",'<td class="property-name">{name}</td>','<td class="property-value">{value}</td>',"</tr>","</tpl>","</table>","</div>",{compiled:true});me.nestedSectionTpl=NX.create("Ext.XTemplate",'<div class="nx-atlas-view-sysinfo-nestedsection">',"<h2>{name}</h2>",'<tpl for="nested">',"<h3>{name}</h3>","<table>",'<tpl for="props">',"<tr>",'<td class="property-name">{name}</td>','<td class="property-value">{value}</td>',"</tr>","</tpl>","</table>","</tpl>","</div>",{compiled:true});function objectToProperties(obj){var props=[];Ext.iterate(obj,function(key,value){props.push({name:key,value:value})});return props}me.mainTpl=NX.create("Ext.XTemplate",'<div class="nx-atlas-view-sysinfo-body">',icons.get("sysinfo").variant("x32").img,'{[ this.section("nexus-status", values) ]}','{[ this.section("nexus-configuration", values) ]}','{[ this.section("nexus-properties", values) ]}','{[ this.section("nexus-license", values) ]}','{[ this.nestedSection("nexus-plugins", values) ]}','{[ this.section("system-time", values) ]}','{[ this.section("system-properties", values) ]}','{[ this.section("system-environment", values) ]}','{[ this.section("system-runtime", values) ]}','{[ this.nestedSection("system-network", values) ]}','{[ this.nestedSection("system-filestores", values) ]}',"</div>",{compiled:true,section:function(name,values){var data=values[name];return me.sectionTpl.apply({name:name,props:objectToProperties(data)})},nestedSection:function(name,values){var data=values[name],nested=[];Ext.iterate(data,function(key,value){nested.push({name:key,props:objectToProperties(value)})});return me.nestedSectionTpl.apply({name:name,nested:nested})}});Ext.apply(me,{tbar:[{xtype:"button",id:"nx-atlas-view-sysinfo-button-refresh",text:"Refresh",tooltip:"Refresh system information",iconCls:icons.get("refresh").cls},{xtype:"button",id:"nx-atlas-view-sysinfo-button-download",text:"Download",tooltip:"Download system information",iconCls:icons.get("download").cls},"-",{xtype:"button",id:"nx-atlas-view-sysinfo-button-print",text:"Print",tooltip:"Print system information",iconCls:icons.get("print").cls}]});me.constructor.superclass.initComponent.apply(me,arguments)},setInfo:function(info){this.mainTpl.overwrite(this.body,info)}});
NX.define("Nexus.atlas.view.SupportRequest",{extend:"Ext.Panel",requires:["Nexus.atlas.Icons"],xtype:"nx-atlas-view-supportrequest",title:"Support Request",id:"nx-atlas-view-supportrequest",cls:"nx-atlas-view-supportrequest",border:false,layout:"fit",initComponent:function(){var me=this,icons=Nexus.atlas.Icons;Ext.apply(me,{items:[{xtype:"container",items:[{cls:"nx-atlas-view-supportrequest-description",border:false,html:icons.get("support").variant("x32").img+'<div><p>Submit a support request to Sonatype.</p><br/><p>Please include a complete description of your problem and steps to allow us to reproduce the problem (if available).</p><br/><p>Attaching a "Support ZIP" to your request will help our engineers give you a faster response.</p></div>'},{xtype:"form",itemId:"form",cls:"nx-atlas-view-supportrequest-form",border:false,buttons:[{text:"Submit Request",id:"nx-atlas-button-supportrequest-makerequest"}],buttonAlign:"left"}]}]});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.atlas.Icons",{extend:"Nexus.util.IconContainer",singleton:true,constructor:function(){var me=this;function iconConfig(fileName,variants){var config={};if(variants===undefined){variants=["x32","x16"]}Ext.each(variants,function(variant){config[variant]=variant+"/"+fileName});return config}me.constructor.superclass.constructor.call(me,{stylePrefix:"nx-atlas-icon-",icons:{arrow_refresh:"arrow_refresh.png",download:iconConfig("download.png"),error:iconConfig("error.png"),file_extension_zip:iconConfig("file_extension_zip.png"),globe_place:iconConfig("globe_place.png"),printer:iconConfig("printer.png"),server_information:iconConfig("server_information.png"),support:iconConfig("support.png"),atlas:"@globe_place",print:"@printer",refresh:"@arrow_refresh",sysinfo:"@server_information",warning:"@error",zip:"@file_extension_zip"}})}});
NX.define("Nexus.atlas.controller.Atlas",{extend:"Nexus.controller.Controller",requires:["Nexus.siesta","Nexus.atlas.view.Panel","Nexus.atlas.view.SupportZipCreated","Nexus.util.DownloadHelper"],init:function(){var me=this;me.control({"#nx-atlas-view-sysinfo":{activate:me.loadSysInfo},"#nx-atlas-view-sysinfo-button-refresh":{click:me.refreshSysInfo},"#nx-atlas-view-sysinfo-button-download":{click:me.downloadSysInfo},"#nx-atlas-view-sysinfo-button-print":{click:me.printSysInfo},"#nx-atlas-button-supportzip-create":{click:me.createSupportZip},"#nx-atlas-button-supportzip-download":{authenticated:me.downloadSupportZip},"#nx-atlas-button-supportrequest-makerequest":{click:me.makeSupportRequest}});me.addNavigationMenu()},addNavigationMenu:function(){Sonatype.Events.on("nexusNavigationInit",function(panel){var sp=Sonatype.lib.Permissions;panel.add({enabled:sp.checkPermission("nexus:atlas",sp.READ),sectionId:"st-nexus-config",title:"Support Tools",tabId:"supporttools",tabCode:function(){return Ext.create({xtype:"nx-atlas-view-panel",id:"supporttools"})}})})},loadSysInfo:function(panel){var me=this,mask=NX.create("Ext.LoadMask",panel.getEl(),{msg:"Loading..."});me.logDebug("Refreshing sysinfo");mask.show();Ext.Ajax.request({url:Nexus.siesta.basePath+"/atlas/system-information",scope:me,callback:function(){mask.hide()},success:function(response,opts){var obj=Ext.decode(response.responseText);panel.setInfo(obj)}})},refreshSysInfo:function(button){this.loadSysInfo(Ext.getCmp("nx-atlas-view-sysinfo"))},downloadSysInfo:function(button){Nexus.util.DownloadHelper.downloadUrl(Nexus.siesta.basePath+"/atlas/system-information")},printSysInfo:function(button){var me=this,panel=Ext.getCmp("nx-atlas-view-sysinfo"),win;win=window.open("","","width=640,height=480");if(win==null){alert("Print window pop-up was blocked!");return}win.document.write("<html><head>");win.document.write("<title>System Information</title>");win.document.write("</head><body>");win.document.write(panel.body.dom.innerHTML);win.document.write("</body></html>");win.print()},createSupportZip:function(button){var me=this,viewport=button.up("viewport"),mask=NX.create("Ext.LoadMask",viewport.getEl(),{msg:"Creating support ZIP file..."}),values=Ext.getCmp("nx-atlas-view-supportzip").getValues(),request={};me.logDebug("Creating support ZIP file");mask.show();Ext.iterate(values,function(key,value){request[key]=value==="on"?true:value});Ext.Ajax.request({url:Nexus.siesta.basePath+"/atlas/support-zip",method:"POST",jsonData:request,scope:me,callback:function(){mask.hide()},success:function(response,opts){var obj=Ext.decode(response.responseText),win=NX.create("Nexus.atlas.view.SupportZipCreated");win.setValues(obj);win.show()}})},downloadSupportZip:function(button,authTicket){var me=this,win=button.up("nx-atlas-view-supportzip-created"),fileName=win.getValues().name;authTicket=Sonatype.utils.base64.encode(authTicket);if(Nexus.util.DownloadHelper.downloadUrl(Nexus.siesta.basePath+"/wonderland/download/"+fileName+"?t="+authTicket)){win.close()}},makeSupportRequest:function(){var win=NX.global.open("http://links.sonatype.com/products/nexus/pro/support-request");if(win==null){alert("Window pop-up was blocked!")}}});
define("nexus-atlas-plugin-boot",["Nexus/atlas/controller/Atlas"],function(){NX.log.debug("Module loaded: nexus-atlas-plugin-boot");NX.create("Nexus.atlas.controller.Atlas").init()});
