NX.define("Nexus.timeline.FeedGrid",{extend:"Ext.grid.GridPanel",constructor:function(cfg){var self=this;Ext.apply(self,cfg);self.store=new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.feedUrl,headers:{accept:"text/xml"}}),reader:new Ext.data.XmlReader({record:"channel/item"},["title","author",{name:"pubDate",type:"date",dateFormat:"D, d M Y H:i:s T"},"link","description","content"]),sortInfo:{field:"pubDate",direction:"DESC"},autoLoad:false});self.columns=[{id:"title",header:"Title",dataIndex:"title",sortable:true,width:420,renderer:this.formatTitle},{id:"last",header:"Date",dataIndex:"pubDate",width:150,renderer:this.formatDate,sortable:true}];self.constructor.superclass.constructor.call(this,{title:"Select a feed from the list",region:"center",id:"topic-grid",loadMask:{msg:"Loading Feed..."},stripeRows:true,sm:new Ext.grid.RowSelectionModel({singleSelect:true}),viewConfig:{forceFit:true,enableRowBody:true,showPreview:true,getRowClass:this.applyRowClass,emptyText:"No artifacts match this query"},tools:[{id:"refresh",handler:function(e,toolEl,panel){if(this.feedUrl){this.store.reload()}},scope:this}]})},setFeed:function(name,url){this.setTitle(name);this.feedUrl=url;this.store.proxy=new Ext.data.HttpProxy({url:this.feedUrl,headers:{accept:"text/xml"}});this.reloadFeed()},reloadFeed:function(){if(this.feedUrl){this.store.reload()}},togglePreview:function(show){this.view.showPreview=show;this.view.refresh()},applyRowClass:function(record,rowIndex,p,ds){if(this.showPreview){var xf=Ext.util.Format;p.body="<p>"+xf.ellipsis(xf.stripTags(record.data.description),400)+"</p>";return"x-grid3-row-expanded"}return"x-grid3-row-collapsed"},formatDate:function(value){if(!value){return""}var now=new Date();var d=now.clearTime(true);value=value.add(Date.MINUTE,d.getTimezoneOffset()*(-1));var notime=value.clearTime(true).getTime();if(notime==d.getTime()){return"Today "+value.dateFormat("g:i a")}d=d.add("d",-6);if(d.getTime()<=notime){return value.dateFormat("D g:i a")}return value.dateFormat("n/j g:i a")},formatTitle:function(value,p,record){return String.format('<div class="topic"><b><a href="{1}" target="_blank">{0}</a></b><span class="author">{2}</span></div>',value,record.data.link,record.data.author)}});
NX.define("Nexus.timeline.FeedView",{extend:"Ext.Panel",requires:["Nexus.timeline.FeedGrid"],constructor:function(cfg){var self=this;Ext.apply(self,cfg||{},{feedUrl:"",title:"Feed Viewer"});self.feedRecordConstructor=Ext.data.Record.create([{name:"resourceURI"},{name:"name",sortType:Ext.data.SortTypes.asUCString}]);self.feedReader=new Ext.data.JsonReader({root:"data",id:"resourceURI"},self.feedRecordConstructor);self.feedsDataStore=new Ext.data.Store({url:Sonatype.config.repos.urls.feeds,reader:self.feedReader,sortInfo:{field:"name",direction:"ASC"},autoLoad:true});self.feedsGridPanel=new Ext.grid.GridPanel({id:"st-feeds-grid",region:"north",layout:"fit",collapsible:true,split:true,height:160,minHeight:120,maxHeight:400,frame:false,autoScroll:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),tbar:[{text:"Refresh",icon:Sonatype.config.resourcePath+"/static/images/icons/arrow_refresh.png",cls:"x-btn-text-icon",handler:function(){self.feedsDataStore.reload();self.grid.reloadFeed()}},{text:"Subscribe",icon:Sonatype.config.resourcePath+"/static/images/icons/feed.png",cls:"x-btn-text-icon",handler:function(){if(self.feedsGridPanel.getSelectionModel().hasSelection()){var rec=self.feedsGridPanel.getSelectionModel().getSelected();Sonatype.utils.openWindow(rec.get("resourceURI"))}}}],ds:self.feedsDataStore,sortInfo:{field:"name",direction:"ASC"},loadMask:true,deferredRender:false,columns:[{header:"Feed",dataIndex:"name",width:300},{header:"URL",dataIndex:"resourceURI",width:300,id:"feeds-url-col",renderer:function(s){return'<a href="'+s+'" target="_blank">'+s+"</a>"},menuDisabled:true}],autoExpandColumn:"feeds-url-col",disableSelection:false});self.feedsGridPanel.getSelectionModel().on("rowselect",self.rowSelect,self);self.viewItemTemplate=new Ext.Template('<div class="post-data">','<span class="post-date">{pubDate:date("M j, Y, g:i a")}</span>','<h3 class="post-title">{title}</h3>','<h4 class="post-author">by {author:defaultValue("Unknown")}</h4>',"</div>",'<div class="post-body">',"{content:this.getBody}","</div>");self.viewItemTemplate.compile();self.viewItemTemplate.getBody=function(v,all){return Ext.util.Format.stripScripts(v||all.description)};self.grid=NX.create("Nexus.timeline.FeedGrid");self.constructor.superclass.constructor.call(self,{layout:"border",title:self.title,hideMode:"offsets",items:[self.feedsGridPanel,self.grid]});self.gsm=self.grid.getSelectionModel();self.grid.store.on("load",self.gsm.selectFirstRow,self.gsm)},rowSelect:function(selectionModel,index,rec){this.grid.setFeed(rec.get("name"),rec.get("resourceURI"))}},function(){Sonatype.config.repos.urls.feeds=Sonatype.config.servicePath+"/feeds";Sonatype.Events.addListener("nexusNavigationInit",function(panel){var sp=Sonatype.lib.Permissions;panel.add({enabled:sp.checkPermission("nexus:feeds",sp.READ),sectionId:"st-nexus-views",title:"System Feeds",tabId:"feed-view-system-changes",tabCode:Nexus.timeline.FeedView})})});
NX.define("nexus-timeline-plugin-boot",{requires:["Nexus.timeline.FeedView"]},function(){NX.log.debug("Timeline plugin loaded")});
