NX.define("Nexus.capabilities.CapabilityView",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.Icons","Nexus.capabilities.CapabilitySummary","Nexus.capabilities.CapabilitySettings","Nexus.capabilities.CapabilityStatus","Nexus.capabilities.CapabilityAbout"],initComponent:function(){var self=this,icons=Nexus.capabilities.Icons;self.messageTpl=NX.create("Ext.XTemplate",'<div class="nx-capabilities-CapabilitySummary-message">',"  <div>{icon}{html}</div>","</div>",{compiled:true,message:function(capability){var self=this,icons=Nexus.capabilities.Icons;if(capability.enabled&&!capability.active){return self.apply({icon:icons.get("warning").img,html:"<b>"+capability.stateDescription+"</b>."})}return""}});self.summaryView=NX.create("Nexus.capabilities.CapabilitySummary");self.settingsView=NX.create("Nexus.capabilities.CapabilitySettings");self.statusView=NX.create("Nexus.capabilities.CapabilityStatus");self.aboutView=NX.create("Nexus.capabilities.CapabilityAbout");Ext.apply(self,{cls:"nx-capabilities-CapabilityView",header:true,border:false,layout:"fit",items:{xtype:"tabpanel",title:"Capability",iconCls:icons.get("capability").cls,items:[self.summaryView,self.settingsView,self.statusView,self.aboutView],activeTab:0,layoutOnTabChange:true}});self.constructor.superclass.initComponent.apply(self,arguments)},updateRecord:function(capability){var self=this,icons=Nexus.capabilities.Icons;self.setTitle(self.mediator().describeCapability(capability)+self.messageTpl.message(capability),icons.iconFor(capability).cls);self.summaryView.setCapability(capability);self.settingsView.setCapability(capability);self.statusView.setCapability(capability);self.aboutView.setCapability(capability)}});
NX.define("Nexus.capabilities.CapabilitiesGridFilterBox",{extend:"Nexus.ext.GridFilterBox",mixins:["Nexus.capabilities.CapabilitiesMediatorMixin"],matches:function(filterValue,record,fieldName,fieldValue){var self=this;return(fieldValue&&self.filteredStore.getTagKeyFrom(fieldName)&&self.filterFn(fieldName,filterValue))||Nexus.capabilities.CapabilitiesGridFilterBox.superclass.matches(filterValue,record,fieldName,fieldValue)||self.filterFn(self.mediator().getStatusLabel(record.data),filterValue)}});
NX.define("Nexus.capabilities.CapabilityTypeStore",{extend:"Ext.data.JsonStore",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.siesta"],constructor:function(config){var self=this,ST=Ext.data.SortTypes;config=config||{};Ext.apply(config,{url:Nexus.siesta.basePath+"/capabilities/types",id:"id",fields:[{name:"id"},{name:"name"},{name:"about"},{name:"formFields"}],sortInfo:{field:"id",direction:"ASC"},listeners:{load:{fn:function(){this.logDebug("Loaded "+self.getCount()+" types")},scope:self}}});self.constructor.superclass.constructor.call(self,config)},getTypeById:function(id){var record=this.getById(id);if(record){return record.data}}});
NX.define("Nexus.capabilities.CapabilitiesGridStore",{extend:"Ext.data.GroupingStore",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.Icons","Nexus.capabilities.CapabilityStore"],constructor:function(config){var self=this,config=config||{},ST=Ext.data.SortTypes,fields=[{name:"id"},{name:"description",sortType:ST.asUCString},{name:"notes",sortType:ST.asUCString},{name:"enabled"},{name:"active"},{name:"error"},{name:"typeName"},{name:"typeId"},{name:"stateDescription"},{name:"status"},{name:"properties"},{name:"$capability"}];self.tagKeys=config.capabilityStore.tagKeys;if(self.tagKeys){Ext.each(self.tagKeys,function(key){fields.push({name:"tag$"+key,sortType:ST.asUCString})})}Ext.apply(config,{reader:NX.create("Ext.data.JsonReader",{fields:fields}),autoDestroy:true,sortInfo:{field:"typeName",direction:"ASC"}});self.constructor.superclass.constructor.call(self,config);self.loadCapabilities()},loadCapabilities:function(){var self=this,recordType=this.recordType,newRecords=[];self.capabilityStore.each(function(record){var newRecord,overrideConfig={};if(record.data.$tags){for(var key in record.data.$tags){overrideConfig["tag$"+key]=record.data.$tags[key]}}newRecord=new recordType(Ext.apply(Ext.apply({},record.data),overrideConfig),record.id);newRecords.push(newRecord)});self.loadRecords({records:newRecords},{})},getColumnModel:function(){var self=this,icons=Nexus.capabilities.Icons,columns=[];columns.push({width:30,resizable:false,sortable:false,fixed:true,hideable:false,menuDisabled:true,renderer:function(value,metaData,record){return icons.iconFor(record.data).img}},{id:"typeName",width:175,header:"Type",dataIndex:"typeName",sortable:true});if(self.tagKeys){Ext.each(self.tagKeys,function(key){columns.push({id:"tag$"+key,width:100,header:key,dataIndex:"tag$"+key,sortable:true})})}columns.push({id:"description",width:250,header:"Description",dataIndex:"description",sortable:true},{id:"notes",width:175,header:"Notes",dataIndex:"notes",sortable:true});return NX.create("Ext.grid.ColumnModel",{columns:columns})},getTagKeyFrom:function(name){if(name.startsWith("tag$")){return name.substring("tag$".length)}}});
NX.define("Nexus.capabilities.CapabilitiesMediator",{singleton:true,mixins:["Nexus.LogAwareMixin"],requires:["Nexus.capabilities.Icons","Nexus.capabilities.CapabilityStore","Nexus.capabilities.CapabilityTypeStore","Nexus.capabilities.factory.ComboFactory"],capabilityStore:undefined,capabilityTypeStore:undefined,comboFactory:undefined,constructor:function(){var self=this;self.capabilityStore=NX.create("Nexus.capabilities.CapabilityStore");self.capabilityTypeStore=NX.create("Nexus.capabilities.CapabilityTypeStore");self.comboFactory=Nexus.capabilities.factory.ComboFactory},addCapability:function(capability,successHandler,failureHandler){var self=this;self.logDebug("Adding capability: "+Ext.encode(capability));Ext.Ajax.request({url:self.capabilityStore.url,method:"POST",scope:self,suppressStatus:true,jsonData:capability,success:successHandler,failure:failureHandler})},updateCapability:function(capability,successHandler,failureHandler){var self=this;self.logDebug("Updating capability: "+Ext.encode(capability));Ext.Ajax.request({url:self.capabilityStore.urlOf(capability.id),method:"PUT",scope:self,suppressStatus:true,jsonData:capability,success:successHandler,failure:failureHandler})},enableCapability:function(capability,successHandler,failureHandler){var self=this;self.logDebug("Enabling capability: "+capability.id);Ext.Ajax.request({url:self.capabilityStore.urlOf(capability.id)+"/enable",method:"PUT",scope:self,suppressStatus:true,success:successHandler,failure:failureHandler})},disableCapability:function(capability,successHandler,failureHandler){var self=this;self.logDebug("Disabling capability: "+capability.id);Ext.Ajax.request({url:self.capabilityStore.urlOf(capability.id)+"/disable",method:"PUT",scope:self,suppressStatus:true,success:successHandler,failure:failureHandler})},deleteCapability:function(capability,successHandler,failureHandler){var self=this;self.logDebug("Deleting capability: "+capability.id);Ext.Ajax.request({url:self.capabilityStore.urlOf(capability.id),method:"DELETE",scope:self,suppressStatus:true,success:successHandler,failure:failureHandler})},describeCapability:function(capability){var description=capability.typeName;if(capability.description){description+=" - "+capability.description}return description},showMessage:function(title,message){Nexus.messages.show(title,message)},refresh:function(){var self=this;self.logDebug("Refreshing stores");self.capabilityStore.reload();self.capabilityTypeStore.reload();self.comboFactory.evictCache()},handleError:function(response,options,title,form){var handled=false,remainingMessages=[],message;if(response.siestaValidationError){handled=true;Ext.each(response.siestaValidationError,function(error){var marked=false,field;if(form){field=form.findField("property."+error.id);if(!field){field=form.findField(error.id)}if(field){marked=true;field.markInvalid(error.message)}}if(!marked){remainingMessages.push(error.message)}})}if(response.siestaError){handled=true;remainingMessages.push(response.siestaError.message)}if(!handled){if(response.responseText){message=Sonatype.utils.parseHTMLErrorMessage(response.responseText)}if(!message){message=title+" ("+response.statusText+")";title=undefined}remainingMessages.push(message)}if(remainingMessages.length>0){Ext.Msg.show({title:title||"Operation failed",msg:remainingMessages.join("\n"),buttons:Ext.Msg.OK,icon:Ext.MessageBox.ERROR,closeable:false})}},getStatusLabel:function(capability){var enabled=capability.enabled,active=capability.active,error=capability.error;if(enabled&&error){return"Error"}if(enabled&&active){return"Active"}if(enabled&&!active){return"Passive"}return"Disabled"}});
NX.define("Nexus.capabilities.CreateCapabilityWindow",{extend:"Ext.Window",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.Icons","Nexus.capabilities.CapabilitySettingsFieldSet"],constructor:function(callbackOnSuccess){var self=this;self.callbackOnSuccess=callbackOnSuccess;self.constructor.superclass.constructor.call(self)},initComponent:function(){var self=this;self.aboutPanel=NX.create("Ext.Panel",{border:false,frame:false,html:""});self.settings=NX.create("Nexus.capabilities.CapabilitySettingsFieldSet",{title:"Settings"});self.formPanel=NX.create("Ext.form.FormPanel",{border:false,monitorValid:true,labelWidth:175,items:[{xtype:"fieldset",autoHeight:true,collapsed:false,border:false,items:{xtype:"combo",fieldLabel:"Type",itemCls:"required-field",helpText:"Type of configured capability",name:"typeId",store:self.mediator().capabilityTypeStore,displayField:"name",valueField:"id",forceSelection:true,editable:false,mode:"local",triggerAction:"all",emptyText:"Select...",selectOnFocus:true,allowBlank:false,anchor:"96%",listeners:{select:self.handleCapabilityTypeSelected.createDelegate(self)}}},{xtype:"fieldset",title:"About",autoHeight:false,autoScroll:true,collapsible:true,collapsed:false,items:self.aboutPanel,listeners:{collapse:function(){self.fixMask()}}},self.settings],buttons:[{text:"Add",formBind:true,scope:self,handler:self.handleAdd},{xtype:"link-button",text:"Cancel",formBind:false,scope:self,handler:self.handleCancel}],keys:[{key:Ext.EventObject.ESC,scope:self,fn:self.handleCancel}]});Ext.apply(self,{cls:"nx-capabilities-CreateCapabilityWindow",title:"Create new capability",width:640,autoHeight:true,border:false,modal:true,constrain:true,closable:false,resizable:true,items:[self.formPanel],listeners:{show:function(){}}});self.constructor.superclass.initComponent.apply(self,arguments)},importCapability:function(capability){var self=this,form=self.formPanel.getForm();self.settings.importCapability(form,capability);self.renderAbout(capability.typeId);self.doLayout()},callbackOnSuccess:undefined,aboutPanel:undefined,settings:undefined,fixMask:function(){var self=this;self.setPosition(self.getPosition())},handleCapabilityTypeSelected:function(combo){var self=this;self.renderAbout(combo.getValue());self.settings.setCapabilityType(combo.getValue());self.doLayout();self.fixMask()},renderAbout:function(capabilityTypeId){var self=this,about="",capabilityType=self.mediator().capabilityTypeStore.getTypeById(capabilityTypeId);if(capabilityType){about=capabilityType.about}self.aboutPanel.html=about;if(self.aboutPanel.body){self.aboutPanel.body.update(about)}},handleAdd:function(){var self=this,form=self.formPanel.getForm(),mask=NX.create("Ext.LoadMask",self.body,{msg:"Please wait..."}),capability;mask.show();capability=self.settings.exportCapability(form);self.mediator().addCapability(capability,function(response){self.mediator().showMessage("Capability added",self.mediator().describeCapability({typeName:self.settings.capabilityType.name}));mask.hide();self.close();if(self.callbackOnSuccess){var responseObj=Ext.decode(response.responseText);if(responseObj&&responseObj.capability){self.callbackOnSuccess(responseObj.capability.id)}}},function(response,options){self.mediator().handleError(response,options,"Capability could not be created",self.formPanel.getForm());mask.hide()})},handleCancel:function(){this.close()}});
NX.define("Nexus.capabilities.Icons",{extend:"Nexus.util.IconContainer",singleton:true,constructor:function(){var self=this;function iconConfig(fileName,variants){var config={};if(variants===undefined){variants=["x32","x16"]}Ext.each(variants,function(variant){config[variant]=variant+"/"+fileName});return config}self.constructor.superclass.constructor.call(self,{stylePrefix:"nx-capabilities-icon-",icons:{capability:iconConfig("brick.png"),capability_add:iconConfig("brick_add.png"),capability_delete:iconConfig("brick_delete.png"),capability_new:iconConfig("brick_edit.png"),capability_active:iconConfig("brick_valid.png"),capability_passive:iconConfig("brick_error.png"),capability_disabled:iconConfig("brick_grey.png"),capability_error:iconConfig("brick_error.png"),cross:"cross.png",cross_grey:"cross_grey.png",filter:"filter.png",filter_grey:"filter_grey.png",warning:"error.png",magnifier:"magnifier.png",magnifier_grey:"magnifier_grey.png",refresh:"arrow_refresh.png",selectionEmpty:"@warning",enable:"@capability_active",disable:"@capability_disabled"}})},iconFor:function(capability){var self=this,typeName=capability.typeName,enabled=capability.enabled,active=capability.active,error=capability.error,iconName;if(!typeName){iconName="capability_new"}else{if(enabled&&error){iconName="capability_error"}else{if(enabled&&active){iconName="capability_active"}else{if(enabled&&!active){iconName="capability_passive"}else{iconName="capability_disabled"}}}}return self.get(iconName)}});
NX.define("Nexus.capabilities.CapabilitiesView",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.Icons","Nexus.masterdetail.MasterDetail","Nexus.masterdetail.EmptySelection","Nexus.capabilities.CapabilitiesGrid","Nexus.capabilities.CapabilityView"],initComponent:function(){var self=this,icons=Nexus.capabilities.Icons;Ext.apply(self,{cls:"nx-capabilities-CapabilitiesView",layout:"border",items:NX.create("Nexus.masterdetail.MasterDetail",NX.create("Nexus.capabilities.CapabilitiesGrid",{region:"center"}),NX.create("Nexus.capabilities.CapabilityView"),NX.create("Nexus.masterdetail.EmptySelection",{iconCls:icons.get("selectionEmpty").cls,entityType:"capability"}))});self.constructor.superclass.initComponent.apply(self,arguments)}},function(){var type=this,sp=Sonatype.lib.Permissions;NX.log.debug("Adding global view: "+type.$className);Sonatype.Events.on("nexusNavigationInit",function(panel){panel.add({enabled:sp.checkPermission("nexus:capabilities",sp.READ),sectionId:"st-nexus-config",title:"Capabilities",tabId:"capabilities",tabCode:type});NX.log.debug("Registered global view: "+type.$className)})});
NX.define("Nexus.capabilities.CapabilitySettings",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.CapabilitySettingsFieldSet"],currentRecord:undefined,settings:undefined,initComponent:function(){var self=this;self.settings=NX.create("Nexus.capabilities.CapabilitySettingsFieldSet",{border:false,parentPanel:self});self.formPanel=NX.create("Ext.FormPanel",{border:false,items:self.settings,buttonAlign:"left",buttons:[{text:"Save",formBind:true,scope:self,handler:function(){self.updateCapability()}},{xtype:"link-button",text:"Discard",formBind:false,scope:self,handler:function(){self.setCapability(self.currentRecord)}}]});Ext.apply(self,{cls:"nx-capabilities-CapabilitySettings",title:"Settings",autoScroll:true,items:[self.formPanel],listeners:{activate:{fn:function(){self.setCapability(self.currentRecord)},scope:self}}});self.constructor.superclass.initComponent.apply(self,arguments)},setCapability:function(capability){var self=this,sp=Sonatype.lib.Permissions,editable=sp.checkPermission("nexus:capabilities",sp.EDIT);self.currentRecord=capability;self.settings.importCapability(self.formPanel.getForm(),capability);self.doLayout();self.togglePermission(self.items,editable)},updateCapability:function(){var self=this,form=self.formPanel.getForm(),capability;if(!form.isValid()){return}capability=Ext.apply(self.settings.exportCapability(form),{id:self.currentRecord.id,notes:self.currentRecord.notes});self.mediator().updateCapability(capability,function(){form.items.each(function(item){item.clearInvalid()});self.mediator().showMessage("Capability saved",self.mediator().describeCapability(self.currentRecord));self.mediator().refresh()},function(response,options){self.mediator().handleError(response,options,"Capability could not be saved",form)})},togglePermission:function(items,enabled){var self=this,iterable;if(items){iterable=items.items;if(!iterable){iterable=items}Ext.each(iterable,function(item){if(item){if(item.requiresPermission){if(enabled){item.enable()}else{item.disable()}}self.togglePermission(item.items,enabled)}})}}});
NX.define("Nexus.capabilities.factory.NumberFieldFactory",{singleton:true,supports:["numberfield","number"],create:function(formField){var item={xtype:"numberfield",fieldLabel:formField.label,itemCls:formField.required?"required-field":"",helpText:formField.helpText,allowBlank:formField.required?false:true,regex:formField.regexValidation?new RegExp(formField.regexValidation):null,anchor:"96%"};if(formField.initialValue){item.value=Number(formField.initialValue)}return item}});
NX.define("Nexus.capabilities.factory.CheckboxFactory",{singleton:true,supports:["checkbox"],create:function(formField){var item={xtype:"checkbox",fieldLabel:formField.label,helpText:formField.helpText};if(formField.initialValue){item.checked=Boolean("true"===formField.initialValue)}return item}});
NX.define("Nexus.capabilities.factory.TextFieldFactory",{singleton:true,supports:["textfield","string","password"],create:function(formField){var item={xtype:"textfield",htmlDecode:true,fieldLabel:formField.label,itemCls:formField.required?"required-field":"",helpText:formField.helpText,allowBlank:formField.required?false:true,regex:formField.regexValidation?new RegExp(formField.regexValidation):null,anchor:"96%"};if(formField.type==="password"){item.inputType="password"}if(formField.initialValue){item.value=formField.initialValue}return item}});
NX.define("Nexus.capabilities.factory.TextAreaFactory",{singleton:true,supports:["textarea","text-area"],create:function(formField){var item={xtype:"textarea",htmlDecode:true,fieldLabel:formField.label,itemCls:formField.required?"required-field":"",helpText:formField.helpText,allowBlank:formField.required?false:true,regex:formField.regexValidation?new RegExp(formField.regexValidation):null,anchor:"96%"};if(formField.initialValue){item.value=formField.initialValue}return item}});
NX.define("Nexus.capabilities.factory.ComboFactory",{singleton:true,mixins:["Nexus.LogAwareMixin"],supports:["combo","combobox","repo","repo-or-group","repo-target"],stores:{},create:function(formField){var self=this,ST=Ext.data.SortTypes,store,item=NX.create("Ext.form.ComboBox",{xtype:"combo",fieldLabel:formField.label,itemCls:formField.required?"required-field":"",helpText:formField.helpText,name:formField.id,displayField:"name",valueField:"id",editable:false,forceSelection:true,mode:"local",triggerAction:"all",emptyText:"Select...",selectOnFocus:true,allowBlank:formField.required?false:true,anchor:"96%"});if(formField.initialValue){item.value=formField.initialValue}if(formField.storePath){store=self.stores[formField.storePath];if(!store){store=NX.create("Ext.data.JsonStore",{url:Sonatype.config.contextPath+formField.storePath,id:formField.idMapping||"id",root:formField.storeRoot,fields:[{name:"id",mapping:formField.idMapping||"id"},{name:"name",mapping:formField.nameMapping||"name",sortType:ST.asUCString}],sortInfo:{field:"name",direction:"ASC"},autoLoad:true});self.stores[formField.storePath]=store;self.logDebug("Caching store for "+store.url)}item.store=store}return item},evictCache:function(){var self=this;self.logDebug("Evicted all cached stores");self.stores={}}});
NX.define("Nexus.capabilities.factory.DateFieldFactory",{singleton:true,supports:["datefield","date"],create:function(formField){var item={xtype:"datefield",htmlDecode:true,fieldLabel:formField.label,itemCls:formField.required?"required-field":"",helpText:formField.helpText,allowBlank:formField.required?false:true,regex:formField.regexValidation?new RegExp(formField.regexValidation):null,value:new Date(),anchor:"96%"};if(formField.initialValue){item.value=new Date(Number(formField.initialValue))}return item}});
NX.define("Nexus.capabilities.CapabilitiesGrid",{extend:"Ext.grid.GridPanel",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.Icons","Nexus.capabilities.CapabilitiesGridStore","Nexus.capabilities.CreateCapabilityWindow","Nexus.capabilities.CapabilitiesGridFilterBox"],initComponent:function(){var self=this,icons=Nexus.capabilities.Icons;self.buttonAdd=NX.create("Ext.Button",{text:"New",iconCls:icons.get("capability_add").cls,tooltip:"Add a new capability",handler:function(){self.addCapability()},disabled:true});self.buttonDuplicate=NX.create("Ext.Button",{text:"Duplicate",iconCls:icons.get("capability_add").cls,tooltip:"Duplicates selected capability",handler:function(){var selections=self.getSelectionModel().getSelections();if(selections.length>0){self.duplicateCapability(selections[0].data)}},disabled:true});self.buttonDelete=NX.create("Ext.Button",{text:"Delete",iconCls:icons.get("capability_delete").cls,tooltip:"Delete selected capability",handler:function(button){var selections=self.getSelectionModel().getSelections();if(selections.length>0){self.deleteCapability(selections[0].data,button.btnEl)}},disabled:true});self.gridStore=NX.create("Nexus.capabilities.CapabilitiesGridStore",{capabilityStore:self.mediator().capabilityStore});self.filterBox=NX.create("Nexus.capabilities.CapabilitiesGridFilterBox",{filteredGrid:self,width:200});Ext.apply(self,{cls:"nx-capabilities-CapabilityGrid",ds:self.gridStore,stripeRows:true,border:false,loadMask:{msg:"Loading...",msgCls:"loading-indicator"},view:NX.create("Ext.grid.GroupingView",{emptyText:"No capabilities defined",emptyTextWhileFiltering:"No capabilities matched criteria: {criteria}",deferEmptyText:false,getRowClass:function(record){var capability=record.data;if(capability.enabled&&!capability.active){return"red-flag"}},forceFit:true,groupTextTpl:'{[values.text.replace("undefined","(none)").replace("null","(none)")]}'}),sm:NX.create("Ext.grid.RowSelectionModel",{singleSelect:true,listeners:{selectionchange:{fn:self.selectionChanged,scope:self}}}),colModel:self.gridStore.getColumnModel(),autoExpandColumn:"notes",tbar:[{text:"Refresh",tooltip:"Refresh capabilities",iconCls:icons.get("refresh").cls,handler:function(){self.refresh()}},self.buttonAdd,self.buttonDuplicate,self.buttonDelete,"->",self.filterBox],listeners:{destroy:{fn:function(){self.mediator().capabilityStore.removeListener("beforeload",self.rememberSelection,self);self.mediator().capabilityStore.removeListener("load",self.reconfigureGrid,self);self.mediator().capabilityTypeStore.removeListener("beforeload",self.disableAddButton,self);self.mediator().capabilityTypeStore.removeListener("load",self.maybeEnableAddButton,self)},scope:self},render:{fn:function(){self.mediator().capabilityStore.on("beforeload",self.rememberSelection,self);self.mediator().capabilityStore.on("load",self.reconfigureGrid,self);self.mediator().capabilityTypeStore.on("beforeload",self.disableAddButton,self);self.mediator().capabilityTypeStore.on("load",self.maybeEnableAddButton,self)},scope:self}}});self.constructor.superclass.initComponent.apply(self,arguments);self.refresh();self.on("rowcontextmenu",self.showMenu,self)},selectionChanged:function(sm){var self=this,sp=Sonatype.lib.Permissions;self.buttonDuplicate.disable();self.buttonDelete.disable();if(sm.getCount()!==0){if(sp.checkPermission("nexus:capabilities",sp.CREATE)){self.buttonDuplicate.enable()}if(sp.checkPermission("nexus:capabilities",sp.DELETE)){self.buttonDelete.enable()}}},selectedRecords:undefined,rememberSelection:function(){this.selectedRecords=this.getSelectionModel().getSelections()},recallSelection:function(){var self=this,toSelect=[];if(self.selectedRecords===undefined||self.selectedRecords.length===0){return}Ext.each(self.selectedRecords,function(record){record=self.getStore().getById(record.id);if(!Ext.isEmpty(record)){toSelect.push(record)}});self.getSelectionModel().selectRecords(toSelect)},refreshAndSelect:function(capabilityId){var self=this;self.getSelectionModel().clearSelections();self.refresh();self.mediator().capabilityStore.on("load",function(){var record=self.getStore().getById(capabilityId);if(!Ext.isEmpty(record)){self.getSelectionModel().selectRecords([record])}},self,{single:true})},reconfigureGrid:function(){var self=this;if(!self.mediator().capabilityStore.sameTagKeysAs(self.gridStore.tagKeys)){self.gridStore=NX.create("Nexus.capabilities.CapabilitiesGridStore",{capabilityStore:self.mediator().capabilityStore});self.gridStore.on("load",self.recallSelection,self);self.reconfigure(self.gridStore,self.gridStore.getColumnModel())}else{self.gridStore.loadCapabilities()}},refresh:function(){this.mediator().refresh()},deleteCapability:function(capability,animEl){var self=this;Ext.Msg.show({title:"Confirm deletion?",msg:self.mediator().describeCapability(capability),buttons:Ext.Msg.YESNO,animEl:animEl,icon:Ext.MessageBox.QUESTION,closeable:false,scope:self,fn:function(buttonName){if(buttonName==="yes"||buttonName==="ok"){self.mediator().deleteCapability(capability,function(){self.mediator().showMessage("Capability deleted",self.mediator().describeCapability(capability));self.refresh()},function(response,options){self.mediator().handleError(response,options,"Capability could not be deleted");if(response.status===404){self.refresh()}})}}})},enableCapability:function(capability){var self=this;self.mediator().enableCapability(capability,function(){self.mediator().showMessage("Capability enabled",self.mediator().describeCapability(capability));self.refresh()},function(response,options){self.mediator().handleError(response,options,"Capability could not be enabled");if(response.status===404){self.refresh()}})},disableCapability:function(capability){var self=this;self.mediator().disableCapability(capability,function(){self.mediator().showMessage("Capability disabled",self.mediator().describeCapability(capability));self.refresh()},function(response,options){self.mediator().handleError(response,options,"Capability could not be disabled");if(response.status===404){self.refresh()}})},addCapability:function(){NX.create("Nexus.capabilities.CreateCapabilityWindow",this.refreshAndSelect.createDelegate(this)).show()},duplicateCapability:function(capability){if(capability){NX.create("Nexus.capabilities.CreateCapabilityWindow",this.refreshAndSelect.createDelegate(this)).show().importCapability(capability)}},contextMenuRow:undefined,showMenu:function(grid,index,e){var self=this,sp=Sonatype.lib.Permissions,icons=Nexus.capabilities.Icons,row=grid.view.getRow(index),capability=self.store.getAt(index).data,menu;self.hideMenu();self.contextMenuRow=row;Ext.fly(row).addClass("x-node-ctx");menu=new Ext.menu.Menu({items:[{text:"Refresh",iconCls:icons.get("refresh").cls,scope:self,handler:self.refresh.createDelegate(self)}]});if(sp.checkPermission("nexus:capabilities",sp.EDIT)){menu.add("-");if(capability.enabled){menu.add({text:"Disable",iconCls:icons.get("disable").cls,scope:self,handler:self.disableCapability.createDelegate(self,[capability])})}else{menu.add({text:"Enable",iconCls:icons.get("enable").cls,scope:self,handler:self.enableCapability.createDelegate(self,[capability])})}}if(sp.checkPermission("nexus:capabilities",sp.CREATE)){menu.add("-");menu.add({text:"Duplicate",iconCls:icons.get("capability_add").cls,scope:self,handler:self.duplicateCapability.createDelegate(self,[capability])})}if(sp.checkPermission("nexus:capabilities",sp.DELETE)){if(!sp.checkPermission("nexus:capabilities",sp.CREATE)){menu.add("-")}menu.add({text:"Delete",iconCls:icons.get("capability_delete").cls,scope:self,handler:self.deleteCapability.createDelegate(self,[capability])})}e.stopEvent();self.getSelectionModel().selectRow(index,false);menu.on("hide",self.hideMenu,self);menu.showAt(e.getXY())},hideMenu:function(){var self=this;if(self.contextMenuRow){Ext.fly(self.contextMenuRow).removeClass("x-node-ctx");this.contextMenuRow=null}},disableAddButton:function(){var self=this;self.buttonAdd.disable()},maybeEnableAddButton:function(){var self=this,sp=Sonatype.lib.Permissions,canCreate=sp.checkPermission("nexus:capabilities",sp.CREATE);if(canCreate&&self.mediator().capabilityTypeStore.getCount()>0){self.buttonAdd.enable()}}});
NX.define("Nexus.capabilities.CapabilityStatus",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],initComponent:function(){var self=this;Ext.apply(self,{cls:"nx-capabilities-CapabilityStatus",title:"Status",autoScroll:true,html:""});self.constructor.superclass.initComponent.apply(self,arguments)},setCapability:function(capability){var self=this,status="Capability does not provide any status.";if(capability.status){status=capability.status}self.html=status;if(self.body){self.body.update(status)}}});
NX.define("Nexus.capabilities.CapabilitySettingsFieldSet",{extend:"Ext.form.FieldSet",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.factory.CheckboxFactory","Nexus.capabilities.factory.ComboFactory","Nexus.capabilities.factory.DateFieldFactory","Nexus.capabilities.factory.NumberFieldFactory","Nexus.capabilities.factory.TextAreaFactory","Nexus.capabilities.factory.TextFieldFactory"],initComponent:function(){var self=this;Ext.apply(self,{autoHeight:false,autoScroll:true,collapsed:false,labelWidth:120,labelSeparator:"",items:[]});self.constructor.superclass.initComponent.apply(self,arguments);self.factories=NX.create("Ext.util.MixedCollection");self.addFactory(Nexus.capabilities.factory.CheckboxFactory);self.addFactory(Nexus.capabilities.factory.ComboFactory);self.addFactory(Nexus.capabilities.factory.DateFieldFactory);self.addFactory(Nexus.capabilities.factory.NumberFieldFactory);self.addFactory(Nexus.capabilities.factory.TextAreaFactory);self.addFactory(Nexus.capabilities.factory.TextFieldFactory)},capabilityType:undefined,setCapabilityType:function(capabilityTypeId){var self=this,item;self.capabilityType=self.mediator().capabilityTypeStore.getTypeById(capabilityTypeId);self.removeAll();if(self.capabilityType){self.add({xtype:"checkbox",fieldLabel:"Enabled",helpText:"This flag determines if the capability is currently enabled. To disable this capability for a period of time, de-select this checkbox.",name:"enabled",allowBlank:false,checked:true,editable:true});if(self.capabilityType.formFields){Ext.each(self.capabilityType.formFields,function(formField){var factory=self.factories.get(formField.type);if(!factory){factory=self.factories.get("string")}if(factory){item=Ext.apply(factory.create(formField),{requiresPermission:true,name:"property."+formField.id,factory:factory});if(item.xtype==="combo"&&item.store){item.store.on("load",function(){if(item.store){item.setValue(item.getValue())}},self,{single:true})}self.add(item)}})}}},exportCapability:function(form){var self=this,values=form.getFieldValues(),value,capability={typeId:self.capabilityType.id,enabled:values.enabled,properties:[]};if(self.capabilityType&&self.capabilityType.formFields){Ext.each(self.capabilityType.formFields,function(formField){value=values["property."+formField.id];if(value){capability.properties[capability.properties.length]={key:formField.id,value:String(value)}}})}return capability},importCapability:function(form,capability){var self=this,data=Ext.apply({},capability);self.setCapabilityType(capability.typeId);if(self.capabilityType&&self.capabilityType.formFields){Ext.each(self.capabilityType.formFields,function(formField){data["property."+formField.id]=""})}if(capability.properties){Ext.each(capability.properties,function(property){data["property."+property.key]=property.value})}form.setValues(data)},factories:undefined,addFactory:function(factory){var self=this;Ext.each(factory.supports,function(supported){self.factories.add(supported,factory)})}});
NX.define("Nexus.capabilities.CapabilitiesMediatorMixin",{requires:["Nexus.capabilities.CapabilitiesMediator"],mediator:function(){return Nexus.capabilities.CapabilitiesMediator}});
NX.define("Nexus.capabilities.CapabilitySummary",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],requires:["Nexus.capabilities.Icons"],initComponent:function(){var self=this,sp=Sonatype.lib.Permissions,editable=sp.checkPermission("nexus:capabilities",sp.EDIT);self.templatePanel=NX.create("Ext.Panel",{cls:"nx-capabilities-CapabilitySummary-template",border:false});self.notesPanel=NX.create("Ext.FormPanel",{border:false,hideLabels:true,items:[{xtype:"textarea",htmlDecode:true,helpText:"Optional notes about configured capability",name:"notes",anchor:"-20px",allowBlank:true,disabled:!editable}],buttonAlign:"left",buttons:[{text:"Save",formBind:true,scope:self,handler:function(){self.updateCapability()}},{xtype:"link-button",text:"Discard",formBind:false,scope:self,handler:function(){self.setCapability(self.currentRecord)}}]});Ext.apply(self,{cls:"nx-capabilities-CapabilitySummary",title:"Summary",autoScroll:true,items:[self.templatePanel,{xtype:"fieldset",title:"Notes",autoScroll:true,collapsed:false,hideLabels:true,items:self.notesPanel}]});self.initTemplate();self.constructor.superclass.initComponent.apply(self,arguments)},initTemplate:function(){var self=this,icons=Nexus.capabilities.Icons;self.mainTpl=NX.create("Ext.XTemplate",'<div class="nx-capabilities-CapabilitySummary-body">',"{[ this.status(values) ]}","{[ this.properties(values) ]}","</div>",{compiled:true,status:function(capability){return self.statusTpl.apply(capability)},properties:function(capability){var properties;properties=[{name:"Type",value:capability.typeName}];if(capability.description){properties.push({name:"Description",value:capability.description})}if(capability.$tags){for(var key in capability.$tags){properties.push({name:key,value:capability.$tags[key]})}}return self.propertiesTpl.apply({properties:properties})}});self.statusTpl=NX.create("Ext.XTemplate",'<div class="nx-capabilities-CapabilitySummary-status">','<div class="nx-capabilities-CapabilitySummary-status-icon">',"{[ this.statusIcon(values) ]}","</div>",'<div class="nx-capabilities-CapabilitySummary-status-label">',"{[ this.statusLabel(values) ]}","</div>","</div>",{compiled:true,statusIcon:function(capability){return icons.iconFor(capability).variant("x32").img},statusLabel:self.mediator().getStatusLabel.createDelegate(self.mediator())});self.propertiesTpl=NX.create("Ext.XTemplate",'<div class="nx-capabilities-CapabilitySummary-properties">',"<table>",'<tpl for="properties">','<tr class="nx-capabilities-CapabilitySummary-properties-entry">','<td class="nx-capabilities-CapabilitySummary-properties-name">{name}</td>','<td class="nx-capabilities-CapabilitySummary-properties-value">{value}</td>',"</tr>","</tpl>","</tr>","</table>","</div>",{compiled:true})},setCapability:function(capability){var self=this;self.currentRecord=capability;self.mainTpl.overwrite(self.templatePanel.body,capability);self.notesPanel.getForm().setValues(capability)},currentRecord:undefined,updateCapability:function(){var self=this,form=self.notesPanel.getForm(),values=form.getFieldValues(),capability=Ext.apply(self.currentRecord.$capability,{notes:values.notes});self.mediator().updateCapability(capability,function(){self.mediator().showMessage("Capability saved",self.mediator().describeCapability(self.currentRecord));self.mediator().refresh()},function(response,options){self.mediator().handleError(response,options,"Capability could not be saved",form)})}});
NX.define("Nexus.capabilities.CapabilityStore",{extend:"Ext.data.JsonStore",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.siesta"],constructor:function(config){var self=this,ST=Ext.data.SortTypes;config=config||{};Ext.apply(config,{url:Nexus.siesta.basePath+"/capabilities",id:"capability.id",fields:[{name:"id",mapping:"capability.id"},{name:"description",sortType:ST.asUCString},{name:"notes",mapping:"capability.notes",sortType:ST.asUCString},{name:"enabled",mapping:"capability.enabled"},{name:"active"},{name:"error"},{name:"typeName"},{name:"typeId",mapping:"capability.typeId"},{name:"stateDescription"},{name:"status"},{name:"properties",mapping:"capability.properties"},{name:"$capability",mapping:"capability"},{name:"$tags",convert:function(newValue,record){return self.convertTags(record.tags)}}],sortInfo:{field:"typeName",direction:"ASC"},listeners:{load:{fn:function(){self.tagKeys=self.calculateTagKeys();this.logDebug("Loaded "+self.getCount()+" capabilities")},scope:self}}});self.constructor.superclass.constructor.call(self,config)},urlOf:function(id){return this.url+"/"+id},calculateTagKeys:function(){var self=this,allTagKeys=[];self.each(function(record){if(record.data.$tags){for(var key in record.data.$tags){if(allTagKeys.indexOf(key)<0){allTagKeys.push(key)}}}});return allTagKeys.sort()},convertTags:function(recordTags){var tags={};if(recordTags){Ext.each(recordTags,function(tag){tags[tag.key]=tag.value});return tags}},sameTagKeysAs:function(another){return JSON.stringify(this.tagKeys)===JSON.stringify(another)}});
NX.define("Nexus.capabilities.CapabilityAbout",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin","Nexus.capabilities.CapabilitiesMediatorMixin"],initComponent:function(){var self=this;Ext.apply(self,{cls:"nx-capabilities-CapabilityAbout",title:"About",autoScroll:true,html:""});self.constructor.superclass.initComponent.apply(self,arguments)},setCapability:function(capability){var self=this,about="",capabilityType=self.mediator().capabilityTypeStore.getTypeById(capability.typeId);if(capabilityType){about=capabilityType.about}self.html=about;if(self.body){self.body.update(about)}}});
NX.define("Nexus.masterdetail.MasterDetail",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],master:undefined,detail:undefined,emptySelection:undefined,constructor:function(master,detail,emptySelection){var self=this;NX.assert(master,"Missing master");NX.assert(detail,"Missing detail");NX.assert(emptySelection,"Missing emptySelection");self.master=master;self.detail=detail;self.emptySelection=emptySelection;self.constructor.superclass.constructor.apply(self,arguments)},initComponent:function(){var self=this;self.detailPanel=NX.create("Ext.Panel",{region:"south",minHeight:25,split:true,autoDestroy:false,layout:"card",defaults:{border:false},items:[self.emptySelection,self.detail],activeItem:0,listeners:{afterrender:{single:true,fn:function(){self.detailPanel.setHeight(self.getHeight()*0.6)}}}});Ext.apply(self,{cls:"nx-masterdetail-MasterDetail",layout:"border",border:false,items:[self.master,self.detailPanel]});self.master.getSelectionModel().on("selectionchange",self.selectionChanged,self);self.constructor.superclass.initComponent.apply(self,arguments)},selectionChanged:function(sm){var self=this,cardLayout=self.detailPanel.getLayout(),selections=sm.getSelections();if(selections.length===0){cardLayout.setActiveItem(0)}else{cardLayout.setActiveItem(1);self.detail.updateRecord(selections[0].data)}}});
NX.define("Nexus.masterdetail.EmptySelection",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],initComponent:function(){var self=this,text=self.emptyText;if(!text){text="Please select a "+self.entityType+" or create a new capability"}Ext.apply(self,{cls:"nx-masterdetail-EmptySelection",title:"Empty Selection",iconCls:self.iconCls,html:'<span class="nx-masterdetail-EmptySelection-text">'+text+"</span>"});self.constructor.superclass.initComponent.apply(self,arguments)}});
define("nexus-capabilities-plugin-boot",["Nexus/capabilities/CapabilitiesView"],function(){NX.log.debug("Main nexus-capabilities-plugin modules loaded")});
