/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*
 * Use anonymous closure to augment the current class behaviour
 */
define('Sonatype/repoServer/NugetRepositoryEditContribution', function() {

  (function() {
    var originalHandler = Sonatype.repoServer.VirtualRepositoryEditor.prototype.afterProviderSelectHandler;

    Ext.override(Sonatype.repoServer.VirtualRepositoryEditor, {
      afterProviderSelectHandler : function(combo, rec, index) {

        // first invoke the original behaviour
        originalHandler.apply(this, arguments);

        // virtual NuGet can be applied on top of any non-virtual, non-NuGet repository
        if (rec.data.provider == 'nuget-shadow') {
          this.form.findField('shadowOf').store.filterBy(function fn(rec, id) {
              return rec.data.repoType != 'virtual' && rec.data.format != 'nuget';
            });}
      }
    });

    Sonatype.Events.addListener('repositoryViewInit', function(cardPanel, rec) {
      if (rec.data.format == 'nuget')
      {
        var browserPanel = cardPanel.find('name', 'browseremote');
        if (browserPanel.length > 0 && browserPanel[0])
        {
          cardPanel.tabPanel.remove(browserPanel[0]);
        }
        var mirrorsPanel = cardPanel.find('name', 'mirrors');
        if (mirrorsPanel.length > 0 && mirrorsPanel[0])
        {
          cardPanel.tabPanel.remove(mirrorsPanel[0]);
        }
      }
    }, { delay:100 });

  })();
});

