/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
define('Sonatype/repoServer/NugetGalleryPanel', function() {

  Sonatype.repoServer.NugetGalleryPanel = function(config) {
    var config = config || {};
    var defaultConfig = {};
    Ext.apply(this, config, defaultConfig);

    var items = [{
        xtype : 'textfield',
        fieldLabel : 'Package Source',
        helpText : 'You can register this source with the following command:<p/><tt>nuget sources add -name <i>NAME</i> -source <i>URL</i></tt>',
        name : 'sourceField',
        width : 400,
        listeners : {
          render : function(component) {
            component.getEl().on('click', function() {
              component.selectText();
            })
          }
        },
        readOnly : true
      }];

    if (config.apikey) {
      items = items.concat([{
          xtype : 'textfield',
          fieldLabel : 'Personal API Key',
          helpText : 'You can register this key with the following command:<p/><tt>nuget setapikey <i>KEY</i> -source <i>NAME</i></tt>',
          name : 'apikeyField',
          width : 400,
          listeners : {
            render : function(component) {
              component.getEl().on('click', function() {
                component.selectText();
              })
            }
          },
          readOnly : true
        },{
          xtype : 'panel',
          layout : 'column',
          buttonAlign : 'left',
          items : [{}],
          buttons : [{
            xtype : 'button',
            id : 'view-apikey-button',
            text : 'View API Key',
            handler : this.viewApiKey,
            scope : this
          },{
            xtype : 'button',
            id : 'reset-apikey-button',
            text : 'Reset API Key',
            handler : this.resetApiKey,
            scope : this
          }]
        }]);}

    Sonatype.repoServer.NugetGalleryPanel.superclass.constructor.call(this, {
          uri : this.payload.data.resourceURI,
          readOnly : true,
          dataModifiers : {
            load : {},
            save : {}
          },
          labelWidth: 100,
          items : items
        });
  };

  Ext.extend(Sonatype.repoServer.NugetGalleryPanel, Sonatype.ext.FormPanel, {
        loadData : function() {
          // short-circuit load since we have all the data we need at the moment
          var sourceField = this.find('name', 'sourceField')[0];
          sourceField.setRawValue(Sonatype.config.host + Sonatype.config.servicePath + '/nuget/' + this.payload.data.id + '/');
          var apikeyField = this.find('name', 'apikeyField')[0];
          if (apikeyField) {
            apikeyField.setRawValue(String.leftPad('',36,'\u25cf')); /* 36 x {black-circle} */
          }
        },
        viewApiKey : function() {
          Ext.Ajax.request({
            url: Sonatype.config.servicePath + '/apikeys/nuget',
            callback: function(options, isSuccess, response) {
              var apikeyField = this.find('name', 'apikeyField')[0];
              if (!isSuccess) {
                this.connectionError(response, 'The server failed to return the API Key.');
              } else {
                apikeyField.setRawValue(response.responseText);
              }},
            scope: this,
            method: 'GET'
          });
        },
        resetApiKey : function() {
          Sonatype.MessageBox.show({
            title : 'Reset NuGet API Key?',
            msg : 'Creating a new key will invalidate the existing one<br/><br/>Are you sure?',
            buttons : Sonatype.MessageBox.YESNO,
            icon : Sonatype.MessageBox.WARNING,
            fn : function(button) {
              if (button == 'yes' || button == 'ok') {
                Ext.Ajax.request({
                  url: Sonatype.config.servicePath + '/apikeys/nuget',
                  callback: function(options, isSuccess, response) {
                    var apikeyField = this.find('name', 'apikeyField')[0];
                    if (!isSuccess) {
                      this.connectionError(response, 'The server failed to send a new API Key.');
                    } else {
                    apikeyField.setRawValue(response.responseText);
                    }},
                  scope: this,
                  method: 'POST'
                });
              }},
            animEl : 'mb3',
            scope : this
          });
        },
        connectionError : function(response, message) {
          var r = response.responseText;
          var n1 = r.toLowerCase().indexOf('<error>') + 7;
          var n2 = r.toLowerCase().indexOf('</error>');
          if (n2 > n1) {
            message = r.substring(n1, n2); // more specific message
          }
          Sonatype.utils.connectionError(response, message);
        }
      });

  Sonatype.Events.addListener('repositoryViewInit', function(cardPanel, rec) {
        var sp = Sonatype.lib.Permissions;
        if (rec.data.format == 'nuget' && rec.data.resourceURI &&
            sp.checkPermission('nexus:status', sp.READ)) {
          cardPanel.add(new Sonatype.repoServer.NugetGalleryPanel({
            tabTitle : 'NuGet',
            name : 'gallery',
            payload : rec,
            apikey : sp.checkPermission('apikey:access', sp.ALL)
          }));
        }
      });
});
