/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, Sonatype*/
define('Sonatype/repoServer/outreach', function() {

  (function () {

  Sonatype.config.repos.urls.outreach = {
    welcome : Sonatype.config.servicePath + "/outreach/welcome/",
    links : Sonatype.config.servicePath + "/outreach/links",
    status : Sonatype.config.servicePath + "/outreach/status"
  };

  // we try to be last, so we add the iframe only in post init
  Sonatype.Events.addListener('welcomeTabInit', function(repoServer, welcomeTabConfig) {
    var items = [
      {
        layout : 'anchor',
        border : false,
        items : [
          {
            anchor : '100%',
            items : welcomeTabConfig.items,
            border : false
          },
          {
            xtype : 'panel',
            anchor : '100%',
            height : 700,
            border : false,
            frame : false,
            id : 'welcome-outreach',
            html : '<iframe id="welcome-outreach-iframe" frameborder="0" height="100%" width="100%"></iframe> ',
            hidden : true
          }
        ]
      }
    ];

    welcomeTabConfig.items = items;
  });

  var sp = Sonatype.lib.Permissions;

  Sonatype.Events.addListener('welcomeTabRender', function() {
    var statusEnabled = sp.checkPermission('nexus:status', sp.READ);
    if (!statusEnabled) {
      // probably anonymous access disabled
      return true;
    }

    // test welcome page, if 400 -> iframe stays hidden.
    // this is asynchronous, so it will not interfere with displaying the UI
    Ext.Ajax.request({
            url : Sonatype.config.repos.urls.outreach.status,
            success : function() {
              var params = '',
                  versionSegments = Sonatype.utils.version.split('.');

              params += '?version=' + Sonatype.utils.version;
              params += '&versionMm=' + versionSegments[0] + '.' + versionSegments[1];
              params += '&edition=' + Sonatype.utils.editionShort;
              if (Sonatype.user.curr.isLoggedIn) {
                params += '&usertype=' + (sp.checkPermission('nexus:*', sp.UPDATE) ? 'admin' : 'normal');
              }
              else {
                params += '&usertype=anonymous';
              }

              Ext.get('welcome-outreach-iframe').dom.src = Sonatype.config.repos.urls.outreach.welcome + params;
              Ext.getCmp('welcome-outreach').setVisible(true);
            },
            suppressStatus : 400
          }
    );
  });

  Sonatype.Events.addListener('nexusNavigationPostInit', function() {
    var statusEnabled = sp.checkPermission('nexus:status', sp.READ);
    if (!statusEnabled) {
      // probably anonymous access disabled
      return true;
    }

    Ext.Ajax.request({
      url : Sonatype.config.repos.urls.outreach.links,
      suppressStatus : [ 400, 404],
      success : function(response, options) {
        var
              i, link,
              json = Ext.decode(response.responseText),
              helpSection = Ext.getCmp('st-nexus-docs');

        // if help section is not visible -> license expired, don't add links
        if (json.help && helpSection) {
          for (i = 0; i < json.help.length; i=i+1) {
            link = json.help[i];
            if ( !link ) {
              // IE9 bug, seems to return wrong length for the array
              return;
            }
            helpSection.add({
              style : link.style,
              title : link.title,
              href : link.url
            });
          }
          helpSection.doLayout();
        }
      }
    });
  });

  })();
});
