NX.define("Nexus.analytics.view.Settings",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],xtype:"nx-analytics-view-settings",title:"Settings",id:"nx-analytics-view-settings",cls:"nx-analytics-view-settings",border:false,initComponent:function(){var me=this;Ext.apply(me,{items:[{xtype:"form",border:false,style:{padding:"10px"},defaults:{hideLabel:true,inputValue:"true"},items:[{xtype:"container",cls:"nx-analytics-view-settings-description",html:'<p>The analytics feature collects non-sensitive information about how your organization is using Nexus. It is useful to you from a compatibility perspective, since it gathers answers to questions such as what features are most important, where are users having difficulty and what integrations/APIs are actively in use. This data is available to you and allows you to understand your usage of Nexus better. Provided to Sonatype it enables us to tailor the ongoing development of the product.</p><br/><h2>Event Collection</h2><br/><p>The collected information is limited to the use of the Nexus user interface and the Nexus REST API -- i.e. the primary interaction points between your environment and Nexus. Only the user interface navigation flows and REST endpoints being called are recorded. None of the request specific data (e.g. credentials or otherwise sensitive information) is ever captured.</p><br/><p>Event collection and submission are controlled separately.  When collection is enabled, a summary of the data collected is shown on the "Events" tab.</p><br/><h2>Event Submission</h2><br/><p>Analytics event data can be submitted either automatically or manually.<br/><br/>"Export" generates a ZIP file that can be inspected prior to any information being sent to the Nexus analytics service. <br/>"Submit" generates a ZIP file and then immediately uploads it to the Nexus analytics service.</p><br/>'},{xtype:"checkbox",name:"collection",boxLabel:"Enable analytics event collection"},{xtype:"checkbox",name:"autosubmit",boxLabel:"Enable automatic analytics event submission"}],buttonAlign:"left",buttons:[{xtype:"button",text:"Save",id:"nx-analytics-view-settings-button-save",formBind:true}]}]});me.constructor.superclass.initComponent.apply(me,arguments)},getValues:function(){return this.down("form").getForm().getValues()},setValues:function(values){this.down("form").getForm().setValues(values)}});
NX.define("Nexus.analytics.view.Panel",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.analytics.Icons","Nexus.analytics.view.Settings","Nexus.analytics.view.Events"],xtype:"nx-analytics-view-panel",title:"Analytics",cls:"nx-analytics-view-panel",border:false,layout:{type:"vbox",align:"stretch"},initComponent:function(){var me=this,icons=Nexus.analytics.Icons;Ext.apply(me,{items:[{xtype:"panel",cls:"nx-analytics-view-panel-description",border:false,html:icons.get("analytics").variant("x32").img+"<div>Analytics helps Sonatype make Nexus better by capturing key anonymous usage details and metrics.</div>",height:60,flex:0},{xtype:"tabpanel",flex:1,border:false,plain:true,layoutOnTabChange:true,items:[{xtype:"nx-analytics-view-settings"},{xtype:"nx-analytics-view-events"}],activeTab:0,listeners:{afterrender:function(tabpanel){var tab=me.down("nx-analytics-view-events");tabpanel.hideTabStripItem(tab)}}}]});me.constructor.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.analytics.view.Events",{extend:"Ext.Panel",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.analytics.Icons","Nexus.analytics.store.Events"],xtype:"nx-analytics-view-events",title:"Events",id:"nx-analytics-view-events",cls:"nx-analytics-view-events",border:false,layout:"fit",initComponent:function(){var me=this,icons=Nexus.analytics.Icons,store=NX.create("Nexus.analytics.store.Events"),expander=NX.create("Ext.ux.grid.RowExpander",{tpl:new Ext.XTemplate('<table style="padding: 5px;">','<tpl for="this.attributes(values)">',"<tr>",'<td style="padding-right: 5px;"><b>{name}</b></td>',"<td>{value}</td>","</tr>","</tpl>","</table>",{compiled:true,attributes:function(values){var result=[];Ext.iterate(values.attributes,function(name,value){result.push({name:name,value:value})});return result}})});me.grid=NX.create("Ext.grid.GridPanel",{border:false,autoScroll:true,loadMask:{msg:"Loading...",msgCls:"loading-indicator"},store:store,viewConfig:{emptyText:"No analytics events",deferEmptyText:false},stripeRows:true,autoExpandColumn:"attributes",colModel:NX.create("Ext.grid.ColumnModel",{defaults:{sortable:true},columns:[expander,{width:30,resizable:false,sortable:false,fixed:true,hideable:false,menuDisabled:true,renderer:function(value,metaData,record){return icons.forType(record.get("type")).img}},{id:"type",header:"Type",dataIndex:"type"},{id:"timestamp",header:"Timestamp",dataIndex:"timestamp",width:100},{id:"sequence",header:"Sequence",dataIndex:"sequence",width:80},{id:"userId",header:"User",dataIndex:"userId"},{id:"attributes",header:"Attributes",dataIndex:"attributes",renderer:function(value,metaData,record){var text="";Ext.iterate(value,function(name,value){if(text!==""){text+=", "}text+=name+"="+value});return text}}]}),plugins:[expander],bbar:NX.create("Ext.PagingToolbar",{pageSize:Nexus.analytics.store.Events.PAGE_SIZE,store:store,displayInfo:true,displayMsg:"Displaying events {0} - {1} of {2}",emptyMsg:"No events to display"})});Ext.apply(me,{items:[me.grid],tbar:[{xtype:"button",id:"nx-analytics-view-events-button-refresh",text:"Refresh",tooltip:"Refresh event data",iconCls:icons.get("refresh").cls},{xtype:"button",id:"nx-analytics-view-events-button-clear",text:"Clear",tooltip:"Clear all event data",iconCls:icons.get("clear").cls},{xtype:"button",id:"nx-analytics-view-events-button-export",text:"Export",tooltip:"Export and download event data",iconCls:icons.get("_export").cls},"-",{xtype:"button",id:"nx-analytics-view-events-button-submit",text:"Submit",tooltip:"Submit event data to Sonatype",iconCls:icons.get("submit").cls},"->",{xtype:"nx-grid-filter-box",filteredGrid:me.grid}]});me.constructor.superclass.initComponent.apply(me,arguments)},getGrid:function(){return this.grid}});
NX.define("Nexus.analytics.view.EventsZipCreated",{extend:"Nexus.wonderland.view.FileCreated",xtype:"nx-analytics-view-eventszip-created",requires:["Nexus.analytics.Icons"],fileType:"Events ZIP",downloadButtonId:"nx-analytics-button-eventszip-download",initComponent:function(){var me=this;me.fileIcon=Nexus.analytics.Icons.get("zip").variant("x32");Nexus.analytics.view.EventsZipCreated.superclass.initComponent.apply(me,arguments)}});
NX.define("Nexus.analytics.Icons",{extend:"Nexus.util.IconContainer",singleton:true,constructor:function(){var me=this;function iconConfig(fileName,variants){var config={};if(variants===undefined){variants=["x32","x16"]}Ext.each(variants,function(variant){config[variant]=variant+"/"+fileName});return config}me.constructor.superclass.constructor.call(me,{stylePrefix:"nx-analytics-icon-",icons:{arrow_refresh:"arrow_refresh.png",action_log:iconConfig("action_log.png"),_delete:iconConfig("delete.png"),download:iconConfig("download.png"),external:iconConfig("external.png"),transmit:iconConfig("transmit.png"),file_extension_zip:iconConfig("file_extension_zip.png"),refresh:"@arrow_refresh",analytics:"@action_log",clear:"@_delete",_export:"@download",submit:"@external",type_REST:"@transmit",zip:"@file_extension_zip"}})},forType:function(name){return this.get("type_"+name)}});
NX.define("Nexus.analytics.store.Events",{extend:"Ext.data.Store",mixins:["Nexus.LogAwareMixin"],requires:["Nexus.siesta"],statics:{PAGE_SIZE:250},constructor:function(){var me=this;Ext.apply(me,{storeId:"nx-analytics-store-events",autoDestroy:true,restful:true,proxy:NX.create("Ext.data.HttpProxy",{url:Nexus.siesta.basePath+"/analytics/events"}),reader:NX.create("Ext.data.JsonReader",{root:"events",totalProperty:"total",fields:["type","timestamp","sequence","userId","sessionId","attributes"]})});me.constructor.superclass.constructor.call(me)}});
NX.define("Nexus.analytics.controller.Analytics",{extend:"Nexus.controller.Controller",requires:["Nexus.siesta","Nexus.analytics.Icons","Nexus.analytics.view.EventsZipCreated","Nexus.analytics.view.Panel","Nexus.util.DownloadHelper","Nexus.wonderland.AuthenticateButton"],init:function(){var me=this;me.control({"#nx-analytics-view-settings":{activate:me.loadSettings},"#nx-analytics-view-settings-button-save":{click:me.saveSettings},"#nx-analytics-view-events":{activate:me.loadEvents},"#nx-analytics-view-events-button-refresh":{click:me.refreshEvents},"#nx-analytics-view-events-button-clear":{click:me.clearEvents},"#nx-analytics-view-events-button-export":{click:me.exportEvents},"#nx-analytics-view-events-button-submit":{click:me.submitEvents},"#nx-analytics-button-eventszip-download":{authenticated:me.downloadEventsZip},"#nx-analytics-button-eventszip-submit":{authenticated:me.submitEventsZip}});me.addNavigationMenu()},addNavigationMenu:function(){Sonatype.Events.on("nexusNavigationInit",function(panel){var sp=Sonatype.lib.Permissions;panel.add({enabled:sp.checkPermission("nexus:analytics",sp.READ),sectionId:"st-nexus-config",title:"Analytics",tabId:"analytics",tabCode:function(){return Ext.create({xtype:"nx-analytics-view-panel",id:"analytics"})}})})},showMessage:function(message){Nexus.messages.show("Analytics",message)},loadSettings:function(){var me=this;me.logDebug("Loading settings");Ext.Ajax.request({url:Nexus.siesta.basePath+"/analytics/settings",method:"GET",scope:me,success:function(response,opts){me.logDebug("Settings: "+response.responseText);var values=Ext.decode(response.responseText);Ext.getCmp("nx-analytics-view-settings").setValues(values);var tabpanel=Ext.getCmp("analytics").down("tabpanel");var eventsview=Ext.getCmp("nx-analytics-view-events");if(values.collection===true){tabpanel.unhideTabStripItem(eventsview)}else{tabpanel.hideTabStripItem(eventsview)}}})},saveSettings:function(button){var me=this,values=Ext.getCmp("nx-analytics-view-settings").getValues();me.logDebug("Saving settings: "+Ext.util.JSON.encode(values));Ext.Ajax.request({url:Nexus.siesta.basePath+"/analytics/settings",method:"PUT",jsonData:values,scope:me,success:function(){me.showMessage("Settings saved");me.loadSettings()}})},loadEvents:function(panel){var store=panel.getGrid().getStore();store.load({params:{start:0,limit:Nexus.analytics.store.Events.PAGE_SIZE}})},refreshEvents:function(button){var me=this,panel=button.up("nx-analytics-view-events");me.loadEvents(panel)},clearEvents:function(button){var me=this,icons=Nexus.analytics.Icons,store=button.up("nx-analytics-view-events").getGrid().getStore();Ext.Msg.show({title:"Clear events",msg:"Clear analytics event data?",buttons:Ext.Msg.OKCANCEL,icon:icons.get("clear").variant("x32").cls,fn:function(btn){if(btn==="ok"){Ext.Ajax.request({url:Nexus.siesta.basePath+"/analytics/events",method:"DELETE",suppressStatus:true,success:function(){me.showMessage("Event data has been cleared");store.load()},failure:function(response){me.showMessage("Failed to clear event data: "+me.parseExceptionMessage(response))}})}}})},exportEvents:function(button){var me=this,icons=Nexus.analytics.Icons,viewport=button.up("viewport"),mask=NX.create("Ext.LoadMask",viewport.getEl(),{msg:"Exporting event data..."});Ext.Msg.show({title:"Export events",msg:"Export and download analytics event data?<br/>No data will be sent to Sonatype.",buttons:Ext.Msg.OKCANCEL,icon:icons.get("_export").variant("x32").cls,fn:function(btn){if(btn==="ok"){mask.show();Ext.Ajax.request({url:Nexus.siesta.basePath+"/analytics/events/export",method:"POST",suppressStatus:true,scope:me,callback:function(){mask.hide()},success:function(response){var obj=Ext.decode(response.responseText),win=NX.create("Nexus.analytics.view.EventsZipCreated");win.setValues(obj);win.show()},failure:function(response){me.showMessage("Failed to export event data: "+me.parseExceptionMessage(response))}})}}})},submitEvents:function(button){var me=this,icons=Nexus.analytics.Icons,authenticateButton=Ext.ComponentMgr.get("nx-analytics-button-eventszip-submit");if(authenticateButton){authenticateButton.destroy()}Ext.Msg.show({title:"Submit events",msg:"Submit analytics event data to Sonatype?",buttons:Ext.Msg.OKCANCEL,icon:icons.get("submit").variant("x32").cls,fn:function(btn){if(btn==="ok"){NX.create("Nexus.wonderland.AuthenticateButton",{id:"nx-analytics-button-eventszip-submit"}).showWindow()}}})},downloadEventsZip:function(button,authTicket){var win=button.up("nx-analytics-view-eventszip-created"),fileName=win.getValues().name;authTicket=Sonatype.utils.base64.encode(authTicket);if(Nexus.util.DownloadHelper.downloadUrl(Nexus.siesta.basePath+"/wonderland/download/"+fileName+"?t="+authTicket)){win.close()}},submitEventsZip:function(button,authTicket){var me=this;authTicket=Sonatype.utils.base64.encode(authTicket);Ext.Ajax.request({url:Nexus.siesta.basePath+"/analytics/events/submit?t="+authTicket,method:"POST",suppressStatus:true,success:function(){me.showMessage("Event data submission in progress")},failure:function(response){me.showMessage("Failed to submit event data: "+me.parseExceptionMessage(response))}})}});
define("nexus-analytics-plugin-boot",["Nexus/analytics/controller/Analytics"],function(){NX.log.debug("Module loaded: nexus-analytics-plugin-boot");NX.create("Nexus.analytics.controller.Analytics").init()});
