/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/**
 * Settings panel.
 *
 * @since 2.8
 */
NX.define('Nexus.analytics.view.Settings', {
  extend: 'Ext.Panel',

  mixins: [
    'Nexus.LogAwareMixin'
  ],

  xtype: 'nx-analytics-view-settings',
  title: 'Settings',
  id: 'nx-analytics-view-settings',
  cls: 'nx-analytics-view-settings',

  border: false,
  //layout: 'fit',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      items: [
        {
          xtype: 'form',
          border: false,
          style: {
            padding: '10px'
          },

          defaults: {
            hideLabel: true,
            inputValue: 'true' // use 'true' instead of 'on'
          },
          items: [
            {
              xtype: 'container',
              cls: 'nx-analytics-view-settings-description',
              html: '<p>The analytics feature collects non-sensitive information about how your organization is using Nexus. ' +
                  'It is useful to you from a compatibility perspective, since it gathers answers to questions such as what features are most important, ' +
                  'where are users having difficulty and what integrations/APIs are actively in use. This data is available to you and allows you to understand your usage of Nexus better. ' +
                  'Provided to Sonatype it enables us to tailor the ongoing development of the product.</p>' +
                  '<br/>' +
                  '<h2>Event Collection</h2>' +
                  '<br/>' +
                  '<p>The collected information is limited to the use of the Nexus user interface and the Nexus REST API -- i.e. the primary interaction points between your environment and Nexus. ' +
                  'Only the user interface navigation flows and REST endpoints being called are recorded. None of the request specific data ' +
                  '(e.g. credentials or otherwise sensitive information) is ever captured.</p>' +
                  '<br/>' +
                  '<p>Event collection and submission are controlled separately.  When collection is enabled, a summary of the data collected is shown on the "Events" tab.</p>' +
                  '<br/>' +
                  '<h2>Event Submission</h2>' +
                  '<br/>' +
                  '<p>Analytics event data can be submitted either automatically or manually.' +
                  '<br/>' +
                  '<br/>' +
                  '"Export" generates a ZIP file that can be inspected prior to any information being sent to the Nexus analytics service. ' +
                  '<br/>' +
                  '"Submit" generates a ZIP file and then immediately uploads it to the Nexus analytics service.</p>' +
                  '<br/>'
            },
            {
              xtype: 'checkbox',
              name: 'collection',
              boxLabel: 'Enable analytics event collection'
            },
            {
              xtype: 'checkbox',
              name: 'autosubmit',
              boxLabel: 'Enable automatic analytics event submission'
            }
          ],

          buttonAlign: 'left',
          buttons: [
            {
              xtype: 'button',
              text: 'Save',
              id: 'nx-analytics-view-settings-button-save',
              formBind: true
            }
          ]
        }
      ]
    });

    me.constructor.superclass.initComponent.apply(me, arguments);
  },

  /**
   * Get form values.
   *
   * @public
   */
  getValues: function () {
    return this.down('form').getForm().getValues();
  },

  /**
   * Set form values.
   *
   * @public
   */
  setValues: function (values) {
    this.down('form').getForm().setValues(values);
  }
});