/*
 * Copyright (c) 2008-2015 Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global NX, Ext, Nexus, Sonatype*/

/**
 * Events ZIP created window.
 *
 * @since 2.8
 */
NX.define('Nexus.analytics.view.EventsZipCreated', {
  extend: 'Nexus.wonderland.view.FileCreated',
  xtype: 'nx-analytics-view-eventszip-created',

  requires: [
    'Nexus.analytics.Icons'
  ],

  fileType: 'Events ZIP',
  downloadButtonId: 'nx-analytics-button-eventszip-download',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.fileIcon = Nexus.analytics.Icons.get('zip').variant('x32');

    Nexus.analytics.view.EventsZipCreated.superclass.initComponent.apply(me, arguments);
  }

});