/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.web.guice;

import com.google.common.base.Throwables;
import com.google.inject.Key;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.guice.web.ShiroWebModule;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.nexus.NexusWebSecurityManager;
import org.apache.shiro.nexus5727.FixedDefaultWebSessionManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.security.authentication.FirstSuccessfulModularRealmAuthenticator;
import org.sonatype.security.authorization.ExceptionCatchingModularRealmAuthorizer;
import org.sonatype.security.web.ProtectedPathManager;

public class SecurityWebModule
extends ShiroWebModule {
    private final boolean useFilterChainManager;

    public SecurityWebModule(ServletContext servletContext, boolean useFilterChainManager) {
        super(servletContext);
        this.useFilterChainManager = useFilterChainManager;
    }

    protected void configureShiroWeb() {
        this.bindRealm().to(EmptyRealm.class);
        this.bind(SessionDAO.class).to(EnterpriseCacheSessionDAO.class).asEagerSingleton();
        this.bind(Authenticator.class).to(FirstSuccessfulModularRealmAuthenticator.class).in(Singleton.class);
        this.bind(Authorizer.class).to(ExceptionCatchingModularRealmAuthorizer.class).in(Singleton.class);
        this.bind(ProtectedPathManager.class).to(SimpleProtectedPathManager.class).in(Singleton.class);
        if (this.useFilterChainManager) {
            this.bind(FilterChainResolver.class).toConstructor(SecurityWebModule.ctor(PathMatchingFilterChainResolver.class, new Class[0])).asEagerSingleton();
            this.bind(FilterChainManager.class).toProvider(FilterChainManagerProvider.class).in(Singleton.class);
        }
        this.expose(ProtectedPathManager.class);
        this.expose(FilterChainResolver.class);
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        this.bind(NexusWebSecurityManager.class).asEagerSingleton();
        this.bind(RealmSecurityManager.class).to(NexusWebSecurityManager.class);
        bind.to(NexusWebSecurityManager.class);
        this.expose(RealmSecurityManager.class);
        this.expose(WebSecurityManager.class);
    }

    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(FixedDefaultWebSessionManager.class).asEagerSingleton();
        this.bind(FixedDefaultWebSessionManager.class);
    }

    protected void bindNamedFilter(String name, Filter filter) {
        Key key = Key.get(Filter.class, (Annotation)Names.named((String)name));
        this.bind(key).toInstance((Object)filter);
        this.expose(key);
    }

    private static final <T> Constructor<T> ctor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static final class SimpleProtectedPathManager
    implements ProtectedPathManager {
        private final FilterChainManager filterChainManager;

        @Inject
        private SimpleProtectedPathManager(FilterChainManager filterChainManager) {
            this.filterChainManager = filterChainManager;
        }

        @Override
        public void addProtectedResource(String pathPattern, String filterExpression) {
            this.filterChainManager.createChain(pathPattern, filterExpression);
        }
    }

    private static final class SimpleFilterConfig
    implements FilterConfig {
        private final String filterName;
        private final ServletContext servletContext;

        SimpleFilterConfig(String filterName, ServletContext servletContext) {
            this.filterName = filterName;
            this.servletContext = servletContext;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String name) {
            return this.servletContext.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this.servletContext.getInitParameterNames();
        }
    }

    private static final class FilterChainManagerProvider
    implements Provider<FilterChainManager>,
    Mediator<Named, Filter, FilterChainManager> {
        private final FilterConfig filterConfig;
        private final BeanLocator beanLocator;

        @Inject
        private FilterChainManagerProvider(@Named(value="SHIRO") ServletContext servletContext, BeanLocator beanLocator) {
            this.filterConfig = new SimpleFilterConfig("SHIRO", servletContext);
            this.beanLocator = beanLocator;
        }

        public FilterChainManager get() {
            DefaultFilterChainManager filterChainManager = new DefaultFilterChainManager(this.filterConfig);
            this.beanLocator.watch(Key.get(Filter.class, Named.class), (Mediator)this, (Object)filterChainManager);
            return filterChainManager;
        }

        public void add(BeanEntry<Named, Filter> entry, FilterChainManager manager) {
            manager.addFilter(((Named)entry.getKey()).value(), (Filter)entry.getValue(), true);
        }

        public void remove(BeanEntry<Named, Filter> filter, FilterChainManager manager) {
        }
    }

    @Singleton
    private static final class EmptyRealm
    implements Realm {
        private EmptyRealm() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public boolean supports(AuthenticationToken token) {
            return false;
        }

        public AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) {
            return null;
        }
    }
}

