/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.web;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.sonatype.security.web.FilterChainManagerAware;
import org.sonatype.security.web.ProtectedPathManager;

@Singleton
@Typed(value={ProtectedPathManager.class})
@Named(value="default")
public class DefaultProtectedPathManager
implements ProtectedPathManager,
FilterChainManagerAware {
    private FilterChainManager filterChainManager;
    protected Map<String, String> pseudoChains = new LinkedHashMap<String, String>();

    @Inject
    public DefaultProtectedPathManager(@Nullable FilterChainResolver filterChainResolver) {
        if (filterChainResolver instanceof PathMatchingFilterChainResolver) {
            this.setFilterChainManager(((PathMatchingFilterChainResolver)filterChainResolver).getFilterChainManager());
        }
    }

    public DefaultProtectedPathManager() {
    }

    @Override
    public void addProtectedResource(String pathPattern, String filterExpression) {
        if (this.filterChainManager != null) {
            this.filterChainManager.createChain(pathPattern, filterExpression);
        } else {
            this.pseudoChains.put(pathPattern, filterExpression);
        }
    }

    @Override
    public void setFilterChainManager(FilterChainManager filterChainManager) {
        if (filterChainManager != null && filterChainManager != this.filterChainManager) {
            this.filterChainManager = filterChainManager;
            for (Map.Entry<String, String> entry : this.pseudoChains.entrySet()) {
                this.filterChainManager.createChain(entry.getKey(), entry.getValue());
            }
        }
    }
}

