/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement;

import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.RoleMappingUserManager;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={UserManagerFacade.class})
@Named(value="default")
public class UserManagerFacade
extends ComponentSupport {
    private final Map<String, UserManager> userManagers;

    @Inject
    public UserManagerFacade(Map<String, UserManager> userManagers) {
        this.userManagers = userManagers;
    }

    public User getUser(String userId, String source) throws UserNotFoundException, NoSuchUserManagerException {
        UserManager userManager = this.getUserManager(source);
        User user = userManager.getUser(userId);
        if (user == null) {
            throw new UserNotFoundException(userId);
        }
        this.addOtherRolesToUser(user);
        return user;
    }

    public Map<String, UserManager> getUserManagers() {
        return this.userManagers;
    }

    public UserManager getUserManager(String sourceId) throws NoSuchUserManagerException {
        if (!this.userManagers.containsKey(sourceId)) {
            throw new NoSuchUserManagerException("UserManager with source: '" + sourceId + "' could not be found.");
        }
        return this.userManagers.get(sourceId);
    }

    private void addOtherRolesToUser(User user) {
        for (UserManager tmpUserManager : this.userManagers.values()) {
            if (tmpUserManager.getSource().equals(user.getSource()) || !RoleMappingUserManager.class.isInstance(tmpUserManager)) continue;
            try {
                RoleMappingUserManager roleMappingUserManager = (RoleMappingUserManager)tmpUserManager;
                Set<RoleIdentifier> roleIdentifiers = roleMappingUserManager.getUsersRoles(user.getUserId(), user.getSource());
                if (roleIdentifiers == null) continue;
                user.addAllRoles(roleIdentifiers);
            }
            catch (UserNotFoundException e) {
                this.log.debug("User '" + user.getUserId() + "' is not managed by the usermanager: " + tmpUserManager.getSource());
            }
        }
    }
}

