/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class StringDigester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDigest(String alg, String content) throws NoSuchAlgorithmException {
        String result = null;
        try (ByteArrayInputStream fis = new ByteArrayInputStream(content.getBytes("UTF-8"));){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md = MessageDigest.getInstance(alg);
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            result = new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static String getSha1Digest(String content) {
        try {
            return StringDigester.getDigest("SHA1", content);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

