/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement;

import java.util.HashSet;
import java.util.Set;

public class RoleIdentifier {
    private String source;
    private String roleId;

    public RoleIdentifier(String source, String roleId) {
        this.source = source;
        this.roleId = roleId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.roleId == null ? 0 : this.roleId.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleIdentifier other = (RoleIdentifier)obj;
        if (this.roleId == null ? other.roleId != null : !this.roleId.equals(other.roleId)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public static Set<RoleIdentifier> getRoleIdentifiersForSource(String source, Set<RoleIdentifier> roleIdentifiers) {
        HashSet<RoleIdentifier> sourceRoleIdentifiers = new HashSet<RoleIdentifier>();
        if (roleIdentifiers != null) {
            for (RoleIdentifier roleIdentifier : roleIdentifiers) {
                if (!roleIdentifier.getSource().equals(source)) continue;
                sourceRoleIdentifiers.add(roleIdentifier);
            }
        }
        return sourceRoleIdentifiers;
    }

    public String toString() {
        return "source: " + this.source + ", roleId: " + this.roleId;
    }
}

