/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserStatus;

public class DefaultUser
implements User,
Comparable<User> {
    private String userId;
    private String firstName;
    private String lastName;
    private String emailAddress;
    private String source;
    private UserStatus status;
    private boolean readOnly;
    private Set<RoleIdentifier> roleIdentifiers = new HashSet<RoleIdentifier>();

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getName() {
        String name;
        String string = name = this.getFirstName() != null ? this.getFirstName() : "";
        if (StringUtils.isNotEmpty((String)this.getLastName())) {
            name = name + " " + this.getLastName();
        }
        return name;
    }

    @Override
    public void setName(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            String[] nameParts = name.trim().split(" ", 2);
            this.setFirstName(nameParts[0]);
            if (nameParts.length > 1) {
                this.setLastName(nameParts[1]);
            }
        }
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public Set<RoleIdentifier> getRoles() {
        return Collections.unmodifiableSet(this.roleIdentifiers);
    }

    @Override
    public void addRole(RoleIdentifier roleIdentifier) {
        this.roleIdentifiers.add(roleIdentifier);
    }

    @Override
    public boolean removeRole(RoleIdentifier roleIdentifier) {
        return this.roleIdentifiers.remove(roleIdentifier);
    }

    @Override
    public void addAllRoles(Set<RoleIdentifier> roleIdentifiers) {
        this.roleIdentifiers.addAll(roleIdentifiers);
    }

    @Override
    public void setRoles(Set<RoleIdentifier> roles) {
        this.roleIdentifiers = roles;
    }

    @Override
    public UserStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return "UserId: " + this.userId + ", Name: " + this.firstName + " " + this.lastName;
    }

    @Override
    public int compareTo(User o) {
        int before = -1;
        boolean equal = false;
        boolean after = true;
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        if (this.getUserId() == null && o.getUserId() != null) {
            return -1;
        }
        if (this.getUserId() != null && o.getUserId() == null) {
            return 1;
        }
        int result = this.getUserId().compareTo(o.getUserId());
        if (result != 0) {
            return result;
        }
        if (this.getSource() == null) {
            return -1;
        }
        return this.getSource().compareTo(o.getSource());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.source == null ? other.getSource() != null : !this.source.equals(other.getSource())) {
            return false;
        }
        return !(this.userId == null ? other.getUserId() != null : !this.userId.equals(other.getUserId()));
    }
}

