/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement;

import java.util.Random;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.usermanagement.PasswordGenerator;
import org.sonatype.security.usermanagement.StringDigester;

@Singleton
@Typed(value={PasswordGenerator.class})
@Named(value="default")
public class DefaultPasswordGenerator
implements PasswordGenerator {
    private int getRandom(int min, int max) {
        Random random = new Random();
        int total = max - min + 1;
        int next = Math.abs(random.nextInt() % total);
        return min + next;
    }

    @Override
    public String generatePassword(int minChars, int maxChars) {
        int length = this.getRandom(minChars, maxChars);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = i % 2 == 0 ? (byte)this.getRandom(97, 122) : (byte)this.getRandom(48, 57);
        }
        return new String(bytes);
    }

    @Override
    public String hashPassword(String password) {
        return StringDigester.getSha1Digest(password);
    }
}

