/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.usermanagement;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.plexus.util.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserSearchCriteria;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractUserManager
extends ComponentSupport
implements UserManager {
    protected Set<User> filterListInMemeory(Set<User> users, UserSearchCriteria criteria) {
        HashSet<User> result = new HashSet<User>();
        for (User user : users) {
            if (!this.userMatchesCriteria(user, criteria)) continue;
            result.add(user);
        }
        return result;
    }

    protected boolean userMatchesCriteria(User user, UserSearchCriteria criteria) {
        HashSet<String> userRoles = new HashSet<String>();
        if (user.getRoles() != null) {
            for (RoleIdentifier roleIdentifier : user.getRoles()) {
                userRoles.add(roleIdentifier.getRoleId());
            }
        }
        return this.matchesCriteria(user.getUserId(), user.getSource(), userRoles, criteria);
    }

    protected boolean matchesCriteria(String userId, String userSource, Collection<String> usersRoles, UserSearchCriteria criteria) {
        if (StringUtils.isNotEmpty((String)criteria.getUserId()) && !userId.toLowerCase().startsWith(criteria.getUserId().toLowerCase())) {
            return false;
        }
        if (criteria.getSource() != null && !criteria.getSource().equals(userSource)) {
            return false;
        }
        if (criteria.getOneOfRoleIds() != null && !criteria.getOneOfRoleIds().isEmpty()) {
            HashSet<String> userRoles = new HashSet<String>();
            if (usersRoles != null) {
                userRoles.addAll(usersRoles);
            }
            if (CollectionUtils.intersection(criteria.getOneOfRoleIds(), userRoles).isEmpty()) {
                return false;
            }
        }
        return true;
    }
}

