/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class UserIdMdcHelper {
    private static final Logger log = LoggerFactory.getLogger(UserIdMdcHelper.class);
    public static final String KEY = "userId";
    public static final String UNKNOWN = "*UNKNOWN";

    public static boolean isSet() {
        String userId = MDC.get((String)KEY);
        return !Strings.isNullOrEmpty((String)userId) && !UNKNOWN.equals(userId);
    }

    public static void setIfNeeded() {
        if (!UserIdMdcHelper.isSet()) {
            UserIdMdcHelper.set();
        }
    }

    public static void set(Subject subject) {
        Preconditions.checkNotNull((Object)subject);
        String userId = UserIdMdcHelper.userId(subject);
        log.trace("Set: {}", (Object)userId);
        MDC.put((String)KEY, (String)userId);
    }

    @VisibleForTesting
    static String userId(@Nullable Subject subject) {
        Object principal;
        if (subject != null && (principal = subject.getPrincipal()) != null) {
            return principal.toString();
        }
        return UNKNOWN;
    }

    public static void set() {
        Subject subject = SecurityUtils.getSubject();
        if (subject == null) {
            MDC.put((String)KEY, (String)UNKNOWN);
        } else {
            UserIdMdcHelper.set(subject);
        }
    }

    public static void unset() {
        MDC.remove((String)KEY);
    }
}

