/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.guice;

import com.google.common.base.Throwables;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.lang.reflect.Constructor;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.nexus5727.FixedDefaultSessionManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.sonatype.security.authentication.FirstSuccessfulModularRealmAuthenticator;
import org.sonatype.security.authorization.ExceptionCatchingModularRealmAuthorizer;

public class SecurityModule
extends ShiroModule {
    protected void configureShiro() {
        this.bindRealm().to(EmptyRealm.class);
        this.bind(SessionDAO.class).to(EnterpriseCacheSessionDAO.class).asEagerSingleton();
        this.bind(Authenticator.class).to(FirstSuccessfulModularRealmAuthenticator.class).in(Singleton.class);
        this.bind(Authorizer.class).to(ExceptionCatchingModularRealmAuthorizer.class).in(Singleton.class);
    }

    protected void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        this.bind(DefaultSecurityManager.class).toConstructor(SecurityModule.ctor(DefaultSecurityManager.class, new Class[0])).asEagerSingleton();
        this.bind(RealmSecurityManager.class).to(DefaultSecurityManager.class);
        bind.to(DefaultSecurityManager.class);
        this.expose(RealmSecurityManager.class);
    }

    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(FixedDefaultSessionManager.class).asEagerSingleton();
        this.bind(FixedDefaultSessionManager.class);
    }

    private static final <T> Constructor<T> ctor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    @Singleton
    private static final class EmptyRealm
    implements Realm {
        private EmptyRealm() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public boolean supports(AuthenticationToken token) {
            return false;
        }

        public AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) {
            return null;
        }
    }
}

