/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.validator;

import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.validation.ValidationContext;
import org.sonatype.configuration.validation.ValidationRequest;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.configuration.model.SecurityConfiguration;
import org.sonatype.security.configuration.validator.SecurityConfigurationValidator;
import org.sonatype.security.configuration.validator.SecurityValidationContext;

@Singleton
@Typed(value={SecurityConfigurationValidator.class})
@Named(value="default")
public class DefaultSecurityConfigurationValidator
implements SecurityConfigurationValidator {
    @Override
    public ValidationResponse validateModel(SecurityValidationContext context, ValidationRequest<SecurityConfiguration> request) {
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setContext((ValidationContext)context);
        SecurityConfiguration configuration = (SecurityConfiguration)request.getConfiguration();
        validationResponse.append(this.validateAnonymousUsername(context, configuration.getAnonymousUsername()));
        validationResponse.append(this.validateAnonymousPassword(context, configuration.getAnonymousPassword()));
        validationResponse.append(this.validateRealms(context, configuration.getRealms()));
        return validationResponse;
    }

    @Override
    public ValidationResponse validateAnonymousPassword(SecurityValidationContext context, String anonymousPassword) {
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setContext((ValidationContext)context);
        return validationResponse;
    }

    @Override
    public ValidationResponse validateAnonymousUsername(SecurityValidationContext context, String anonymousUsername) {
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setContext((ValidationContext)context);
        return validationResponse;
    }

    @Override
    public ValidationResponse validateRealms(SecurityValidationContext context, List<String> realms) {
        ValidationResponse validationResponse = new ValidationResponse();
        validationResponse.setContext((ValidationContext)context);
        if (context.getSecurityConfiguration() == null && realms.size() < 1) {
            validationResponse.addValidationError("Security is enabled, You must have at least one realm enabled.");
        }
        return validationResponse;
    }
}

