/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.upgrade;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.configuration.model.v2_0_7.SecurityConfiguration;
import org.sonatype.security.configuration.model.v2_0_7.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.configuration.model.v2_0_8.upgrade.BasicVersionUpgrade;
import org.sonatype.security.configuration.upgrade.SecurityConfigurationVersionUpgrader;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={SecurityConfigurationVersionUpgrader.class})
@Named(value="2.0.7")
public class Upgrade207to208
extends ComponentSupport
implements SecurityConfigurationVersionUpgrader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (BufferedReader r = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)file));){
            SecurityConfiguration securityConfiguration = new SecurityConfigurationXpp3Reader().read(r);
            return securityConfiguration;
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        SecurityConfiguration oldc = (SecurityConfiguration)message.getConfiguration();
        org.sonatype.security.configuration.model.SecurityConfiguration newc = new BasicVersionUpgrade().upgradeSecurityConfiguration(oldc);
        newc.setVersion("2.0.8");
        ArrayList realms = Lists.newArrayList();
        for (String realm : newc.getRealms()) {
            if ("NexusLdapAuthenticationRealm".equals(realm)) {
                realm = "LdapAuthenticatingRealm";
            }
            realms.add(realm);
        }
        newc.setRealms(realms);
        message.setModelVersion("2.0.8");
        message.setConfiguration((Object)newc);
    }
}

