/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.configuration.model.v2_0_4.SecurityConfiguration;
import org.sonatype.security.configuration.model.v2_0_4.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.configuration.model.v2_0_5.upgrade.BasicVersionUpgrade;
import org.sonatype.security.configuration.upgrade.SecurityConfigurationVersionUpgrader;

@Singleton
@Typed(value={SecurityConfigurationVersionUpgrader.class})
@Named(value="2.0.4")
public class Upgrade204to205
implements SecurityConfigurationVersionUpgrader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (BufferedReader r = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)file));){
            SecurityConfiguration securityConfiguration = new SecurityConfigurationXpp3Reader().read(r);
            return securityConfiguration;
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        SecurityConfiguration oldc = (SecurityConfiguration)message.getConfiguration();
        org.sonatype.security.configuration.model.v2_0_5.SecurityConfiguration newc = new BasicVersionUpgrade().upgradeSecurityConfiguration(oldc);
        newc.setVersion("2.0.5");
        message.setModelVersion("2.0.5");
        message.setConfiguration((Object)newc);
    }
}

