/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ReaderFactory;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.configuration.model.v2_0_3.io.xpp3.SecurityConfigurationXpp3Reader;
import org.sonatype.security.configuration.model.v2_0_4.SecurityConfiguration;
import org.sonatype.security.configuration.model.v2_0_4.upgrade.BasicVersionUpgrade;
import org.sonatype.security.configuration.upgrade.SecurityConfigurationVersionUpgrader;

@Singleton
@Typed(value={SecurityConfigurationVersionUpgrader.class})
@Named(value="2.0.3")
public class Upgrade203to204
implements SecurityConfigurationVersionUpgrader {
    private final int HASH_ITERATIONS = 1024;

    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        try (BufferedReader r = null;){
            r = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)file));
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            org.sonatype.security.configuration.model.v2_0_3.SecurityConfiguration securityConfiguration = reader.read(r);
            return securityConfiguration;
        }
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        org.sonatype.security.configuration.model.v2_0_3.SecurityConfiguration oldc = (org.sonatype.security.configuration.model.v2_0_3.SecurityConfiguration)message.getConfiguration();
        SecurityConfiguration newc = new BasicVersionUpgrade().upgradeSecurityConfiguration(oldc);
        newc.setVersion("2.0.4");
        newc.setHashIterations(1024);
        message.setModelVersion("2.0.4");
        message.setConfiguration((Object)newc);
    }
}

