/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.UnsupportedConfigurationVersionException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.security.configuration.model.SecurityConfiguration;
import org.sonatype.security.configuration.upgrade.SecurityConfigurationUpgrader;
import org.sonatype.security.configuration.upgrade.SecurityConfigurationVersionUpgrader;

@Singleton
@Typed(value={SecurityConfigurationUpgrader.class})
@Named(value="default")
public class DefaultSecurityConfigurationUpgrader
implements SecurityConfigurationUpgrader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecurityConfigurationUpgrader.class);
    private final Map<String, SecurityConfigurationVersionUpgrader> upgraders;

    @Inject
    public DefaultSecurityConfigurationUpgrader(Map<String, SecurityConfigurationVersionUpgrader> upgraders) {
        this.upgraders = upgraders;
    }

    public SecurityConfiguration loadOldConfiguration(File file) throws IOException, ConfigurationIsCorruptedException, UnsupportedConfigurationVersionException {
        String modelVersion = null;
        try {
            BufferedReader r = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)file));
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)r);
            modelVersion = dom.getChild("version").getValue();
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
        if ("2.0.8".equals(modelVersion)) {
            throw new ConfigurationIsCorruptedException(file);
        }
        UpgradeMessage msg = new UpgradeMessage();
        msg.setModelVersion(modelVersion);
        SecurityConfigurationVersionUpgrader upgrader = this.upgraders.get(msg.getModelVersion());
        if (upgrader != null) {
            logger.info("Upgrading old Security configuration file (version {}) from {}", (Object)msg.getModelVersion(), (Object)file.getAbsolutePath());
            msg.setConfiguration(upgrader.loadConfiguration(file));
            while (!"2.0.8".equals(msg.getModelVersion())) {
                if (upgrader == null) {
                    throw new UnsupportedConfigurationVersionException(modelVersion, file);
                }
                upgrader.upgrade(msg);
                upgrader = this.upgraders.get(msg.getModelVersion());
            }
            logger.info("Security configuration file upgraded to current version {} successfully", (Object)msg.getModelVersion());
            return (SecurityConfiguration)msg.getConfiguration();
        }
        throw new UnsupportedConfigurationVersionException(modelVersion, file);
    }
}

