/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.source;

import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.security.configuration.model.SecurityConfiguration;
import org.sonatype.security.configuration.source.AbstractSecurityConfigurationSource;
import org.sonatype.security.configuration.source.SecurityConfigurationSource;

@Singleton
@Typed(value={SecurityConfigurationSource.class})
@Named(value="static")
public class StaticSecurityConfigurationSource
extends AbstractSecurityConfigurationSource {
    private static final String STATIC_SECURITY_RESOURCE = "/META-INF/security/security-configuration.xml";

    public InputStream getConfigurationAsStream() throws IOException {
        return this.getClass().getResourceAsStream(STATIC_SECURITY_RESOURCE);
    }

    public SecurityConfiguration loadConfiguration() throws ConfigurationException, IOException {
        if (this.getClass().getResource(STATIC_SECURITY_RESOURCE) != null) {
            this.loadConfiguration(this.getConfigurationAsStream());
        } else {
            this.getLogger().warn("Default static security configuration not found in classpath: /META-INF/security/security-configuration.xml");
        }
        SecurityConfiguration configuration = this.getConfiguration();
        return configuration;
    }

    public void storeConfiguration() throws IOException {
        throw new UnsupportedOperationException("The SecurityDefaultsConfigurationSource is static source!");
    }

    public boolean isConfigurationDefaulted() {
        return false;
    }
}

