/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.source;

import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

@Singleton
@Typed(value={PasswordHelper.class})
@Named(value="default")
public class PasswordHelper {
    private static final String ENC = "CMMDwoV";
    private final PlexusCipher plexusCipher;

    @Inject
    public PasswordHelper(PlexusCipher plexusCipher) {
        this.plexusCipher = plexusCipher;
    }

    public String encrypt(String password) throws PlexusCipherException {
        return this.encrypt(password, ENC);
    }

    public String encrypt(String password, String encoding) throws PlexusCipherException {
        if (password != null) {
            return this.plexusCipher.encryptAndDecorate(password, encoding);
        }
        return null;
    }

    public String decrypt(String encodedPassword) throws PlexusCipherException {
        return this.decrypt(encodedPassword, ENC);
    }

    public String decrypt(String encodedPassword, String encoding) throws PlexusCipherException {
        if (!this.plexusCipher.isEncryptedString(encodedPassword)) {
            return encodedPassword;
        }
        if (encodedPassword != null) {
            return this.plexusCipher.decryptDecorated(encodedPassword, encoding);
        }
        return null;
    }
}

