/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration.source;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.security.configuration.model.SecurityConfiguration;
import org.sonatype.security.configuration.model.io.xpp3.SecurityConfigurationXpp3Writer;
import org.sonatype.security.configuration.source.AbstractSecurityConfigurationSource;
import org.sonatype.security.configuration.source.PasswordHelper;
import org.sonatype.security.configuration.source.SecurityConfigurationSource;
import org.sonatype.security.configuration.upgrade.SecurityConfigurationUpgrader;
import org.sonatype.sisu.goodies.common.io.FileReplacer;

@Singleton
@Typed(value={SecurityConfigurationSource.class})
@Named(value="file")
public class FileSecurityConfigurationSource
extends AbstractSecurityConfigurationSource {
    private File configurationFile;
    private SecurityConfigurationUpgrader configurationUpgrader;
    private final SecurityConfigurationSource securityDefaults;
    private final PasswordHelper passwordHelper;
    private boolean configurationDefaulted;

    @Inject
    public FileSecurityConfigurationSource(@Named(value="static") SecurityConfigurationSource securityDefaults, @Named(value="${application-conf}/security-configuration.xml") File configurationFile, PasswordHelper passwordHelper, SecurityConfigurationUpgrader configurationUpgrader) {
        this.securityDefaults = securityDefaults;
        this.configurationFile = configurationFile;
        this.passwordHelper = passwordHelper;
        this.configurationUpgrader = configurationUpgrader;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public SecurityConfiguration loadConfiguration() throws ConfigurationException, IOException {
        this.securityDefaults.loadConfiguration();
        if (this.getConfigurationFile() == null || this.getConfigurationFile().getAbsolutePath().contains("${")) {
            throw new ConfigurationException("The configuration file is not set or resolved properly: " + (this.getConfigurationFile() == null ? "null" : this.getConfigurationFile().getAbsolutePath()));
        }
        if (!this.getConfigurationFile().exists()) {
            this.getLogger().warn("No configuration file in place, copying the default one and continuing with it.");
            this.setConfiguration((SecurityConfiguration)this.securityDefaults.getConfiguration());
            this.saveConfiguration(this.getConfigurationFile());
            this.configurationDefaulted = true;
        } else {
            this.configurationDefaulted = false;
        }
        this.loadConfiguration(this.getConfigurationFile());
        if (this.getConfiguration() == null) {
            this.upgradeConfiguration(this.getConfigurationFile());
            this.loadConfiguration(this.getConfigurationFile());
        }
        return this.getConfiguration();
    }

    public void storeConfiguration() throws IOException {
        this.saveConfiguration(this.getConfigurationFile());
    }

    public InputStream getConfigurationAsStream() throws IOException {
        return new FileInputStream(this.getConfigurationFile());
    }

    public SecurityConfigurationSource getDefaultsSource() {
        return this.securityDefaults;
    }

    protected void upgradeConfiguration(File file) throws IOException, ConfigurationException {
        this.getLogger().info("Trying to upgrade the security configuration file {}", (Object)file.getAbsolutePath());
        this.setConfiguration((SecurityConfiguration)this.configurationUpgrader.loadOldConfiguration(file));
        if (this.getConfiguration() == null) {
            throw new ConfigurationException("Could not upgrade Security configuration! Please replace the " + file.getAbsolutePath() + " file with a valid Security configuration file.");
        }
        SecurityConfiguration configuration = this.getConfiguration();
        if (StringUtils.isNotEmpty((String)configuration.getAnonymousPassword())) {
            String encryptedPassword = configuration.getAnonymousPassword();
            try {
                configuration.setAnonymousPassword(this.passwordHelper.decrypt(encryptedPassword));
            }
            catch (PlexusCipherException e) {
                this.getLogger().error("Failed to decrypt anonymous user's password in security-configuration.xml, password might be encrypted in memory.", (Throwable)e);
            }
        }
        this.getLogger().info("Creating backup from the old file and saving the upgraded security configuration.");
        File backup = new File(file.getParentFile(), file.getName() + ".bak");
        FileUtils.copyFile((File)file, (File)backup);
        this.setConfigurationUpgraded(true);
        this.saveConfiguration(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(File file) throws IOException {
        this.getLogger().info("Loading Security configuration from {}", (Object)file.getAbsolutePath());
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            this.loadConfiguration(fis);
            SecurityConfiguration configuration = this.getConfiguration();
            if (configuration != null && StringUtils.isNotEmpty((String)configuration.getAnonymousPassword())) {
                String encryptedPassword = configuration.getAnonymousPassword();
                try {
                    configuration.setAnonymousPassword(this.passwordHelper.decrypt(encryptedPassword));
                }
                catch (PlexusCipherException e) {
                    this.getLogger().error("Failed to decrype anonymous user's password in security-configuration.xml, password might be encrypted in memory.", (Throwable)e);
                }
            }
        }
    }

    private static void mkdir(Path dir) throws IOException {
        block2: {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(dir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfiguration(File file) throws IOException {
        try {
            FileSecurityConfigurationSource.mkdir(file.getParentFile().toPath());
        }
        catch (IOException e) {
            String message = "\r\n******************************************************************************\r\n* Could not create configuration file [ " + file.toString() + "]!!!! *\r\n" + "* Application cannot start properly until the process has read+write permissions to this folder *\r\n" + "******************************************************************************";
            this.getLogger().error(message);
            throw new IOException("Could not create configuration file " + file.getAbsolutePath(), e);
        }
        final SecurityConfiguration configuration = this.getConfiguration();
        Preconditions.checkNotNull((Object)configuration, (Object)"Missing security configuration");
        String clearPassword = configuration.getAnonymousPassword();
        try {
            configuration.setAnonymousPassword(this.passwordHelper.encrypt(clearPassword));
        }
        catch (PlexusCipherException e) {
            this.getLogger().warn("Filed to encrypte the anonymous users password, storing configuration with cleartext password!", (Throwable)e);
        }
        try {
            this.getLogger().debug("Saving configuration: {}", (Object)file);
            FileReplacer fileReplacer = new FileReplacer(file);
            fileReplacer.setDeleteBackupFile(true);
            fileReplacer.replace(new FileReplacer.ContentWriter(){

                public void write(BufferedOutputStream output) throws IOException {
                    new SecurityConfigurationXpp3Writer().write(output, configuration);
                }
            });
        }
        finally {
            configuration.setAnonymousPassword(clearPassword);
        }
    }

    public boolean isConfigurationDefaulted() {
        return this.configurationDefaulted;
    }
}

