/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.configuration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.configuration.SecurityConfigurationManager;
import org.sonatype.security.configuration.model.SecurityConfiguration;
import org.sonatype.security.configuration.source.SecurityConfigurationSource;
import org.sonatype.security.configuration.validator.SecurityConfigurationValidator;
import org.sonatype.security.configuration.validator.SecurityValidationContext;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Typed(value={SecurityConfigurationManager.class})
@Named(value="default")
public class DefaultSecurityConfigurationManager
extends ComponentSupport
implements SecurityConfigurationManager {
    private final SecurityConfigurationSource configurationSource;
    private final SecurityConfigurationValidator validator;
    private SecurityConfiguration configuration = null;
    private ReentrantLock lock = new ReentrantLock();

    @Inject
    public DefaultSecurityConfigurationManager(@Named(value="file") SecurityConfigurationSource configurationSource, SecurityConfigurationValidator validator) {
        this.configurationSource = configurationSource;
        this.validator = validator;
    }

    @Override
    public boolean isAnonymousAccessEnabled() {
        return this.getConfiguration().isAnonymousAccessEnabled();
    }

    @Override
    public void setAnonymousAccessEnabled(boolean anonymousAccessEnabled) {
        this.getConfiguration().setAnonymousAccessEnabled(anonymousAccessEnabled);
    }

    @Override
    public String getAnonymousPassword() {
        return this.getConfiguration().getAnonymousPassword();
    }

    @Override
    public void setAnonymousPassword(String anonymousPassword) throws InvalidConfigurationException {
        ValidationResponse vr = this.validator.validateAnonymousPassword(this.initializeContext(), anonymousPassword);
        if (!vr.isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.getConfiguration().setAnonymousPassword(anonymousPassword);
    }

    @Override
    public String getAnonymousUsername() {
        return this.getConfiguration().getAnonymousUsername();
    }

    @Override
    public void setAnonymousUsername(String anonymousUsername) throws InvalidConfigurationException {
        ValidationResponse vr = this.validator.validateAnonymousUsername(this.initializeContext(), anonymousUsername);
        if (!vr.isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.getConfiguration().setAnonymousUsername(anonymousUsername);
    }

    @Override
    public int getHashIterations() {
        return this.getConfiguration().getHashIterations();
    }

    @Override
    public List<String> getRealms() {
        return Collections.unmodifiableList(this.getConfiguration().getRealms());
    }

    @Override
    public void setRealms(List<String> realms) throws InvalidConfigurationException {
        ValidationResponse vr = this.validator.validateRealms(this.initializeContext(), realms);
        if (!vr.isValid()) {
            throw new InvalidConfigurationException(vr);
        }
        this.getConfiguration().setRealms(realms);
    }

    private SecurityConfiguration getConfiguration() {
        if (this.configuration != null) {
            return this.configuration;
        }
        this.lock.lock();
        try {
            this.configurationSource.loadConfiguration();
            this.configuration = (SecurityConfiguration)this.configurationSource.getConfiguration();
        }
        catch (IOException e) {
            this.log.error("IOException while retrieving configuration file", (Throwable)e);
        }
        catch (ConfigurationException e) {
            this.log.error("Invalid Configuration", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        return this.configuration;
    }

    @Override
    public void clearCache() {
        this.lock.lock();
        this.configuration = null;
        this.lock.unlock();
    }

    @Override
    public void save() {
        this.lock.lock();
        try {
            this.configurationSource.storeConfiguration();
        }
        catch (IOException e) {
            this.log.error("IOException while storing configuration file", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private SecurityValidationContext initializeContext() {
        SecurityValidationContext context = new SecurityValidationContext();
        context.setSecurityConfiguration(this.getConfiguration());
        return context;
    }
}

