/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.authorization;

import java.util.HashSet;
import java.util.Set;

public class Role
implements Comparable<Role> {
    private String roleId;
    private String name;
    private String description;
    private String source;
    private boolean readOnly;
    private Set<String> roles = new HashSet<String>();
    private Set<String> privileges = new HashSet<String>();

    public Role() {
    }

    public Role(String roleId, String name, String description, String source, boolean readOnly, Set<String> roles, Set<String> privileges) {
        this.roleId = roleId;
        this.name = name;
        this.description = description;
        this.source = source;
        this.readOnly = readOnly;
        this.roles = roles;
        this.privileges = privileges;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public void addPrivilege(String privilege) {
        this.privileges.add(privilege);
    }

    public void setPrivileges(Set<String> privilege) {
        this.privileges = privilege;
    }

    @Override
    public int compareTo(Role o) {
        int before = -1;
        boolean equal = false;
        boolean after = true;
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        if (this.getRoleId() == null && o.getRoleId() != null) {
            return -1;
        }
        if (this.getRoleId() != null && o.getRoleId() == null) {
            return 1;
        }
        int result = this.getRoleId().compareTo(o.getRoleId());
        if (result != 0) {
            return result;
        }
        if (this.getSource() == null) {
            return -1;
        }
        return this.getSource().compareTo(o.getSource());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.privileges == null ? 0 : this.privileges.hashCode());
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        result = 31 * result + (this.roleId == null ? 0 : this.roleId.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privileges == null ? other.privileges != null : !this.privileges.equals(other.privileges)) {
            return false;
        }
        if (this.readOnly != other.readOnly) {
            return false;
        }
        if (this.roleId == null ? other.roleId != null : !this.roleId.equals(other.roleId)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

