/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.authorization;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.security.authorization.PermissionFactory;

@Named(value="caching")
@Singleton
@Typed(value={PermissionFactory.class})
public class InstanceCachingPermissionFactory
implements PermissionFactory {
    private final ConcurrentMap<String, Permission> instances = new MapMaker().weakValues().makeMap();
    private final PermissionFactory delegate;

    @Inject
    public InstanceCachingPermissionFactory(@Named(value="wildcard") PermissionFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Permission create(String permission) {
        return this.getOrCreate(permission);
    }

    protected Permission getOrCreate(String permission) {
        Permission newPermission;
        Permission result = (Permission)this.instances.get(permission);
        if (result == null && (result = this.instances.putIfAbsent(permission, newPermission = this.delegateCreate(permission))) == null) {
            result = newPermission;
        }
        return result;
    }

    protected Permission delegateCreate(String permission) {
        return this.delegate.create(permission);
    }
}

