/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.authentication;

import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.realm.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstSuccessfulModularRealmAuthenticator
extends ModularRealmAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(FirstSuccessfulModularRealmAuthenticator.class);

    protected AuthenticationInfo doMultiRealmAuthentication(Collection<Realm> realms, AuthenticationToken token) {
        logger.trace("Iterating through [" + realms.size() + "] realms for PAM authentication");
        for (Realm realm : realms) {
            if (realm.supports(token)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Attempting to authenticate token [" + token + "] " + "using realm of type [" + realm + "]");
                }
                try {
                    AuthenticationInfo info = realm.getAuthenticationInfo(token);
                    if (info != null) {
                        return info;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Realm [" + realm + "] returned null when authenticating token " + "[" + token + "]");
                }
                catch (Throwable t) {
                    if (!logger.isTraceEnabled()) continue;
                    String msg = "Realm [" + realm + "] threw an exception during a multi-realm authentication attempt:";
                    logger.trace(msg, t);
                }
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Realm of type [" + realm + "] does not support token " + "[" + token + "].  Skipping realm.");
        }
        throw new AuthenticationException("Authentication token of type [" + token.getClass() + "] " + "could not be authenticated by any configured realms.  Please ensure that at least one realm can " + "authenticate these tokens.");
    }
}

