/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security;

import java.util.List;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.security.authentication.AuthenticationException;
import org.sonatype.security.authorization.AuthorizationException;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.usermanagement.InvalidCredentialsException;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserSearchCriteria;

public interface SecuritySystem {
    public void start();

    public void stop();

    public Subject login(AuthenticationToken var1) throws AuthenticationException;

    public AuthenticationInfo authenticate(AuthenticationToken var1) throws AuthenticationException;

    public Subject getSubject();

    public void logout(Subject var1);

    public boolean isPermitted(PrincipalCollection var1, String var2);

    public boolean[] isPermitted(PrincipalCollection var1, List<String> var2);

    public void checkPermission(PrincipalCollection var1, String var2) throws AuthorizationException;

    public void checkPermission(PrincipalCollection var1, List<String> var2) throws AuthorizationException;

    public boolean hasRole(PrincipalCollection var1, String var2);

    public Set<Role> listRoles();

    public Set<Role> listRoles(String var1) throws NoSuchAuthorizationManagerException;

    public User addUser(User var1) throws NoSuchUserManagerException, InvalidConfigurationException;

    public User addUser(User var1, String var2) throws NoSuchUserManagerException, InvalidConfigurationException;

    public User getUser(String var1, String var2) throws UserNotFoundException, NoSuchUserManagerException;

    public User getUser(String var1) throws UserNotFoundException;

    public User updateUser(User var1) throws UserNotFoundException, NoSuchUserManagerException, InvalidConfigurationException;

    @Deprecated
    public void deleteUser(String var1) throws UserNotFoundException;

    public void deleteUser(String var1, String var2) throws UserNotFoundException, NoSuchUserManagerException;

    public Set<RoleIdentifier> getUsersRoles(String var1, String var2) throws UserNotFoundException, NoSuchUserManagerException;

    public void setUsersRoles(String var1, String var2, Set<RoleIdentifier> var3) throws InvalidConfigurationException, UserNotFoundException;

    @Deprecated
    public Set<User> listUsers();

    public Set<User> searchUsers(UserSearchCriteria var1);

    public void forgotPassword(String var1, String var2) throws UserNotFoundException, InvalidConfigurationException;

    public void forgotUsername(String var1) throws UserNotFoundException;

    public void resetPassword(String var1) throws UserNotFoundException, InvalidConfigurationException;

    public void changePassword(String var1, String var2, String var3) throws UserNotFoundException, InvalidCredentialsException, InvalidConfigurationException;

    public void changePassword(String var1, String var2) throws UserNotFoundException, InvalidConfigurationException;

    public Set<Privilege> listPrivileges();

    public AuthorizationManager getAuthorizationManager(String var1) throws NoSuchAuthorizationManagerException;

    public List<String> getRealms();

    public void setRealms(List<String> var1) throws InvalidConfigurationException;

    public boolean isAnonymousAccessEnabled();

    public void setAnonymousAccessEnabled(boolean var1);

    public String getAnonymousUsername();

    public void setAnonymousUsername(String var1) throws InvalidConfigurationException;

    public String getAnonymousPassword();

    public void setAnonymousPassword(String var1) throws InvalidConfigurationException;

    public RealmSecurityManager getSecurityManager();
}

