/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.ehcache.CacheManager;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.Initializable;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.authentication.AuthenticationException;
import org.sonatype.security.authorization.AuthorizationException;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.configuration.SecurityConfigurationManager;
import org.sonatype.security.email.NullSecurityEmailer;
import org.sonatype.security.email.SecurityEmailer;
import org.sonatype.security.events.AuthorizationConfigurationChanged;
import org.sonatype.security.events.SecurityConfigurationChanged;
import org.sonatype.security.events.UserPrincipalsExpired;
import org.sonatype.security.usermanagement.InvalidCredentialsException;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.PasswordGenerator;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.RoleMappingUserManager;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserManagerFacade;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserSearchCriteria;
import org.sonatype.security.usermanagement.UserStatus;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Typed(value={SecuritySystem.class})
@Named(value="default")
public class DefaultSecuritySystem
implements SecuritySystem {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecuritySystem.class);
    private SecurityConfigurationManager securityConfiguration;
    private RealmSecurityManager securityManager;
    private CacheManager cacheManager;
    private UserManagerFacade userManagerFacade;
    private Map<String, Realm> realmMap;
    private Map<String, AuthorizationManager> authorizationManagers;
    private PasswordGenerator passwordGenerator;
    private EventBus eventBus;
    private List<SecurityEmailer> securityEmailers;
    private SecurityEmailer securityEmailer;
    private static final String ALL_ROLES_KEY = "all";
    private volatile boolean started;

    @Inject
    public DefaultSecuritySystem(List<SecurityEmailer> securityEmailers, EventBus eventBus, PasswordGenerator passwordGenerator, Map<String, AuthorizationManager> authorizationManagers, Map<String, Realm> realmMap, SecurityConfigurationManager securityConfiguration, RealmSecurityManager securityManager, CacheManager cacheManager, UserManagerFacade userManagerFacade) {
        this.securityEmailers = securityEmailers;
        this.eventBus = eventBus;
        this.passwordGenerator = passwordGenerator;
        this.authorizationManagers = authorizationManagers;
        this.realmMap = realmMap;
        this.securityConfiguration = securityConfiguration;
        this.securityManager = securityManager;
        this.cacheManager = cacheManager;
        this.eventBus.register((Object)this);
        this.userManagerFacade = userManagerFacade;
        SecurityUtils.setSecurityManager((SecurityManager)this.getSecurityManager());
        this.started = false;
    }

    @Override
    public Subject login(AuthenticationToken token) throws AuthenticationException {
        try {
            Subject subject = this.getSubject();
            subject.login(token);
            return subject;
        }
        catch (org.apache.shiro.authc.AuthenticationException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
    }

    @Override
    public AuthenticationInfo authenticate(AuthenticationToken token) throws AuthenticationException {
        try {
            return this.getSecurityManager().authenticate(token);
        }
        catch (org.apache.shiro.authc.AuthenticationException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
    }

    @Override
    public Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    @Override
    public void logout(Subject subject) {
        subject.logout();
    }

    @Override
    public boolean isPermitted(PrincipalCollection principal, String permission) {
        return this.getSecurityManager().isPermitted(principal, permission);
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principal, List<String> permissions) {
        return this.getSecurityManager().isPermitted(principal, permissions.toArray(new String[permissions.size()]));
    }

    @Override
    public void checkPermission(PrincipalCollection principal, String permission) throws AuthorizationException {
        try {
            this.getSecurityManager().checkPermission(principal, permission);
        }
        catch (org.apache.shiro.authz.AuthorizationException e) {
            throw new AuthorizationException(e.getMessage(), e);
        }
    }

    @Override
    public void checkPermission(PrincipalCollection principal, List<String> permissions) throws AuthorizationException {
        try {
            this.getSecurityManager().checkPermissions(principal, permissions.toArray(new String[permissions.size()]));
        }
        catch (org.apache.shiro.authz.AuthorizationException e) {
            throw new AuthorizationException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasRole(PrincipalCollection principals, String string) {
        return this.getSecurityManager().hasRole(principals, string);
    }

    private Collection<Realm> getRealmsFromConfigSource() {
        ArrayList<Realm> realms = new ArrayList<Realm>();
        List<String> realmIds = this.securityConfiguration.getRealms();
        for (String realmId : realmIds) {
            if (this.realmMap.containsKey(realmId)) {
                realms.add(this.realmMap.get(realmId));
                continue;
            }
            logger.debug("Failed to look up realm as a component, trying reflection");
            try {
                realms.add((Realm)this.getClass().getClassLoader().loadClass(realmId).newInstance());
            }
            catch (Exception e) {
                logger.error("Unable to lookup security realms", (Throwable)e);
            }
        }
        return realms;
    }

    @Override
    public Set<Role> listRoles() {
        HashSet<Role> roles = new HashSet<Role>();
        for (AuthorizationManager authzManager : this.authorizationManagers.values()) {
            Set<Role> tmpRoles = authzManager.listRoles();
            if (tmpRoles == null) continue;
            roles.addAll(tmpRoles);
        }
        return roles;
    }

    @Override
    public Set<Role> listRoles(String sourceId) throws NoSuchAuthorizationManagerException {
        if (ALL_ROLES_KEY.equalsIgnoreCase(sourceId)) {
            return this.listRoles();
        }
        AuthorizationManager authzManager = this.getAuthorizationManager(sourceId);
        return authzManager.listRoles();
    }

    @Override
    public Set<Privilege> listPrivileges() {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        for (AuthorizationManager authzManager : this.authorizationManagers.values()) {
            Set<Privilege> tmpPrivileges = authzManager.listPrivileges();
            if (tmpPrivileges == null) continue;
            privileges.addAll(tmpPrivileges);
        }
        return privileges;
    }

    @Override
    public User addUser(User user) throws NoSuchUserManagerException, InvalidConfigurationException {
        return this.addUser(user, this.generatePassword());
    }

    @Override
    public User addUser(User user, String password) throws NoSuchUserManagerException, InvalidConfigurationException {
        UserManager userManager;
        if (password == null) {
            password = this.generatePassword();
        }
        if (!(userManager = this.userManagerFacade.getUserManager(user.getSource())).supportsWrite()) {
            throw new InvalidConfigurationException("UserManager: " + userManager.getSource() + " does not support writing.");
        }
        userManager.addUser(user, password);
        for (UserManager tmpUserManager : this.userManagerFacade.getUserManagers().values()) {
            if (tmpUserManager.getSource().equals(user.getSource()) || !RoleMappingUserManager.class.isInstance(tmpUserManager)) continue;
            try {
                RoleMappingUserManager roleMappingUserManager = (RoleMappingUserManager)tmpUserManager;
                roleMappingUserManager.setUsersRoles(user.getUserId(), user.getSource(), RoleIdentifier.getRoleIdentifiersForSource(user.getSource(), user.getRoles()));
            }
            catch (UserNotFoundException e) {
                logger.debug("User '" + user.getUserId() + "' is not managed by the usermanager: " + tmpUserManager.getSource());
            }
        }
        if (UserStatus.active.equals((Object)user.getStatus())) {
            this.getSecurityEmailer().sendNewUserCreated(user.getEmailAddress(), user.getUserId(), password);
        }
        return user;
    }

    @Override
    public User updateUser(User user) throws UserNotFoundException, NoSuchUserManagerException, InvalidConfigurationException {
        UserManager userManager = this.userManagerFacade.getUserManager(user.getSource());
        if (!userManager.supportsWrite()) {
            throw new InvalidConfigurationException("UserManager: " + userManager.getSource() + " does not support writing.");
        }
        userManager.updateUser(user);
        for (UserManager tmpUserManager : this.userManagerFacade.getUserManagers().values()) {
            if (tmpUserManager.getSource().equals(user.getSource()) || !RoleMappingUserManager.class.isInstance(tmpUserManager)) continue;
            try {
                RoleMappingUserManager roleMappingUserManager = (RoleMappingUserManager)tmpUserManager;
                roleMappingUserManager.setUsersRoles(user.getUserId(), user.getSource(), RoleIdentifier.getRoleIdentifiersForSource(user.getSource(), user.getRoles()));
            }
            catch (UserNotFoundException e) {
                logger.debug("User '" + user.getUserId() + "' is not managed by the usermanager: " + tmpUserManager.getSource());
            }
        }
        this.eventBus.post((Object)new AuthorizationConfigurationChanged());
        return user;
    }

    @Override
    public void deleteUser(String userId) throws UserNotFoundException {
        User user = this.getUser(userId);
        try {
            this.deleteUser(userId, user.getSource());
        }
        catch (NoSuchUserManagerException e) {
            logger.error("User manager returned user, but could not be found: " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException("User manager returned user, but could not be found: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteUser(String userId, String source) throws UserNotFoundException, NoSuchUserManagerException {
        UserManager userManager = this.userManagerFacade.getUserManager(source);
        userManager.deleteUser(userId);
        this.eventBus.post((Object)new UserPrincipalsExpired(userId, source));
    }

    @Override
    public Set<RoleIdentifier> getUsersRoles(String userId, String source) throws UserNotFoundException, NoSuchUserManagerException {
        User user = this.getUser(userId, source);
        return user.getRoles();
    }

    @Override
    public void setUsersRoles(String userId, String source, Set<RoleIdentifier> roleIdentifiers) throws InvalidConfigurationException, UserNotFoundException {
        boolean foundUser = false;
        for (UserManager tmpUserManager : this.userManagerFacade.getUserManagers().values()) {
            if (!RoleMappingUserManager.class.isInstance(tmpUserManager)) continue;
            RoleMappingUserManager roleMappingUserManager = (RoleMappingUserManager)tmpUserManager;
            try {
                foundUser = true;
                roleMappingUserManager.setUsersRoles(userId, source, RoleIdentifier.getRoleIdentifiersForSource(tmpUserManager.getSource(), roleIdentifiers));
            }
            catch (UserNotFoundException e) {
                logger.debug("User '" + userId + "' is not managed by the usermanager: " + tmpUserManager.getSource());
            }
        }
        if (!foundUser) {
            throw new UserNotFoundException(userId);
        }
    }

    @Override
    public User getUser(String userId) throws UserNotFoundException {
        List<UserManager> orderedUserManagers = this.orderUserManagers();
        for (UserManager userManager : orderedUserManagers) {
            try {
                return this.getUser(userId, userManager.getSource());
            }
            catch (UserNotFoundException e) {
                logger.debug("User: '" + userId + "' was not found in: '" + userManager.getSource() + "' ");
            }
            catch (NoSuchUserManagerException e) {
                logger.warn("UserManager: '" + userManager.getSource() + "' was not found, but is in the list of UserManagers", (Throwable)e);
            }
        }
        throw new UserNotFoundException(userId);
    }

    @Override
    public User getUser(String userId, String source) throws UserNotFoundException, NoSuchUserManagerException {
        UserManager userManager = this.userManagerFacade.getUserManager(source);
        User user = userManager.getUser(userId);
        if (user == null) {
            throw new UserNotFoundException(userId);
        }
        this.addOtherRolesToUser(user);
        return user;
    }

    @Override
    public Set<User> listUsers() {
        HashSet<User> users = new HashSet<User>();
        for (UserManager tmpUserManager : this.userManagerFacade.getUserManagers().values()) {
            users.addAll(tmpUserManager.listUsers());
        }
        for (User user : users) {
            this.addOtherRolesToUser(user);
        }
        return users;
    }

    @Override
    public Set<User> searchUsers(UserSearchCriteria criteria) {
        HashSet<User> users = new HashSet<User>();
        if (StringUtils.isEmpty((String)criteria.getSource())) {
            for (UserManager tmpUserManager : this.userManagerFacade.getUserManagers().values()) {
                Set<User> result = tmpUserManager.searchUsers(criteria);
                if (result == null) continue;
                users.addAll(result);
            }
        } else {
            try {
                users.addAll(this.userManagerFacade.getUserManager(criteria.getSource()).searchUsers(criteria));
            }
            catch (NoSuchUserManagerException e) {
                logger.warn("UserManager: " + criteria.getSource() + " was not found.", (Throwable)e);
            }
        }
        for (User user : users) {
            this.addOtherRolesToUser(user);
        }
        return users;
    }

    private List<UserManager> orderUserManagers() {
        ArrayList<UserManager> orderedLocators = new ArrayList<UserManager>();
        ArrayList<UserManager> unOrderdLocators = new ArrayList<UserManager>(this.userManagerFacade.getUserManagers().values());
        HashMap<String, UserManager> realmToUserManagerMap = new HashMap<String, UserManager>();
        for (UserManager userManager : this.userManagerFacade.getUserManagers().values()) {
            if (userManager.getAuthenticationRealmName() == null) continue;
            realmToUserManagerMap.put(userManager.getAuthenticationRealmName(), userManager);
        }
        Collection realms = this.getSecurityManager().getRealms();
        for (Realm realm : realms) {
            if (!realmToUserManagerMap.containsKey(realm.getName())) continue;
            UserManager userManager = (UserManager)realmToUserManagerMap.get(realm.getName());
            unOrderdLocators.remove(userManager);
            orderedLocators.add(userManager);
        }
        orderedLocators.addAll(unOrderdLocators);
        return orderedLocators;
    }

    private void addOtherRolesToUser(User user) {
        for (UserManager tmpUserManager : this.userManagerFacade.getUserManagers().values()) {
            if (tmpUserManager.getSource().equals(user.getSource()) || !RoleMappingUserManager.class.isInstance(tmpUserManager)) continue;
            try {
                RoleMappingUserManager roleMappingUserManager = (RoleMappingUserManager)tmpUserManager;
                Set<RoleIdentifier> roleIdentifiers = roleMappingUserManager.getUsersRoles(user.getUserId(), user.getSource());
                if (roleIdentifiers == null) continue;
                user.addAllRoles(roleIdentifiers);
            }
            catch (UserNotFoundException e) {
                logger.debug("User '" + user.getUserId() + "' is not managed by the usermanager: " + tmpUserManager.getSource());
            }
        }
    }

    @Override
    public AuthorizationManager getAuthorizationManager(String source) throws NoSuchAuthorizationManagerException {
        if (!this.authorizationManagers.containsKey(source)) {
            throw new NoSuchAuthorizationManagerException("AuthorizationManager with source: '" + source + "' could not be found.");
        }
        return this.authorizationManagers.get(source);
    }

    @Override
    public String getAnonymousUsername() {
        return this.securityConfiguration.getAnonymousUsername();
    }

    @Override
    public boolean isAnonymousAccessEnabled() {
        return this.securityConfiguration.isAnonymousAccessEnabled();
    }

    @Override
    public void changePassword(String userId, String oldPassword, String newPassword) throws UserNotFoundException, InvalidCredentialsException, InvalidConfigurationException {
        try {
            UsernamePasswordToken authenticationToken = new UsernamePasswordToken(userId, oldPassword);
            if (this.getSecurityManager().authenticate((AuthenticationToken)authenticationToken) == null) {
                throw new InvalidCredentialsException();
            }
        }
        catch (org.apache.shiro.authc.AuthenticationException e) {
            logger.debug("User failed to change password reason: " + e.getMessage(), (Throwable)e);
            throw new InvalidCredentialsException();
        }
        this.changePassword(userId, newPassword);
    }

    @Override
    public void changePassword(String userId, String newPassword) throws UserNotFoundException, InvalidConfigurationException {
        User user = this.getUser(userId);
        try {
            UserManager userManager = this.userManagerFacade.getUserManager(user.getSource());
            userManager.changePassword(userId, newPassword);
        }
        catch (NoSuchUserManagerException e) {
            logger.warn("User '" + userId + "' with source: '" + user.getSource() + "' but could not find the UserManager for that source.");
        }
    }

    @Override
    public void forgotPassword(String userId, String email) throws UserNotFoundException, InvalidConfigurationException {
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setEmail(email);
        criteria.setUserId(userId);
        Set<User> users = this.searchUsers(criteria);
        boolean found = false;
        for (User user : users) {
            if (!user.getUserId().equalsIgnoreCase(userId.trim()) || !user.getEmailAddress().equals(email)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new UserNotFoundException(email);
        }
        this.resetPassword(userId);
    }

    @Override
    public void forgotUsername(String email) throws UserNotFoundException {
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setEmail(email);
        Set<User> users = this.searchUsers(criteria);
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user.getUserId().equalsIgnoreCase(this.getAnonymousUsername()) || !email.equalsIgnoreCase(user.getEmailAddress())) continue;
            userIds.add(user.getUserId());
        }
        if (userIds.size() <= 0) {
            throw new UserNotFoundException(email);
        }
        this.getSecurityEmailer().sendForgotUsername(email, userIds);
    }

    @Override
    public void resetPassword(String userId) throws UserNotFoundException, InvalidConfigurationException {
        String newClearTextPassword = this.generatePassword();
        User user = this.getUser(userId);
        this.changePassword(userId, newClearTextPassword);
        this.getSecurityEmailer().sendResetPassword(user.getEmailAddress(), newClearTextPassword);
    }

    private String generatePassword() {
        return this.passwordGenerator.generatePassword(10, 10);
    }

    private SecurityEmailer getSecurityEmailer() {
        if (this.securityEmailer == null) {
            Iterator<SecurityEmailer> i = this.securityEmailers.iterator();
            if (i.hasNext()) {
                this.securityEmailer = i.next();
            } else {
                logger.error("Failed to find a SecurityEmailer");
                this.securityEmailer = new NullSecurityEmailer();
            }
        }
        return this.securityEmailer;
    }

    @Override
    public List<String> getRealms() {
        return new ArrayList<String>(this.securityConfiguration.getRealms());
    }

    @Override
    public void setRealms(List<String> realms) throws InvalidConfigurationException {
        this.securityConfiguration.setRealms(realms);
        this.securityConfiguration.save();
        this.setSecurityManagerRealms();
    }

    @Override
    public void setAnonymousAccessEnabled(boolean enabled) {
        this.securityConfiguration.setAnonymousAccessEnabled(enabled);
        this.securityConfiguration.save();
    }

    @Override
    public void setAnonymousUsername(String anonymousUsername) throws InvalidConfigurationException {
        this.securityConfiguration.setAnonymousUsername(anonymousUsername);
        this.securityConfiguration.save();
    }

    @Override
    public String getAnonymousPassword() {
        return this.securityConfiguration.getAnonymousPassword();
    }

    @Override
    public void setAnonymousPassword(String anonymousPassword) throws InvalidConfigurationException {
        this.securityConfiguration.setAnonymousPassword(anonymousPassword);
        this.securityConfiguration.save();
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException(this.getClass().getName() + " was already started, same instance is not re-startable!");
        }
        this.securityConfiguration.clearCache();
        EhCacheManager ehCacheManager = new EhCacheManager();
        ehCacheManager.setCacheManager(this.cacheManager);
        this.getSecurityManager().setCacheManager((org.apache.shiro.cache.CacheManager)ehCacheManager);
        if (Initializable.class.isInstance(this.getSecurityManager())) {
            ((Initializable)this.getSecurityManager()).init();
        }
        this.setSecurityManagerRealms();
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        if (this.getSecurityManager().getRealms() != null) {
            for (Realm realm : this.getSecurityManager().getRealms()) {
                if (AuthenticatingRealm.class.isInstance(realm)) {
                    ((AuthenticatingRealm)realm).setAuthenticationCache(null);
                }
                if (!AuthorizingRealm.class.isInstance(realm)) continue;
                ((AuthorizingRealm)realm).setAuthorizationCache(null);
            }
        }
        this.getSecurityManager().destroy();
    }

    private void setSecurityManagerRealms() {
        this.getSecurityManager().setRealms(new ArrayList<Realm>(this.getRealmsFromConfigSource()));
    }

    private void clearRealmCaches() {
        if (this.getSecurityManager().getRealms() != null) {
            for (Realm realm : this.getSecurityManager().getRealms()) {
                AuthorizingRealm aRealm;
                Cache cache;
                if (!AuthorizingRealm.class.isInstance(realm) || (cache = (aRealm = (AuthorizingRealm)realm).getAuthorizationCache()) == null) continue;
                cache.clear();
            }
        }
    }

    @Subscribe
    public void onEvent(AuthorizationConfigurationChanged evt) {
        this.clearRealmCaches();
    }

    @Subscribe
    public void onEvent(SecurityConfigurationChanged evt) {
        this.clearRealmCaches();
        this.securityConfiguration.clearCache();
        this.setSecurityManagerRealms();
    }

    @Override
    public RealmSecurityManager getSecurityManager() {
        return this.securityManager;
    }
}

