/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.nexus5727;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDefaultWebSessionManager
extends DefaultWebSessionManager {
    public static final String DEFAULT_NEXUS_SESSION_COOKIE_NAME = "NXSESSIONID";
    private static final Logger log = LoggerFactory.getLogger(FixedDefaultWebSessionManager.class);

    @Inject
    public void configureProperties(@Named(value="${shiro.globalSessionTimeout:-1800000}") long globalSessionTimeout, @Named(value="${nexus.sessionCookieName:-NXSESSIONID}") String sessionCookieName) {
        this.setGlobalSessionTimeout(globalSessionTimeout);
        this.getSessionIdCookie().setName(sessionCookieName);
    }

    @Inject
    public void configureSessionListeners(Collection<SessionListener> listeners) {
        this.setSessionListeners(listeners);
    }

    protected synchronized void enableSessionValidation() {
        log.info("Global session timeout: {} ms", (Object)this.getGlobalSessionTimeout());
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler == null) {
            super.enableSessionValidation();
        }
    }
}

