/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.nexus5727;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDefaultSessionManager
extends DefaultSessionManager {
    private static final Logger log = LoggerFactory.getLogger(FixedDefaultSessionManager.class);

    @Inject
    public void configureProperties(@Named(value="${shiro.globalSessionTimeout:-1800000}") long globalSessionTimeout) {
        this.setGlobalSessionTimeout(globalSessionTimeout);
    }

    protected synchronized void enableSessionValidation() {
        log.info("Global session timeout: {} ms", (Object)this.getGlobalSessionTimeout());
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler == null) {
            super.enableSessionValidation();
        }
    }
}

