/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.guice.servlet;

import com.fasterxml.jackson.core.JsonFactory;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import com.yammer.metrics.guice.servlet.AdminServletProvider;
import com.yammer.metrics.reporting.AdminServlet;
import java.lang.annotation.Annotation;

public class AdminServletModule
extends ServletModule {
    private final JsonFactory jsonFactory;
    private final String healthcheckUri;
    private final String metricsUri;
    private final String pingUri;
    private final String threadsUri;

    public AdminServletModule() {
        this(null, "/healthcheck", "/metrics", "/ping", "/threads");
    }

    public AdminServletModule(JsonFactory jsonFactory) {
        this(jsonFactory, "/healthcheck", "/metrics", "/ping", "/threads");
    }

    public AdminServletModule(String healthcheckUri, String metricsUri, String pingUri, String threadsUri) {
        this(null, healthcheckUri, metricsUri, pingUri, threadsUri);
    }

    public AdminServletModule(JsonFactory jsonFactory, String healthcheckUri, String metricsUri, String pingUri, String threadsUri) {
        this.jsonFactory = jsonFactory;
        this.healthcheckUri = healthcheckUri;
        this.metricsUri = metricsUri;
        this.pingUri = pingUri;
        this.threadsUri = threadsUri;
    }

    protected void configureServlets() {
        if (this.jsonFactory != null) {
            this.bind(JsonFactory.class).annotatedWith((Annotation)Names.named((String)"AdminServlet.JSON_FACTORY")).toInstance((Object)this.jsonFactory);
        }
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"AdminServlet.HEALTHCHECK_URI")).toInstance((Object)this.healthcheckUri);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"AdminServlet.METRICS_URI")).toInstance((Object)this.metricsUri);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"AdminServlet.PING_URI")).toInstance((Object)this.pingUri);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"AdminServlet.THREADS_URI")).toInstance((Object)this.threadsUri);
        this.bind(AdminServlet.class).toProvider(AdminServletProvider.class).asEagerSingleton();
        this.serve(this.healthcheckUri, new String[]{this.metricsUri, this.pingUri, this.threadsUri}).with(AdminServlet.class);
    }
}

