/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.configuration.validation;

import java.io.StringWriter;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;

public class InvalidConfigurationException
extends ConfigurationException {
    private static final long serialVersionUID = -7524456367570093185L;
    private ValidationResponse validationResponse;

    public InvalidConfigurationException() {
        this("Configuration is invalid!");
    }

    public InvalidConfigurationException(String msg) {
        super(msg);
    }

    public InvalidConfigurationException(String msg, Throwable t) {
        super(msg, t);
    }

    public InvalidConfigurationException(ValidationResponse validationResponse) {
        this();
        this.validationResponse = validationResponse;
    }

    public ValidationResponse getValidationResponse() {
        return this.validationResponse;
    }

    @Override
    public String getMessage() {
        StringWriter sw = new StringWriter();
        sw.append(super.getMessage());
        if (this.getValidationResponse() != null) {
            if (this.getValidationResponse().getValidationErrors().size() > 0) {
                sw.append("\nValidation errors follows:\n");
                for (ValidationMessage error : this.getValidationResponse().getValidationErrors()) {
                    sw.append(error.toString());
                }
                sw.append("\n");
            }
            if (this.getValidationResponse().getValidationWarnings().size() > 0) {
                sw.append("\nValidation warnings follows:\n");
                for (ValidationMessage warning : this.getValidationResponse().getValidationWarnings()) {
                    sw.append(warning.toString());
                }
                sw.append("\n");
            }
        }
        return sw.toString();
    }
}

