/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.configuration.source;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.Configuration;
import org.sonatype.configuration.source.ConfigurationSource;
import org.sonatype.configuration.validation.ValidationResponse;

public abstract class AbstractStreamConfigurationSource<E extends Configuration>
implements ConfigurationSource<E> {
    private E configuration;
    private boolean configurationUpgraded;
    private ValidationResponse validationResponse;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public E getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(E configuration) {
        this.configuration = configuration;
    }

    protected void rejectConfiguration(String message) {
        this.configuration = null;
        if (message != null) {
            this.getLogger().warn(message);
        }
    }

    protected abstract void loadConfiguration(InputStream var1) throws IOException;

    @Override
    public ValidationResponse getValidationResponse() {
        return this.validationResponse;
    }

    protected void setValidationResponse(ValidationResponse validationResponse) {
        this.validationResponse = validationResponse;
    }

    @Override
    public boolean isConfigurationUpgraded() {
        return this.configurationUpgraded;
    }

    public void setConfigurationUpgraded(boolean configurationUpgraded) {
        this.configurationUpgraded = configurationUpgraded;
    }

    public ConfigurationSource<?> getDefaultsSource() {
        return null;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

