/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.repository.metadata.MetadataHandlerException;
import org.sonatype.nexus.repository.metadata.RawTransport;
import org.sonatype.nexus.repository.metadata.RepositoryMetadataHandler;
import org.sonatype.nexus.repository.metadata.model.OrderedMirrorMetadata;
import org.sonatype.nexus.repository.metadata.model.OrderedRepositoryMirrorsMetadata;
import org.sonatype.nexus.repository.metadata.model.RepositoryMetadata;
import org.sonatype.nexus.repository.metadata.model.RepositoryMirrorMetadata;
import org.sonatype.nexus.repository.metadata.model.io.xpp3.RepositoryMetadataXpp3Reader;
import org.sonatype.nexus.repository.metadata.model.io.xpp3.RepositoryMetadataXpp3Writer;
import org.sonatype.nexus.repository.metadata.validation.DefaultRepositoryMetadataValidator;
import org.sonatype.nexus.repository.metadata.validation.RepositoryMetadataValidator;

@Singleton
@Named
public class DefaultRepositoryMetadataHandler
implements RepositoryMetadataHandler {
    private static final String REPOSITORY_METADATA_PATH = "/.meta/repository-metadata.xml";
    protected final RepositoryMetadataXpp3Reader repositoryMetadataXpp3Reader = new RepositoryMetadataXpp3Reader();
    protected final RepositoryMetadataXpp3Writer repositoryMetadataXpp3Writer = new RepositoryMetadataXpp3Writer();

    @Override
    public RepositoryMetadata readRepositoryMetadata(RawTransport transport) throws MetadataHandlerException, IOException {
        return this.readRepositoryMetadata(transport, new DefaultRepositoryMetadataValidator());
    }

    @Override
    public RepositoryMetadata readRepositoryMetadata(RawTransport transport, RepositoryMetadataValidator validator) throws MetadataHandlerException, IOException {
        try {
            byte[] data = transport.readRawData(REPOSITORY_METADATA_PATH);
            if (data != null) {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(data);
                    InputStreamReader isr = new InputStreamReader((InputStream)bis, "UTF-8");
                    RepositoryMetadata md = this.repositoryMetadataXpp3Reader.read((Reader)isr);
                    if (validator != null) {
                        validator.validate(md);
                    }
                    return md;
                }
                catch (XmlPullParserException e) {
                    throw new MetadataHandlerException("Metadata is corrupt!", e);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataHandlerException(e);
        }
    }

    @Override
    public void writeRepositoryMetadata(RepositoryMetadata metadata, RawTransport transport) throws MetadataHandlerException, IOException {
        this.writeRepositoryMetadata(metadata, transport, new DefaultRepositoryMetadataValidator());
    }

    @Override
    public void writeRepositoryMetadata(RepositoryMetadata metadata, RawTransport transport, RepositoryMetadataValidator validator) throws MetadataHandlerException, IOException {
        try {
            if (validator != null) {
                validator.validate(metadata);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            this.repositoryMetadataXpp3Writer.write((Writer)writer, metadata);
            writer.flush();
            transport.writeRawData(REPOSITORY_METADATA_PATH, bos.toByteArray());
        }
        catch (Exception e) {
            throw new MetadataHandlerException(e);
        }
    }

    @Override
    public OrderedRepositoryMirrorsMetadata fetchOrderedMirrorMetadata(RepositoryMetadata metadata, RawTransport transport) throws MetadataHandlerException, IOException {
        OrderedRepositoryMirrorsMetadata result = new OrderedRepositoryMirrorsMetadata();
        result.setVersion("1.0.0");
        result.setStrategy("clientManual");
        result.setRequestIp(null);
        result.setRequestTimestamp(System.currentTimeMillis());
        for (RepositoryMirrorMetadata mmd : metadata.getMirrors()) {
            OrderedMirrorMetadata omd = new OrderedMirrorMetadata();
            omd.setId(mmd.getId());
            omd.setUrl(mmd.getUrl());
            result.addMirror(omd);
        }
        return result;
    }
}

