/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.noelios.restlet.http.HttpResponse;
import com.sonatype.nexus.plugins.outreach.Outreach;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapability;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundle;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleEntry;
import com.sonatype.nexus.plugins.outreach.internal.rest.PageBundleMimeRulesSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.util.ThreadContext;
import org.restlet.Context;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.restlet.util.Series;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

public abstract class AbstractWebContentResource
extends AbstractNexusPlexusResource {
    private Outreach outreach;
    private CapabilityRegistry capabilities;
    private MimeSupport mimeSupport;
    private Map<String, PageBundleMimeRulesSource> mimeRules = new WeakHashMap<String, PageBundleMimeRulesSource>();

    protected AbstractWebContentResource() {
    }

    @VisibleForTesting
    AbstractWebContentResource(CapabilityRegistry capabilities, MimeSupport mimeSupport, Outreach outreach) {
        this.configureComponents(outreach, capabilities, mimeSupport);
    }

    @Inject
    public void configureComponents(Outreach outreach, CapabilityRegistry capabilities, MimeSupport mimeSupport) {
        this.outreach = (Outreach)Preconditions.checkNotNull((Object)outreach);
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilities);
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    protected Outreach getOutreach() {
        Preconditions.checkState((this.outreach != null ? 1 : 0) != 0);
        return this.outreach;
    }

    protected MimeSupport getMimeSupport() {
        Preconditions.checkState((this.mimeSupport != null ? 1 : 0) != 0);
        return this.mimeSupport;
    }

    public Object getPayloadInstance() {
        return null;
    }

    public List<Variant> getVariants() {
        return Arrays.asList(new Variant(MediaType.TEXT_HTML), new Variant(MediaType.TEXT_CSS));
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Series headers = ((HttpResponse)response).getHttpCall().getResponseHeaders();
        headers.add("Pragma", "no-cache");
        headers.add("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        try {
            if (OutreachManagementCapability.isDisabled(this.capabilities)) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Object)"Outreach is disabled.");
            }
            return this.get(request, response);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, ResourceException.class);
            this.getLogger().warn("Error while processing page bundle", (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Object)e.getMessage());
        }
    }

    protected Object get(Request request, Response response) throws PlexusResourceException {
        String path = this.getContentPath(request);
        if (path == null) {
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Object)"Path not found.");
        }
        PageBundle bundle = this.getBundle(request);
        if (!bundle.exists()) {
            return "";
        }
        PageBundleEntry content = bundle.getEntry(path);
        if (content == null || !content.exists()) {
            return this.notFound(response, bundle, path);
        }
        return this.createRepresentation(bundle, content);
    }

    protected Representation notFound(Response response, PageBundle bundle, String path) throws PlexusResourceException {
        PageBundleEntry errorPage = bundle.getEntry("errors/404.html");
        if (errorPage.exists()) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.createRepresentation(bundle, errorPage);
        }
        throw new PlexusResourceException(Status.CLIENT_ERROR_NOT_FOUND, (Object)"Content not found in page bundle.");
    }

    @VisibleForTesting
    Representation createRepresentation(PageBundle bundle, PageBundleEntry content) throws PlexusResourceException {
        try {
            return new InputRepresentation((InputStream)content.getContent().getInput(), this.getMediaType(bundle, content), content.getSize());
        }
        catch (IOException e) {
            this.getLogger().warn("PageBundleEntry existed but could not be read", (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Object)("Could not read content for " + content.getName()));
        }
    }

    protected MediaType getMediaType(PageBundle bundle, PageBundleEntry content) {
        PageBundleMimeRulesSource source;
        if (!this.mimeRules.containsKey(bundle.getId()) || !(source = this.mimeRules.get(bundle.getId())).isValidFor(bundle)) {
            source = new PageBundleMimeRulesSource(bundle);
            this.mimeRules.put(bundle.getId(), source);
        }
        return MediaType.valueOf((String)this.getMimeSupport().guessMimeTypeFromPath((MimeRulesSource)source, content.getName()));
    }

    protected String getContentPath(Request request) {
        String path = request.getResourceRef().getRemainingPart(true, false);
        if ((path = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)path))) == null) {
            return null;
        }
        int slash = path.indexOf(47);
        if (slash >= 0) {
            path = path.substring(slash + 1);
        }
        return path;
    }

    public PageBundle getBundle(Request request) {
        Preference preference;
        String tag;
        Outreach.User user = Outreach.User.fromSubject(ThreadContext.getSubject());
        Locale locale = Locale.US;
        List languages = request.getClientInfo().getAcceptedLanguages();
        if (!languages.isEmpty() && !"*".equals(tag = ((Language)(preference = (Preference)languages.get(0)).getMetadata()).getPrimaryTag())) {
            locale = new Locale(tag);
        }
        return this.getOutreach().getPageBundle(user, locale);
    }
}

