/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.outreach.Outreach;
import com.sonatype.nexus.plugins.outreach.internal.LogUtils;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapability;
import com.sonatype.nexus.plugins.outreach.internal.outreach.OutreachConnector;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundle;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleMetadata;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.StatusLine;
import org.codehaus.plexus.util.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.ReadablePeriod;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.util.DigesterUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class SonatypeOutreach
extends ComponentSupport
implements Outreach {
    private static final String CPREFIX = "${nexus.outreach";
    private final File tmpdir;
    private final boolean alwaysRefresh;
    private final EventBus eventBus;
    private final OutreachConnector connector;
    private final ApplicationStatusSource status;
    private final Map<String, PageBundle> bundles = Maps.newHashMap();
    private final CapabilityRegistry capabilities;

    @Inject
    public SonatypeOutreach(EventBus eventBus, OutreachConnector connector, ApplicationStatusSource status, CapabilityRegistry capabilities, ApplicationConfiguration applicationConfiguration, @Named(value="${nexus.outreach.alwaysRefresh:-false}") boolean alwaysRefresh) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilities, (Object)"capabilities are null");
        this.connector = (OutreachConnector)((Object)Preconditions.checkNotNull((Object)((Object)connector), (Object)"connector is null"));
        this.status = (ApplicationStatusSource)Preconditions.checkNotNull((Object)status, (Object)"status source is null");
        try {
            this.tmpdir = ((ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration)).getTemporaryDirectory().getCanonicalFile();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.alwaysRefresh = alwaysRefresh;
        eventBus.register((Object)this);
    }

    private String s(String part) {
        return part.charAt(0) == '/' ? part : "/" + part;
    }

    private String sha(String s) {
        return DigesterUtils.getSha1Digest((String)s);
    }

    @Override
    public PageBundle getPageBundle(Outreach.User user, Locale locale) {
        PageBundle bundle;
        String edition = this.status.getSystemStatus().getEditionShort().toLowerCase(Locale.US);
        String version = this.status.getSystemStatus().getVersion();
        String url = OutreachManagementCapability.getOverrideUrl(this.capabilities);
        if (StringUtils.isEmpty((String)url)) {
            url = OutreachManagementCapability.getBaseUrl(this.capabilities);
            url = url + this.s(edition) + this.s(version) + this.s(locale.getLanguage() + this.s(user.toString()));
        }
        this.log.trace("URL: {}", (Object)url);
        String id = this.sha(url);
        if (this.bundles.containsKey(id)) {
            bundle = this.bundles.get(id);
        } else {
            bundle = new PageBundle(this.tmpdir, id);
            this.bundles.put(bundle.getId(), bundle);
        }
        if (OutreachManagementCapability.isDisabled(this.capabilities)) {
            return bundle;
        }
        try {
            if (!bundle.exists() && bundle.lastModified() == 0L) {
                this.remote(url, bundle);
            } else if (this.needsRefresh(bundle)) {
                this.remote(url, bundle);
            }
        }
        catch (IOException e) {
            LogUtils.logThrowable(this.log, "Could not download page bundle", e);
        }
        return bundle;
    }

    @VisibleForTesting
    synchronized void remote(String url, PageBundle bundle) throws IOException {
        OutreachConnector.Response head;
        Preconditions.checkNotNull((Object)url, (Object)"url must not be null");
        Preconditions.checkNotNull((Object)((Object)bundle), (Object)"bundle must not be null");
        this.log.trace("checking remote {} for bundle {}", (Object)url, (Object)bundle);
        if (bundle.lastModified() != 0L && !OutreachManagementCapability.isCachingDisabled(this.capabilities) && (head = this.connector.head(url)).isSuccess() && head.lastModified() != null && head.lastModified().isBefore(bundle.lastModified())) {
            bundle.updated();
            return;
        }
        OutreachConnector.Response get = this.connector.get(url);
        StatusLine statusLine = get.getStatusLine();
        if (get.isSuccess()) {
            bundle.use(get.getFile());
        } else {
            bundle.updated();
            if (this.log.isInfoEnabled()) {
                this.log.info("Outreach bundle unavailable {} ({}:{})", new Object[]{url, statusLine.getStatusCode(), statusLine.getReasonPhrase()});
            }
        }
    }

    @VisibleForTesting
    boolean needsRefresh(PageBundle bundle) throws IOException {
        PageBundleMetadata metadata = bundle.getMetaData();
        long timestamp = bundle.lastModified();
        if (this.alwaysRefresh || OutreachManagementCapability.isCachingDisabled(this.capabilities)) {
            return true;
        }
        if (new DateTime(timestamp).plus((ReadablePeriod)Hours.ONE).isAfterNow()) {
            return false;
        }
        DateTime reference = metadata.getExpires();
        if (reference == null) {
            reference = new DateTime(timestamp).plus((ReadablePeriod)Days.ONE);
        }
        return reference.isBeforeNow();
    }

    @Subscribe
    public void on(NexusStoppedEvent event) {
        this.eventBus.unregister((Object)this);
        for (PageBundle pageBundle : this.bundles.values()) {
            pageBundle.dispose();
        }
    }
}

