/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class PageBundleMetadata
extends ComponentSupport {
    private DateTime expires;

    public PageBundleMetadata() {
        this.setup(new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageBundleMetadata(File mdFile) throws IOException {
        this.log.trace("setting up bundle metadata from file: {} (exists: {})", (Object)mdFile, (Object)mdFile.exists());
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(mdFile);){
            properties.load(inputStream);
            this.setup(properties);
        }
    }

    @VisibleForTesting
    PageBundleMetadata(Properties properties) {
        this.setup(properties);
    }

    private void setup(Properties properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"Properties must not be null");
        this.log.trace("setting up metadata from properties: {}", (Object)properties.size());
        String expires = properties.getProperty("expires");
        String format = properties.getProperty("expires.format");
        if (expires != null) {
            DateTimeFormatter fmt = null;
            if (format != null) {
                try {
                    fmt = DateTimeFormat.forPattern((String)format);
                }
                catch (IllegalArgumentException e) {
                    this.log.info("Could not create formatter for '{}'", (Object)e.toString());
                }
            }
            if (fmt == null) {
                fmt = ISODateTimeFormat.dateTimeNoMillis();
            }
            try {
                this.log.trace("parsing expires date: {}", (Object)expires);
                this.expires = fmt.parseDateTime(expires);
            }
            catch (IllegalArgumentException e) {
                this.log.info("Could not format 'expire' metadata: '{}' (format: {})", (Object)expires, (Object)(format == null ? "yyyy-MM-dd'T'HH:mm:ssZZ" : format));
            }
        }
    }

    public DateTime getExpires() {
        return this.expires;
    }
}

