/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class PageBundleEntry
extends ComponentSupport {
    private final ZipEntry entry;
    private final ZipFile zip;

    public PageBundleEntry(ZipFile zip, ZipEntry entry) {
        this.entry = entry;
        this.zip = zip;
    }

    public InputSupplier<InputStream> getContent() {
        if (this.exists()) {
            return new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return PageBundleEntry.this.zip.getInputStream(PageBundleEntry.this.entry);
                }
            };
        }
        return null;
    }

    public boolean exists() {
        return this.entry != null;
    }

    public String getName() {
        if (this.exists()) {
            return this.entry.getName();
        }
        return null;
    }

    public long getTime() {
        return this.entry.getTime();
    }

    public long getSize() {
        return this.entry.getSize();
    }

    public static class MissingPageBundleEntry
    extends PageBundleEntry {
        private final String name;

        public MissingPageBundleEntry(String name) {
            super(null, null);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

