/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.outreach.OutreachPlugin;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
public class OutreachConnector
extends ComponentSupport {
    private final OutreachPlugin plugin;
    private final Hc4Provider hc4Provider;

    @Inject
    public OutreachConnector(OutreachPlugin plugin, Hc4Provider hc4Provider) {
        this.plugin = (OutreachPlugin)((Object)Preconditions.checkNotNull((Object)((Object)plugin)));
        this.hc4Provider = (Hc4Provider)Preconditions.checkNotNull((Object)hc4Provider);
    }

    private HttpClient client() {
        return this.hc4Provider.createHttpClient();
    }

    public Response head(String url) throws IOException {
        HttpHead head = new HttpHead(url);
        return new Response(this.client().execute((HttpUriRequest)head));
    }

    public Response get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        return new Response(this.client().execute((HttpUriRequest)get));
    }

    public class Response {
        private final StatusLine statusLine;
        private DateTime lastModified;
        private File file;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Response(HttpResponse response) throws IOException {
            block17: {
                Date date;
                this.statusLine = response.getStatusLine();
                Header header = response.getFirstHeader("last-modified");
                if (header != null && (date = DateUtils.parseDate((String)header.getValue())) != null) {
                    this.lastModified = new DateTime((Object)date);
                }
                if (response.getEntity() != null) {
                    try {
                        if (this.statusLine.getStatusCode() != 200) break block17;
                        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getFile()));){
                            response.getEntity().writeTo((OutputStream)output);
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
            }
        }

        public DateTime lastModified() {
            return this.lastModified;
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(OutreachConnector.this.plugin.getTemporaryDirectory(), this.createFileName());
            }
            return this.file;
        }

        private String createFileName() {
            return UUID.randomUUID().toString().replace("-", "") + ".tmp";
        }

        public StatusLine getStatusLine() {
            return this.statusLine;
        }

        public boolean isSuccess() {
            return this.statusLine.getStatusCode() >= 200 && this.statusLine.getStatusCode() < 300;
        }
    }
}

